/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CodeFragmentFactoryContextWrapper
extends CodeFragmentFactory {
    public static final Key<Value> LABEL_VARIABLE_VALUE_KEY = Key.create((String)"_label_variable_value_key_");
    public static final String DEBUG_LABEL_SUFFIX = "_DebugLabel";
    private final CodeFragmentFactory myDelegate;

    public CodeFragmentFactoryContextWrapper(CodeFragmentFactory delegate) {
        this.myDelegate = delegate;
    }

    public JavaCodeFragment createCodeFragment(TextWithImports item, PsiElement context, Project project2) {
        return CodeFragmentFactoryContextWrapper.prepareResolveScope(this.myDelegate.createCodeFragment(item, this.wrapContext(project2, context), project2));
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports item, PsiElement context, Project project2) {
        return CodeFragmentFactoryContextWrapper.prepareResolveScope(this.myDelegate.createPresentationCodeFragment(item, this.wrapContext(project2, context), project2));
    }

    public boolean isContextAccepted(PsiElement contextElement) {
        return this.myDelegate.isContextAccepted(contextElement);
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType = this.myDelegate.getFileType();
        if (languageFileType == null) {
            CodeFragmentFactoryContextWrapper.$$$reportNull$$$0(0);
        }
        return languageFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return this.myDelegate.getEvaluatorBuilder();
    }

    private static JavaCodeFragment prepareResolveScope(JavaCodeFragment codeFragment) {
        final GlobalSearchScope originalResolveScope = codeFragment.getResolveScope();
        codeFragment.forceResolveScope((GlobalSearchScope)new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)codeFragment.getProject())){
            final Comparator<VirtualFile> myScopeComparator;
            {
                super(arg0);
                this.myScopeComparator = Comparator.comparing(arg_0 -> ((GlobalSearchScope)originalResolveScope).contains(arg_0)).thenComparing((x$0, x$1) -> super.compare(x$0, x$1));
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.myScopeComparator.compare(file1, file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/engine/evaluation/CodeFragmentFactoryContextWrapper$1";
                objectArray[2] = "compare";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return codeFragment;
    }

    private PsiElement wrapContext(Project project2, PsiElement originalContext) {
        if (project2.isDefault()) {
            return originalContext;
        }
        if (!(this.myDelegate instanceof DefaultCodeFragmentFactory)) {
            return originalContext;
        }
        PsiElement context = originalContext;
        XDebugSession session = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        if (session != null) {
            Pair<String, Map<String, ObjectReference>> markupVariables;
            String text;
            Map markupMap;
            XValueMarkers markers = ((XDebugSessionImpl)session).getValueMarkers();
            Map map = markupMap = markers != null ? markers.getAllMarkers() : null;
            if (!ContainerUtil.isEmpty((Map)markupMap) && !StringUtil.isEmpty((String)(text = (String)(markupVariables = CodeFragmentFactoryContextWrapper.createMarkupVariablesText(markupMap)).getFirst()))) {
                PsiCodeBlock codeFragment = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createCodeBlockFromText("{" + text + "}", context);
                codeFragment.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                    public void visitLocalVariable(PsiLocalVariable variable) {
                        String name2 = variable.getName();
                        variable.putUserData(LABEL_VARIABLE_VALUE_KEY, ((Map)markupVariables.getSecond()).get(name2));
                    }
                });
                context = codeFragment;
            }
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pair<String, Map<String, ObjectReference>> createMarkupVariablesText(Map<?, ValueMarkup> markupMap) {
        HashMap<String, ObjectReference> reverseMap = new HashMap<String, ObjectReference>();
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            for (Map.Entry<?, ValueMarkup> entry : markupMap.entrySet()) {
                ObjectReference objectRef = (ObjectReference)entry.getKey();
                ValueMarkup markup = entry.getValue();
                String labelName = markup.getText();
                if (!StringUtil.isJavaIdentifier((String)labelName)) continue;
                try {
                    String typeName = objectRef.type().name();
                    labelName = labelName + DEBUG_LABEL_SUFFIX;
                    if (buffer.length() > 0) {
                        buffer.append("\n");
                    }
                    buffer.append(typeName).append(" ").append(labelName).append(";");
                    reverseMap.put(labelName, objectRef);
                }
                catch (ObjectCollectedException objectCollectedException) {}
            }
            Pair pair2 = Pair.create((Object)buffer.toString(), reverseMap);
            return pair2;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/CodeFragmentFactoryContextWrapper", "getFileType"));
    }
}

