/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.ui;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.memory.filtering.FilteringResult;
import com.intellij.debugger.memory.filtering.FilteringTask;
import com.intellij.debugger.memory.filtering.FilteringTaskCallback;
import com.intellij.debugger.memory.ui.ExpressionEditorWithHistory;
import com.intellij.debugger.memory.ui.FilteringProgressView;
import com.intellij.debugger.memory.ui.InstancesTree;
import com.intellij.debugger.memory.ui.InstancesWithStackFrameView;
import com.intellij.debugger.memory.ui.StackFrameList;
import com.intellij.debugger.memory.utils.AndroidUtil;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.memory.utils.InstanceValueDescriptor;
import com.intellij.debugger.memory.utils.InstancesProvider;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class InstancesWindow
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(InstancesWindow.class);
    private static final int DEFAULT_WINDOW_WIDTH = 870;
    private static final int DEFAULT_WINDOW_HEIGHT = 400;
    private static final int FILTERING_BUTTON_ADDITIONAL_WIDTH = 30;
    private static final int BORDER_LAYOUT_DEFAULT_GAP = 5;
    private static final int DEFAULT_INSTANCES_LIMIT = 500000;
    private final Project myProject;
    private final DebugProcessImpl myDebugProcess;
    private final InstancesProvider myInstancesProvider;
    private final String myClassName;
    private final MyInstancesView myInstancesView;

    public InstancesWindow(@NotNull XDebugSession session, @NotNull InstancesProvider provider, @NotNull String className) {
        if (session == null) {
            InstancesWindow.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            InstancesWindow.$$$reportNull$$$0(1);
        }
        if (className == null) {
            InstancesWindow.$$$reportNull$$$0(2);
        }
        super(session.getProject(), false);
        this.myProject = session.getProject();
        this.myDebugProcess = (DebugProcessImpl)DebuggerManager.getInstance((Project)this.myProject).getDebugProcess(session.getDebugProcess().getProcessHandler());
        this.myInstancesProvider = provider;
        this.myClassName = className;
        this.addWarningMessage(null);
        session.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesWindow.this.close(0));
            }
        }, this.myDisposable);
        this.setModal(false);
        this.myInstancesView = new MyInstancesView(session);
        this.myInstancesView.setPreferredSize((Dimension)new JBDimension(870, 400));
        this.init();
        JRootPane root = this.myInstancesView.getRootPane();
        root.setDefaultButton(this.myInstancesView.myFilterButton);
    }

    private void addWarningMessage(@Nullable String message) {
        String warning = message == null ? "" : String.format(". Warning: %s", message);
        this.setTitle(String.format("Instances of %s%s", this.myClassName, warning));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        if ("#org.jetbrains.debugger.memory.view.InstancesWindow" == null) {
            InstancesWindow.$$$reportNull$$$0(3);
        }
        return "#org.jetbrains.debugger.memory.view.InstancesWindow";
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myInstancesView;
    }

    @Nullable
    protected JComponent createSouthPanel() {
        JComponent comp = super.createSouthPanel();
        if (comp != null) {
            comp.add((Component)((Object)this.myInstancesView.myProgress), "West");
        }
        return comp;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "Close", 1)};
        if (actionArray == null) {
            InstancesWindow.$$$reportNull$$$0(4);
        }
        return actionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/ui/InstancesWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWindow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDimensionServiceKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project2) {
            super(project2, null);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor2, EvaluationContext evaluationContext) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, descriptor2);
            if (debuggerTreeNodeImpl == null) {
                MyNodeManager.$$$reportNull$$$0(0);
            }
            return debuggerTreeNodeImpl;
        }

        @Override
        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor2) {
            return new DebuggerTreeNodeImpl(null, descriptor2);
        }

        @Override
        @NotNull
        public DebuggerTreeNodeImpl createMessageNode(String message) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = new DebuggerTreeNodeImpl(null, new MessageDescriptor(message));
            if (debuggerTreeNodeImpl == null) {
                MyNodeManager.$$$reportNull$$$0(1);
            }
            return debuggerTreeNodeImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/debugger/memory/ui/InstancesWindow$MyNodeManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMessageNode";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyValuesList
    implements FilteringTask.ValuesList {
        private final List<ObjectReference> myRefs;

        public MyValuesList(List<ObjectReference> refs) {
            this.myRefs = refs;
        }

        @Override
        public int size() {
            return this.myRefs.size();
        }

        @Override
        public ObjectReference get(int index) {
            return this.myRefs.get(index);
        }
    }

    private class MyInstancesView
    extends JBPanel
    implements Disposable {
        private static final int MAX_TREE_NODE_COUNT = 2000;
        private static final int FILTERING_CHUNK_SIZE = 50;
        private static final int MAX_DURATION_TO_UPDATE_TREE_SECONDS = 3;
        private static final int FILTERING_PROGRESS_UPDATING_MIN_DELAY_MILLIS = 17;
        private final InstancesTree myInstancesTree;
        private final XDebuggerExpressionEditor myFilterConditionEditor;
        private final XDebugSessionListener myDebugSessionListener;
        private final MyNodeManager myNodeManager;
        private final JButton myFilterButton;
        private final FilteringProgressView myProgress;
        private final Object myFilteringTaskLock;
        private boolean myIsAndroidVM;
        private volatile MyFilteringWorker myFilteringTask;

        MyInstancesView(XDebugSession session) {
            if (session == null) {
                MyInstancesView.$$$reportNull$$$0(0);
            }
            super((LayoutManager)new BorderLayout(0, JBUI.scale((int)5)));
            this.myDebugSessionListener = new MySessionListener();
            this.myNodeManager = new MyNodeManager(InstancesWindow.this.myProject);
            this.myFilterButton = new JButton("Filter");
            this.myProgress = new FilteringProgressView();
            this.myFilteringTaskLock = new Object();
            this.myIsAndroidVM = false;
            this.myFilteringTask = null;
            Disposer.register((Disposable)InstancesWindow.this.myDisposable, (Disposable)this);
            XValueMarkers<?, ?> markers = this.getValueMarkers(session);
            if (markers != null) {
                MyActionListener listener = new MyActionListener(markers);
                ActionManager.getInstance().addAnActionListener((AnActionListener)listener, InstancesWindow.this.myDisposable);
            }
            session.addSessionListener(this.myDebugSessionListener, InstancesWindow.this.myDisposable);
            JavaDebuggerEditorsProvider editorsProvider = new JavaDebuggerEditorsProvider();
            this.myFilterConditionEditor = new ExpressionEditorWithHistory(InstancesWindow.this.myProject, InstancesWindow.this.myClassName, (XDebuggerEditorsProvider)editorsProvider, InstancesWindow.this.myDisposable);
            Dimension filteringButtonSize = this.myFilterConditionEditor.getEditorComponent().getPreferredSize();
            filteringButtonSize.width = JBUI.scale((int)30) + this.myFilterButton.getPreferredSize().width;
            this.myFilterButton.setPreferredSize(filteringButtonSize);
            JBPanel filteringPane = new JBPanel((LayoutManager)new BorderLayout(JBUI.scale((int)5), 0));
            JBLabel sideEffectsWarning = new JBLabel("Warning: filtering may have side effects", 4);
            sideEffectsWarning.setBorder((Border)JBUI.Borders.emptyTop((int)1));
            sideEffectsWarning.setComponentStyle(UIUtil.ComponentStyle.SMALL);
            sideEffectsWarning.setFontColor(UIUtil.FontColor.BRIGHTER);
            filteringPane.add((Component)new JBLabel("Condition:"), (Object)"West");
            filteringPane.add((Component)this.myFilterConditionEditor.getComponent(), (Object)"Center");
            filteringPane.add((Component)this.myFilterButton, (Object)"East");
            filteringPane.add((Component)sideEffectsWarning, (Object)"South");
            this.myProgress.addStopActionListener(this::cancelFilteringTask);
            this.myInstancesTree = new InstancesTree(InstancesWindow.this.myProject, (XDebuggerEditorsProvider)editorsProvider, markers, this::updateInstances);
            this.myFilterButton.addActionListener(e -> {
                String expression = this.myFilterConditionEditor.getExpression().getExpression();
                if (!expression.isEmpty()) {
                    this.myFilterConditionEditor.saveTextInHistory();
                }
                this.myFilterButton.setEnabled(false);
                this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
            });
            final StackFrameList list = new StackFrameList(InstancesWindow.this.myDebugProcess);
            list.addListSelectionListener(e -> list.navigateToSelectedValue(false));
            new DoubleClickListener(){

                protected boolean onDoubleClick(MouseEvent event) {
                    list.navigateToSelectedValue(true);
                    return true;
                }
            }.installOn((Component)((Object)list));
            InstancesWithStackFrameView instancesWithStackFrame = new InstancesWithStackFrameView(session, this.myInstancesTree, list, InstancesWindow.this.myClassName);
            this.add((Component)filteringPane, "North");
            this.add(instancesWithStackFrame.getComponent(), "Center");
            JComponent focusedComponent = this.myFilterConditionEditor.getEditorComponent();
            UiNotifyConnector.doWhenFirstShown((JComponent)focusedComponent, () -> IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, true));
        }

        public void dispose() {
            this.cancelFilteringTask();
            Disposer.dispose((Disposable)this.myInstancesTree);
        }

        private void updateInstances() {
            this.cancelFilteringTask();
            final XExpression filteringExpression = this.myFilterConditionEditor.getExpression();
            InstancesWindow.this.myDebugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(InstancesWindow.this.myDebugProcess.getDebuggerContext()){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.LOWEST;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MyInstancesView.this.myIsAndroidVM = AndroidUtil.isAndroidVM(InstancesWindow.this.myDebugProcess.getVirtualMachineProxy().getVirtualMachine());
                    int limit = MyInstancesView.this.myIsAndroidVM ? 30000 : 500000;
                    List<ObjectReference> instances = InstancesWindow.this.myInstancesProvider.getInstances(limit + 1);
                    EvaluationContextImpl evaluationContext = InstancesWindow.this.myDebugProcess.getDebuggerContext().createEvaluationContext();
                    if (instances.size() > limit) {
                        InstancesWindow.this.addWarningMessage(String.format("Not all instances will be loaded (only %d)", limit));
                        instances = instances.subList(0, limit);
                    }
                    if (evaluationContext != null) {
                        Object object = MyInstancesView.this.myFilteringTaskLock;
                        synchronized (object) {
                            MyInstancesView.this.myFilteringTask = new MyFilteringWorker(instances, filteringExpression, evaluationContext);
                            MyInstancesView.this.myFilteringTask.execute();
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$2", "threadAction"));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelFilteringTask() {
            if (this.myFilteringTask != null) {
                Object object = this.myFilteringTaskLock;
                synchronized (object) {
                    if (this.myFilteringTask != null) {
                        this.myFilteringTask.cancel();
                        this.myFilteringTask = null;
                    }
                }
            }
        }

        private XValueMarkers<?, ?> getValueMarkers(@NotNull XDebugSession session) {
            if (session == null) {
                MyInstancesView.$$$reportNull$$$0(1);
            }
            return session instanceof XDebugSessionImpl ? ((XDebugSessionImpl)session).getValueMarkers() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "session";
            objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getValueMarkers";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyFilteringWorker
        extends SwingWorker<Void, Void> {
            private final FilteringTask myTask;

            MyFilteringWorker(@NotNull List<ObjectReference> refs, @NotNull XExpression expression, EvaluationContextImpl evaluationContext) {
                if (refs == null) {
                    MyFilteringWorker.$$$reportNull$$$0(0);
                }
                if (expression == null) {
                    MyFilteringWorker.$$$reportNull$$$0(1);
                }
                if (evaluationContext == null) {
                    MyFilteringWorker.$$$reportNull$$$0(2);
                }
                this.myTask = new FilteringTask(InstancesWindow.this.myClassName, InstancesWindow.this.myDebugProcess, expression, new MyValuesList(refs), new MyFilteringCallback(evaluationContext));
            }

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    this.myTask.run();
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
                return null;
            }

            public void cancel() {
                this.myTask.cancel();
                super.cancel(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "refs";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "evaluationContext";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyFilteringWorker";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private class MyFilteringCallback
        implements FilteringTaskCallback {
            private final ErrorsValueGroup myErrorsGroup;
            private final EvaluationContextImpl myEvaluationContext;
            private long myFilteringStartedTime;
            private int myProceedCount;
            private int myMatchedCount;
            private int myErrorsCount;
            private long myLastTreeUpdatingTime;
            private long myLastProgressUpdatingTime;
            private XValueChildrenList myChildren;

            public MyFilteringCallback(EvaluationContextImpl evaluationContext) {
                if (evaluationContext == null) {
                    MyFilteringCallback.$$$reportNull$$$0(0);
                }
                this.myErrorsGroup = new ErrorsValueGroup();
                this.myProceedCount = 0;
                this.myMatchedCount = 0;
                this.myErrorsCount = 0;
                this.myChildren = new XValueChildrenList();
                this.myEvaluationContext = evaluationContext;
            }

            @Override
            public void started(int total) {
                this.myLastTreeUpdatingTime = this.myFilteringStartedTime = System.nanoTime();
                this.myLastProgressUpdatingTime = System.nanoTime();
                ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myProgress.start(total));
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action matched(@NotNull Value ref) {
                if (ref == null) {
                    MyFilteringCallback.$$$reportNull$$$0(1);
                }
                InstanceJavaValue val = new InstanceJavaValue(new InstanceValueDescriptor(InstancesWindow.this.myProject, ref), this.myEvaluationContext, MyInstancesView.this.myNodeManager);
                ++this.myMatchedCount;
                ++this.myProceedCount;
                this.myChildren.add((XNamedValue)val);
                this.updateProgress();
                this.updateTree();
                FilteringTaskCallback.Action action = this.myMatchedCount < 2000 ? FilteringTaskCallback.Action.CONTINUE : FilteringTaskCallback.Action.STOP;
                if (action == null) {
                    MyFilteringCallback.$$$reportNull$$$0(2);
                }
                return action;
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action notMatched(@NotNull Value ref) {
                if (ref == null) {
                    MyFilteringCallback.$$$reportNull$$$0(3);
                }
                ++this.myProceedCount;
                this.updateProgress();
                FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
                if (action == null) {
                    MyFilteringCallback.$$$reportNull$$$0(4);
                }
                return action;
            }

            @Override
            @NotNull
            public FilteringTaskCallback.Action error(@NotNull Value ref, @NotNull String description) {
                if (ref == null) {
                    MyFilteringCallback.$$$reportNull$$$0(5);
                }
                if (description == null) {
                    MyFilteringCallback.$$$reportNull$$$0(6);
                }
                InstanceJavaValue val = new InstanceJavaValue(new InstanceValueDescriptor(InstancesWindow.this.myProject, ref), this.myEvaluationContext, MyInstancesView.this.myNodeManager);
                this.myErrorsGroup.addErrorValue(description, val);
                ++this.myProceedCount;
                ++this.myErrorsCount;
                this.updateProgress();
                FilteringTaskCallback.Action action = FilteringTaskCallback.Action.CONTINUE;
                if (action == null) {
                    MyFilteringCallback.$$$reportNull$$$0(7);
                }
                return action;
            }

            @Override
            public void completed(@NotNull FilteringResult reason) {
                if (reason == null) {
                    MyFilteringCallback.$$$reportNull$$$0(8);
                }
                if (!this.myErrorsGroup.isEmpty()) {
                    this.myChildren.addBottomGroup((XValueGroup)this.myErrorsGroup);
                }
                long duration = System.nanoTime() - this.myFilteringStartedTime;
                LOG.info(String.format("Filtering completed in %d ms for %d instances", TimeUnit.NANOSECONDS.toMillis(duration), this.myProceedCount));
                int proceed = this.myProceedCount;
                int matched = this.myMatchedCount;
                int errors = this.myErrorsCount;
                XValueChildrenList childrenList = this.myChildren;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (reason == null) {
                        MyFilteringCallback.$$$reportNull$$$0(9);
                    }
                    MyInstancesView.this.myProgress.updateProgress(proceed, matched, errors);
                    MyInstancesView.this.myInstancesTree.addChildren(childrenList, true);
                    MyInstancesView.this.myFilterButton.setEnabled(true);
                    MyInstancesView.this.myProgress.complete(reason);
                });
            }

            private void updateProgress() {
                long now = System.nanoTime();
                if (now - this.myLastProgressUpdatingTime > TimeUnit.MILLISECONDS.toNanos(17L)) {
                    int proceed = this.myProceedCount;
                    int matched = this.myMatchedCount;
                    int errors = this.myErrorsCount;
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myProgress.updateProgress(proceed, matched, errors));
                    this.myLastProgressUpdatingTime = now;
                }
            }

            private void updateTree() {
                long now = System.nanoTime();
                int newChildrenCount = this.myChildren.size();
                if (newChildrenCount >= 50 || newChildrenCount > 0 && now - this.myLastTreeUpdatingTime > TimeUnit.SECONDS.toNanos(3L)) {
                    XValueChildrenList children = this.myChildren;
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myInstancesTree.addChildren(children, false));
                    this.myChildren = new XValueChildrenList();
                    this.myLastTreeUpdatingTime = System.nanoTime();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "evaluationContext";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ref";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyFilteringCallback";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "description";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reason";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyFilteringCallback";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "matched";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "notMatched";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "error";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "matched";
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "notMatched";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "error";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "completed";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$completed$1";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 7: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyActionListener
        extends AnActionListener.Adapter {
            private final XValueMarkers<?, ?> myValueMarkers;

            private MyActionListener(XValueMarkers<?, ?> markers) {
                if (markers == null) {
                    MyActionListener.$$$reportNull$$$0(0);
                }
                this.myValueMarkers = markers;
            }

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                XValueNodeImpl selectedNode;
                if (dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT) == MyInstancesView.this.myInstancesTree && (this.isAddToWatchesAction(action) || this.isEvaluateExpressionAction(action)) && (selectedNode = XDebuggerTreeActionBase.getSelectedNode((DataContext)dataContext)) != null) {
                    Object currentNode = selectedNode;
                    while (!MyInstancesView.this.myInstancesTree.getRoot().equals(currentNode.getParent())) {
                        currentNode = currentNode.getParent();
                    }
                    XValue valueContainer = (XValue)currentNode.getValueContainer();
                    String expression = valueContainer.getEvaluationExpression();
                    if (expression != null) {
                        this.myValueMarkers.markValue(valueContainer, new ValueMarkup(expression.replace("@", ""), (Color)new JBColor(0, 0), null));
                    }
                    ApplicationManager.getApplication().invokeLater(() -> MyInstancesView.this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.ONLY_UPDATE_LABELS));
                }
            }

            private boolean isAddToWatchesAction(AnAction action) {
                String className = action.getClass().getSimpleName();
                return action instanceof XDebuggerTreeActionBase && className.equals("XAddToWatchesAction");
            }

            private boolean isEvaluateExpressionAction(AnAction action) {
                String className = action.getClass().getSimpleName();
                return action instanceof XDebuggerActionBase && className.equals("EvaluateAction");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "markers", "com/intellij/debugger/memory/ui/InstancesWindow$MyInstancesView$MyActionListener", "<init>"));
            }
        }

        private class MySessionListener
        implements XDebugSessionListener {
            private volatile XDebuggerTreeState myTreeState = null;

            private MySessionListener() {
            }

            public void sessionResumed() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myTreeState = XDebuggerTreeState.saveState((XDebuggerTree)MyInstancesView.this.myInstancesTree);
                    MyInstancesView.this.cancelFilteringTask();
                    MyInstancesView.this.myInstancesTree.setInfoMessage("The application is running");
                });
            }

            public void sessionPaused() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    MyInstancesView.this.myProgress.setVisible(true);
                    XDebuggerTreeState state = this.myTreeState;
                    if (state != null) {
                        MyInstancesView.this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES, state);
                    } else {
                        MyInstancesView.this.myInstancesTree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
                    }
                });
            }
        }
    }
}

