/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class EnumerationChildrenRenderer
extends TypeRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "EnumerationChildrenRenderer";
    private boolean myAppendDefaultChildren;
    private List<ChildInfo> myChildren;
    @NonNls
    public static final String APPEND_DEFAULT_NAME = "AppendDefault";
    @NonNls
    public static final String CHILDREN_EXPRESSION = "ChildrenExpression";
    @NonNls
    public static final String CHILD_NAME = "Name";
    @NonNls
    public static final String CHILD_ONDEMAND = "OnDemand";

    public EnumerationChildrenRenderer() {
        this(new ArrayList<ChildInfo>());
    }

    public EnumerationChildrenRenderer(List<ChildInfo> children) {
        this.myChildren = children;
    }

    public void setAppendDefaultChildren(boolean appendDefaultChildren) {
        this.myAppendDefaultChildren = appendDefaultChildren;
    }

    public boolean isAppendDefaultChildren() {
        return this.myAppendDefaultChildren;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public EnumerationChildrenRenderer clone() {
        return (EnumerationChildrenRenderer)super.clone();
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myChildren.clear();
        this.myAppendDefaultChildren = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)APPEND_DEFAULT_NAME));
        List children = element.getChildren(CHILDREN_EXPRESSION);
        for (Element item : children) {
            String name2 = item.getAttributeValue(CHILD_NAME);
            TextWithImports text = DebuggerUtils.getInstance().readTextWithImports((Element)item.getChildren().get(0));
            boolean onDemand = Boolean.parseBoolean(item.getAttributeValue(CHILD_ONDEMAND));
            this.myChildren.add(new ChildInfo(name2, text, onDemand));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myAppendDefaultChildren) {
            JDOMExternalizerUtil.writeField((Element)element, (String)APPEND_DEFAULT_NAME, (String)"true");
        }
        for (ChildInfo childInfo : this.myChildren) {
            Element child = new Element(CHILDREN_EXPRESSION);
            child.setAttribute(CHILD_NAME, childInfo.myName);
            if (childInfo.myOnDemand) {
                child.setAttribute(CHILD_ONDEMAND, "true");
            }
            child.addContent(DebuggerUtils.getInstance().writeTextWithImports(childInfo.myExpression));
            element.addContent(child);
        }
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = builder.getNodeManager();
        NodeDescriptorFactory descriptorFactory = builder.getDescriptorManager();
        ArrayList<DebuggerTreeNode> children = new ArrayList<DebuggerTreeNode>();
        int idx = 0;
        for (ChildInfo childInfo : this.myChildren) {
            UserExpressionData data = new UserExpressionData((ValueDescriptorImpl)builder.getParentDescriptor(), this.getClassName(), childInfo.myName, childInfo.myExpression);
            data.setEnumerationIndex(idx++);
            UserExpressionDescriptor descriptor2 = descriptorFactory.getUserExpressionDescriptor(builder.getParentDescriptor(), data);
            if (childInfo.myOnDemand) {
                descriptor2.putUserData(OnDemandRenderer.ON_DEMAND_CALCULATED, false);
            }
            children.add(nodeManager.createNode(descriptor2, evaluationContext));
        }
        builder.addChildren(children, !this.myAppendDefaultChildren);
        if (this.myAppendDefaultChildren) {
            DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, builder, evaluationContext);
        }
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return ((ValueDescriptor)node.getDescriptor()).getDescriptorEvaluation(context);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return this.myChildren.size() > 0 || this.myAppendDefaultChildren && DebugProcessImpl.getDefaultRenderer(value).isExpandable(value, evaluationContext, parentDescriptor);
    }

    public List<ChildInfo> getChildren() {
        return this.myChildren;
    }

    public void setChildren(List<ChildInfo> children) {
        this.myChildren = children;
    }

    @Nullable
    public static EnumerationChildrenRenderer getCurrent(ValueDescriptorImpl valueDescriptor) {
        ChildrenRenderer childrenRenderer;
        Renderer renderer = valueDescriptor.getLastRenderer();
        if (renderer instanceof CompoundNodeRenderer && NodeRendererSettings.getInstance().getCustomRenderers().contains((NodeRenderer)renderer) && (childrenRenderer = ((CompoundNodeRenderer)renderer).getChildrenRenderer()) instanceof EnumerationChildrenRenderer) {
            return (EnumerationChildrenRenderer)childrenRenderer;
        }
        return null;
    }

    public static class ChildInfo
    implements Cloneable {
        public String myName;
        public TextWithImports myExpression;
        public boolean myOnDemand;

        public ChildInfo(String name2, TextWithImports expression, boolean onDemand) {
            this.myName = name2;
            this.myExpression = expression;
            this.myOnDemand = onDemand;
        }
    }
}

