/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ToStringRenderer
extends NodeRendererImpl
implements OnDemandRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ToStringRenderer";
    private boolean USE_CLASS_FILTERS = false;
    private boolean ON_DEMAND;
    private ClassFilter[] myClassFilters = ClassFilter.EMPTY_ARRAY;

    public ToStringRenderer() {
        super("unnamed", true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public String getName() {
        return "toString";
    }

    @Override
    public void setName(String name2) {
    }

    @Override
    public ToStringRenderer clone() {
        ToStringRenderer cloned = (ToStringRenderer)super.clone();
        ClassFilter[] classFilters = this.myClassFilters.length > 0 ? new ClassFilter[this.myClassFilters.length] : ClassFilter.EMPTY_ARRAY;
        for (int idx = 0; idx < classFilters.length; ++idx) {
            classFilters[idx] = this.myClassFilters[idx].clone();
        }
        cloned.myClassFilters = classFilters;
        return cloned;
    }

    @Override
    public String calcLabel(final ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, final DescriptorLabelListener labelListener) throws EvaluateException {
        if (!this.isShowValue(valueDescriptor, evaluationContext)) {
            return "";
        }
        final Value value = valueDescriptor.getValue();
        BatchEvaluator.getBatchEvaluator(evaluationContext.getDebugProcess()).invoke(new ToStringCommand(evaluationContext, value){

            @Override
            public void evaluationResult(String message) {
                valueDescriptor.setValueLabel(StringUtil.notNullize((String)message));
                labelListener.labelChanged();
            }

            @Override
            public void evaluationError(String message) {
                String msg = value != null ? message + " " + DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.tostring", (Object[])new Object[]{value.type().name()}) : message;
                valueDescriptor.setValueLabelFailed(new EvaluateException(msg, null));
                labelListener.labelChanged();
            }
        });
        return XDebuggerUIConstants.COLLECTING_DATA_MESSAGE;
    }

    @Override
    @NotNull
    public String getLinkText() {
        String string = DebuggerBundle.message((String)"message.node.toString", (Object[])new Object[0]);
        if (string == null) {
            ToStringRenderer.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isUseClassFilters() {
        return this.USE_CLASS_FILTERS;
    }

    public void setUseClassFilters(boolean value) {
        this.USE_CLASS_FILTERS = value;
    }

    @Override
    public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        if (this.ON_DEMAND || this.USE_CLASS_FILTERS && !this.isFiltered(valueDescriptor.getType())) {
            return true;
        }
        return OnDemandRenderer.super.isOnDemand(evaluationContext, valueDescriptor);
    }

    @Override
    public boolean isApplicable(Type type) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        if ("java.lang.String".equals(type.name())) {
            return false;
        }
        return ToStringRenderer.overridesToString(type);
    }

    private static boolean overridesToString(Type type) {
        if (type instanceof ClassType) {
            Method toStringMethod = ((ClassType)type).concreteMethodByName("toString", "()Ljava/lang/String;");
            return toStringMethod != null && !"java.lang.Object".equals(toStringMethod.declaringType().name());
        }
        return false;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
        DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, builder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return DebugProcessImpl.getDefaultRenderer(((ValueDescriptor)node.getParent().getDescriptor()).getType()).getChildValueExpression(node, context);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return DebugProcessImpl.getDefaultRenderer(value).isExpandable(value, evaluationContext, parentDescriptor);
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.ON_DEMAND = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"ON_DEMAND"));
        this.USE_CLASS_FILTERS = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_CLASS_FILTERS"));
        this.myClassFilters = DebuggerUtilsEx.readFilters(element.getChildren("filter"));
    }

    @Override
    public void writeExternal(Element element) {
        super.writeExternal(element);
        if (this.ON_DEMAND) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"ON_DEMAND", (String)"true");
        }
        if (this.USE_CLASS_FILTERS) {
            JDOMExternalizerUtil.writeField((Element)element, (String)"USE_CLASS_FILTERS", (String)"true");
        }
        DebuggerUtilsEx.writeFilters(element, "filter", this.myClassFilters);
    }

    public ClassFilter[] getClassFilters() {
        return this.myClassFilters;
    }

    public void setClassFilters(ClassFilter[] classFilters) {
        this.myClassFilters = classFilters != null ? classFilters : ClassFilter.EMPTY_ARRAY;
    }

    private boolean isFiltered(Type t) {
        if (t instanceof ReferenceType) {
            for (ClassFilter classFilter : this.myClassFilters) {
                if (!classFilter.isEnabled() || !DebuggerUtils.instanceOf((Type)t, (String)classFilter.getPattern())) continue;
                return true;
            }
        }
        return DebuggerUtilsEx.isFiltered(t.name(), this.myClassFilters);
    }

    public boolean isOnDemand() {
        return this.ON_DEMAND;
    }

    public void setOnDemand(boolean value) {
        this.ON_DEMAND = value;
    }

    @Override
    public boolean hasOverhead() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/ToStringRenderer", "getLinkText"));
    }
}

