/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.TestDiscoveryListener;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rt.coverage.data.TestDiscoveryProjectData;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoveryExtension
extends RunConfigurationExtension {
    private static final Logger LOG = Logger.getInstance(TestDiscoveryExtension.class);
    private static final Object ourTracesLock = new Object();

    @NotNull
    public String getSerializationId() {
        if ("testDiscovery" == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(0);
        }
        return "testDiscovery";
    }

    protected void attachToProcess(final @NotNull RunConfigurationBase configuration, final @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(1);
        }
        if (handler == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(2);
        }
        if (runnerSettings == null && this.isApplicableFor(configuration)) {
            final String frameworkPrefix = ((JavaTestConfigurationBase)configuration).getFrameworkPrefix();
            final String moduleName = ((JavaRunConfigurationModule)((JavaTestConfigurationBase)configuration).getConfigurationModule()).getModuleName();
            final Disposable disposable = Disposer.newDisposable();
            final Alarm processTracesAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, disposable);
            final MessageBusConnection connection = configuration.getProject().getMessageBus().connect();
            connection.subscribe(SMTRunnerEventsListener.TEST_STATUS, (Object)new SMTRunnerEventsAdapter(){
                private final List<String> myCompletedMethodNames = new ArrayList<String>();

                public void onTestFinished(@NotNull SMTestProxy test) {
                    String fullTestName;
                    SMTestProxy.SMRootTestProxy root;
                    if (test == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (((root = test.getRoot()) == null || root.getHandler() == handler) && (fullTestName = test.getLocationUrl()) != null && fullTestName.startsWith("java:test")) {
                        this.myCompletedMethodNames.add(frameworkPrefix + fullTestName.substring("java:test".length() + 3));
                        if (this.myCompletedMethodNames.size() > 50) {
                            String[] fullTestNames = ArrayUtil.toStringArray(this.myCompletedMethodNames);
                            this.myCompletedMethodNames.clear();
                            processTracesAlarm.addRequest(() -> {
                                if (configuration == null) {
                                    1.$$$reportNull$$$0(3);
                                }
                                TestDiscoveryExtension.processAvailableTraces(fullTestNames, TestDiscoveryExtension.getTracesDirectory(configuration), moduleName, frameworkPrefix, TestDiscoveryIndex.getInstance(configuration.getProject()));
                            }, 100);
                        }
                    }
                }

                public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
                    if (testsRoot == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (testsRoot.getHandler() == handler) {
                        processTracesAlarm.cancelAllRequests();
                        processTracesAlarm.addRequest(() -> {
                            if (configuration == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            TestDiscoveryExtension.processAvailableTraces(configuration);
                            Disposer.dispose((Disposable)disposable);
                        }, 0);
                        connection.disconnect();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "test";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "testsRoot";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "configuration";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTestingFinished";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onTestingFinished$1";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "lambda$onTestFinished$0";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    public void updateJavaParameters(RunConfigurationBase configuration, JavaParameters params, RunnerSettings runnerSettings) {
        if (runnerSettings != null || !this.isApplicableFor(configuration)) {
            return;
        }
        StringBuilder argument = new StringBuilder("-javaagent:");
        String agentPath = PathUtil.getJarPathForClass(TestDiscoveryProjectData.class);
        argument.append(agentPath);
        params.getVMParametersList().add(argument.toString());
        params.getClassPath().add(agentPath);
        params.getVMParametersList().addProperty("org.jetbrains.instrumentation.trace.dir", TestDiscoveryExtension.getTracesDirectory(configuration));
    }

    @NotNull
    private static String getTracesDirectory(RunConfigurationBase configuration) {
        String string = TestDiscoveryExtension.baseTestDiscoveryPathForProject(configuration.getProject()) + File.separator + configuration.getUniqueID();
        if (string == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isListenerDisabled(RunConfigurationBase configuration, Object listener, RunnerSettings runnerSettings) {
        return listener instanceof TestDiscoveryListener && (runnerSettings != null || !this.isApplicableFor(configuration));
    }

    public void readExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws InvalidDataException {
        if (runConfiguration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(4);
        }
        if (element == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(5);
        }
    }

    public void writeExternal(@NotNull RunConfigurationBase runConfiguration, @NotNull Element element) throws WriteExternalException {
        if (runConfiguration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(6);
        }
        if (element == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(7);
        }
        throw new WriteExternalException();
    }

    protected boolean isApplicableFor(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(8);
        }
        return configuration instanceof JavaTestConfigurationBase && Registry.is((String)"testDiscovery.enabled");
    }

    @NotNull
    public static Path baseTestDiscoveryPathForProject(Project project2) {
        Path path = ProjectUtil.getProjectCachePath((Project)project2, (String)"testDiscovery", (boolean)true);
        if (path == null) {
            TestDiscoveryExtension.$$$reportNull$$$0(9);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAvailableTraces(RunConfigurationBase configuration) {
        String tracesDirectory = TestDiscoveryExtension.getTracesDirectory(configuration);
        TestDiscoveryIndex coverageIndex = TestDiscoveryIndex.getInstance(configuration.getProject());
        Object object = ourTracesLock;
        synchronized (object) {
            File tracesDirectoryFile = new File(tracesDirectory);
            File[] testMethodTraces = tracesDirectoryFile.listFiles((dir, name2) -> name2.endsWith(".tr"));
            if (testMethodTraces != null) {
                for (File testMethodTrace : testMethodTraces) {
                    try {
                        coverageIndex.updateFromTestTrace(testMethodTrace, ((JavaRunConfigurationModule)((JavaTestConfigurationBase)configuration).getConfigurationModule()).getModuleName(), ((JavaTestConfigurationBase)configuration).getFrameworkPrefix());
                        FileUtil.delete((File)testMethodTrace);
                    }
                    catch (IOException e) {
                        LOG.error("Can not load " + testMethodTrace, (Throwable)e);
                    }
                }
                String[] filesInTracedDirectories = tracesDirectoryFile.list();
                if (filesInTracedDirectories == null || filesInTracedDirectories.length == 0) {
                    FileUtil.delete((File)tracesDirectoryFile);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processAvailableTraces(String[] fullTestNames, String tracesDirectory, String moduleName, String frameworkPrefix, TestDiscoveryIndex discoveryIndex) {
        Object object = ourTracesLock;
        synchronized (object) {
            for (String fullTestName : fullTestNames) {
                File testMethodTrace;
                String className = StringUtil.getPackageName((String)fullTestName);
                String methodName = StringUtil.getShortName((String)fullTestName);
                if (StringUtil.isEmptyOrSpaces((String)className) || StringUtil.isEmptyOrSpaces((String)methodName) || !(testMethodTrace = new File(tracesDirectory, className + "-" + methodName + ".tr")).exists()) continue;
                try {
                    discoveryIndex.updateFromTestTrace(testMethodTrace, moduleName, frameworkPrefix);
                    FileUtil.delete((File)testMethodTrace);
                }
                catch (Throwable e) {
                    LOG.error("Can not load " + testMethodTrace, e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializationId";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/TestDiscoveryExtension";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracesDirectory";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "baseTestDiscoveryPathForProject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

