/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.InheritorChooser;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.AbstractJavaTestConfigurationProducer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractInClassConfigurationProducer<T extends JavaTestConfigurationBase>
extends AbstractJavaTestConfigurationProducer<T> {
    private static final Logger LOG = Logger.getInstance(AbstractInClassConfigurationProducer.class);

    protected AbstractInClassConfigurationProducer(ConfigurationType configurationType) {
        super(configurationType);
    }

    public void onFirstRun(final @NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext fromContext, @NotNull Runnable performRunnable) {
        PsiElement psiElement;
        if (configuration == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (fromContext == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (performRunnable == null) {
            AbstractInClassConfigurationProducer.$$$reportNull$$$0(2);
        }
        if ((psiElement = configuration.getSourceElement()) instanceof PsiMethod || psiElement instanceof PsiClass) {
            PsiClass containingClass;
            PsiMethod psiMethod;
            if (psiElement instanceof PsiMethod) {
                psiMethod = (PsiMethod)psiElement;
                containingClass = psiMethod.getContainingClass();
            } else {
                psiMethod = null;
                containingClass = (PsiClass)psiElement;
            }
            InheritorChooser inheritorChooser = new InheritorChooser(){

                @Override
                protected void runForClasses(List<PsiClass> classes, PsiMethod method, ConfigurationContext context, Runnable performRunnable) {
                    ((JavaTestConfigurationBase)configuration.getConfiguration()).bePatternConfiguration(classes, method);
                    super.runForClasses(classes, method, context, performRunnable);
                }

                @Override
                protected void runForClass(PsiClass aClass, PsiMethod psiMethod, ConfigurationContext context, Runnable performRunnable) {
                    if (psiElement instanceof PsiMethod) {
                        Project project2 = psiMethod.getProject();
                        MethodLocation methodLocation = new MethodLocation(project2, psiMethod, (Location<PsiClass>)PsiLocation.fromPsiElement((PsiElement)aClass));
                        ((JavaTestConfigurationBase)configuration.getConfiguration()).beMethodConfiguration(methodLocation);
                    } else {
                        ((JavaTestConfigurationBase)configuration.getConfiguration()).beClassConfiguration(aClass);
                    }
                    super.runForClass(aClass, psiMethod, context, performRunnable);
                }
            };
            if (inheritorChooser.runMethodInAbstractClass(fromContext, performRunnable, psiMethod, containingClass, (Condition<PsiClass>)((Condition)aClass -> aClass.hasModifierProperty("abstract") && this.isTestClass((PsiClass)aClass)))) {
                return;
            }
        }
        super.onFirstRun(configuration, fromContext, performRunnable);
    }

    protected boolean setupConfigurationFromContext(T configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (this.isMultipleElementsSelected(context)) {
            return false;
        }
        Location contextLocation = context.getLocation();
        this.setupConfigurationParamName(configuration, contextLocation);
        PsiClass psiClass = null;
        for (PsiElement element = context.getPsiLocation(); element != null; element = element.getParent()) {
            PsiClass[] classes;
            if (element instanceof PsiClass && this.isTestClass((PsiClass)element)) {
                psiClass = (PsiClass)element;
                break;
            }
            if (element instanceof PsiMember) {
                PsiClass psiClass2 = contextLocation instanceof MethodLocation ? ((MethodLocation)contextLocation).getContainingClass() : (psiClass = contextLocation instanceof PsiMemberParameterizedLocation ? ((PsiMemberParameterizedLocation)contextLocation).getContainingClass() : ((PsiMember)element).getContainingClass());
                if (!this.isTestClass(psiClass)) continue;
                break;
            }
            if (!(element instanceof PsiClassOwner) || (classes = ((PsiClassOwner)element).getClasses()).length != 1) continue;
            psiClass = classes[0];
            break;
        }
        if (!this.isTestClass(psiClass)) {
            return false;
        }
        PsiClass psiElement = psiClass;
        RunnerAndConfigurationSettings settings = this.cloneTemplateConfiguration(context);
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        ((JavaTestConfigurationBase)configuration).beClassConfiguration(psiClass);
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)context.getPsiLocation(), PsiMethod.class, (boolean)false);
        while (method != null) {
            if (this.isTestMethod(false, method)) {
                ((JavaTestConfigurationBase)configuration).beMethodConfiguration(MethodLocation.elementInClass(method, psiClass));
                psiElement = method;
            }
            method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)method, PsiMethod.class);
        }
        configuration.restoreOriginalModule(originalModule);
        LOG.assertTrue(((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule() != null);
        settings.setName(configuration.getName());
        sourceElement.set((Object)psiElement);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "configuration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fromContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "performRunnable";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/testframework/AbstractInClassConfigurationProducer";
        objectArray[2] = "onFirstRun";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

