/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JreComboboxEditor;
import com.intellij.execution.ui.JreProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrePathEditor
extends JPanel
implements PanelWithAnchor {
    private static final String DEFAULT_JRE_TEXT = "Default";
    private final ComboboxWithBrowseButton myPathField;
    private final JBLabel myLabel = new JBLabel(ExecutionBundle.message((String)"run.configuration.jre.label", (Object[])new Object[0]));
    private final JreComboboxEditor myComboboxEditor;
    private final DefaultJreItem myDefaultJreItem;
    private DefaultJreSelector myDefaultJreSelector;
    private JComponent myAnchor;
    private final SortedComboBoxModel<JreComboBoxItem> myComboBoxModel = new SortedComboBoxModel((o1, o2) -> {
        int result = Comparing.compare((int)o1.getOrder(), (int)o2.getOrder());
        if (result != 0) {
            return result;
        }
        return o1.getPresentableText().compareToIgnoreCase(o2.getPresentableText());
    });
    private String myPreviousCustomJrePath;

    public JrePathEditor(DefaultJreSelector defaultJreSelector) {
        this();
        this.setDefaultJreSelector(defaultJreSelector);
    }

    public JrePathEditor() {
        Sdk[] allJDKs;
        this.myDefaultJreItem = new DefaultJreItem();
        this.myComboBoxModel.add((Object)this.myDefaultJreItem);
        for (Sdk sdk : allJDKs = ProjectJdkTable.getInstance().getAllJdks()) {
            this.myComboBoxModel.add((Object)new SdkAsJreItem(sdk));
        }
        HashSet<String> jrePaths = new HashSet<String>();
        for (JreProvider jreProvider : (JreProvider[])JreProvider.EP_NAME.getExtensions()) {
            String path = jreProvider.getJrePath();
            if (StringUtil.isEmpty((String)path)) continue;
            jrePaths.add(path);
            this.myComboBoxModel.add((Object)new CustomJreItem(path));
        }
        for (JreProvider jreProvider : allJDKs) {
            File jre;
            String homePath = jreProvider.getHomePath();
            if (!SystemInfo.isMac && (jre = new File(jreProvider.getHomePath(), "jre")).isDirectory()) {
                homePath = jre.getPath();
            }
            if (!jrePaths.add(homePath)) continue;
            this.myComboBoxModel.add((Object)new CustomJreItem(homePath));
        }
        ComboBox comboBox = new ComboBox(this.myComboBoxModel, 100);
        comboBox.setEditable(true);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JreComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JreComboBoxItem> list, JreComboBoxItem value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value != null) {
                    value.render((SimpleColoredComponent)this, selected);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/JrePathEditor$1", "customizeCellRenderer"));
            }
        });
        this.myComboboxEditor = new JreComboboxEditor(this.myComboBoxModel);
        this.myComboboxEditor.getEditorComponent().setTextToTriggerEmptyTextStatus(DEFAULT_JRE_TEXT);
        comboBox.setEditor((ComboBoxEditor)this.myComboboxEditor);
        this.myPathField = new ComboboxWithBrowseButton((JComboBox)comboBox);
        this.myPathField.addBrowseFolderListener(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, JreComboboxEditor.TEXT_COMPONENT_ACCESSOR);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 10, fill, flowx"));
        this.add((Component)this.myLabel, "shrinkx");
        this.add((Component)this.myPathField, "growx, pushx");
        InsertPathAction.addTo((JTextComponent)this.myComboboxEditor.getEditorComponent());
        this.setAnchor((JComponent)this.myLabel);
        this.updateUI();
    }

    @Nullable
    public String getJrePathOrName() {
        JreComboBoxItem jre = this.getSelectedJre();
        if (jre instanceof DefaultJreItem) {
            return this.myPreviousCustomJrePath;
        }
        return jre.getPathOrName();
    }

    public boolean isAlternativeJreSelected() {
        return !(this.getSelectedJre() instanceof DefaultJreItem);
    }

    private JreComboBoxItem getSelectedJre() {
        return (JreComboBoxItem)this.myPathField.getComboBox().getEditor().getItem();
    }

    public void setDefaultJreSelector(DefaultJreSelector defaultJreSelector) {
        this.myDefaultJreSelector = defaultJreSelector;
        this.myDefaultJreSelector.addChangeListener(() -> this.updateDefaultJrePresentation());
    }

    public void setPathOrName(@Nullable String pathOrName, boolean useAlternativeJre) {
        JreComboBoxItem toSelect = this.myDefaultJreItem;
        if (!StringUtil.isEmpty((String)pathOrName)) {
            this.myPreviousCustomJrePath = pathOrName;
            JreComboBoxItem alternative = this.findOrAddCustomJre(pathOrName);
            if (useAlternativeJre) {
                toSelect = alternative;
            }
        }
        ((JComboBox)this.myPathField.getChildComponent()).setSelectedItem(toSelect);
        this.updateDefaultJrePresentation();
    }

    private void updateDefaultJrePresentation() {
        StatusText text = this.myComboboxEditor.getEmptyText();
        text.clear();
        text.appendText(DEFAULT_JRE_TEXT, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        text.appendText(this.myDefaultJreSelector.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private JreComboBoxItem findOrAddCustomJre(@NotNull String pathOrName) {
        if (pathOrName == null) {
            JrePathEditor.$$$reportNull$$$0(0);
        }
        for (JreComboBoxItem item : this.myComboBoxModel.getItems()) {
            if ((!(item instanceof CustomJreItem) || !FileUtil.pathsEqual((String)pathOrName, (String)((CustomJreItem)item).myPath)) && !pathOrName.equals(item.getPathOrName())) continue;
            return item;
        }
        CustomJreItem item = new CustomJreItem(pathOrName);
        this.myComboBoxModel.add((Object)item);
        return item;
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(JComponent anchor) {
        this.myAnchor = anchor;
        this.myLabel.setAnchor(anchor);
    }

    public void addActionListener(ActionListener listener) {
        this.myPathField.getComboBox().addActionListener(listener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathOrName", "com/intellij/execution/ui/JrePathEditor", "findOrAddCustomJre"));
    }

    private class DefaultJreItem
    implements JreComboBoxItem {
        private DefaultJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(JrePathEditor.DEFAULT_JRE_TEXT);
            if (JrePathEditor.this.myDefaultJreSelector != null) {
                component.append(JrePathEditor.this.myDefaultJreSelector.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @Override
        public String getPresentableText() {
            return JrePathEditor.DEFAULT_JRE_TEXT;
        }

        @Override
        public String getPathOrName() {
            return null;
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    static class CustomJreItem
    implements JreComboBoxItem {
        private final String myPath;

        public CustomJreItem(String path) {
            this.myPath = path;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            component.append(this.getPresentableText());
            component.setIcon(AllIcons.Nodes.Folder);
        }

        @Override
        public String getPresentableText() {
            return FileUtil.toSystemDependentName((String)this.myPath);
        }

        @Override
        public String getPathOrName() {
            return this.myPath;
        }

        @Override
        public int getOrder() {
            return 2;
        }
    }

    private static class SdkAsJreItem
    implements JreComboBoxItem {
        private final Sdk mySdk;

        public SdkAsJreItem(Sdk sdk) {
            this.mySdk = sdk;
        }

        @Override
        public void render(SimpleColoredComponent component, boolean selected) {
            OrderEntryAppearanceService.getInstance().forJdk(this.mySdk, false, selected, true).customize(component);
        }

        @Override
        public String getPresentableText() {
            return this.mySdk.getName();
        }

        @Override
        public String getPathOrName() {
            return this.mySdk.getName();
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    static interface JreComboBoxItem {
        public void render(SimpleColoredComponent var1, boolean var2);

        public String getPresentableText();

        @Nullable
        public String getPathOrName();

        public int getOrder();
    }
}

