/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockVirtualFileSystem;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.SmartList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockVirtualFile
extends VirtualFile {
    private static final MockVirtualFileSystem ourFileSystem = new MockVirtualFileSystem();
    private VirtualFile myParent;
    private final String myName;
    private final boolean myDirectory;
    private final List<VirtualFile> myChildren = new SmartList();
    private String myText;
    private boolean myIsWritable = true;
    private long myModStamp = LocalTimeCounter.currentTime();
    private final long myTimeStamp = System.currentTimeMillis();
    private VirtualFileListener myListener;

    public static MockVirtualFile dir(@NotNull String name2, MockVirtualFile ... children) {
        if (name2 == null) {
            MockVirtualFile.$$$reportNull$$$0(0);
        }
        MockVirtualFile dir = new MockVirtualFile(true, name2);
        for (MockVirtualFile child : children) {
            dir.addChild(child);
        }
        return dir;
    }

    public static MockVirtualFile file(@NotNull String name2) {
        if (name2 == null) {
            MockVirtualFile.$$$reportNull$$$0(1);
        }
        return new MockVirtualFile(name2);
    }

    public MockVirtualFile(String name2) {
        this(false, name2);
    }

    public MockVirtualFile(boolean directory, String name2) {
        this.myDirectory = directory;
        this.myName = name2;
    }

    public MockVirtualFile(String name2, String text) {
        this.myName = name2;
        this.myText = text;
        this.myDirectory = false;
    }

    public void setText(String text) {
        this.myText = text;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            MockVirtualFile.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setParent(VirtualFile parent) {
        this.myParent = parent;
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name2) {
        if (name2 == null) {
            MockVirtualFile.$$$reportNull$$$0(3);
        }
        MockVirtualFile file = new MockVirtualFile(name2);
        this.addChild(file);
        MockVirtualFile mockVirtualFile = file;
        if (mockVirtualFile == null) {
            MockVirtualFile.$$$reportNull$$$0(4);
        }
        return mockVirtualFile;
    }

    public void addChild(@NotNull MockVirtualFile child) {
        if (child == null) {
            MockVirtualFile.$$$reportNull$$$0(5);
        }
        child.setParent(this);
        this.myChildren.add(child);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        MockVirtualFileSystem mockVirtualFileSystem = ourFileSystem;
        if (mockVirtualFileSystem == null) {
            MockVirtualFile.$$$reportNull$$$0(6);
        }
        return mockVirtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String prefix = this.myParent == null ? "MOCK_ROOT:" : this.myParent.getPath();
        String string = prefix + "/" + this.myName;
        if (string == null) {
            MockVirtualFile.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isWritable() {
        return this.myIsWritable;
    }

    public void setWritable(boolean b) {
        this.myIsWritable = b;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return VfsUtilCore.toVirtualFileArray(this.myChildren);
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(){

            @Override
            public void close() {
                MockVirtualFile.this.myModStamp = newModificationStamp;
                MockVirtualFile.this.myText = this.toString();
            }
        };
        if (byteArrayOutputStream == null) {
            MockVirtualFile.$$$reportNull$$$0(8);
        }
        return byteArrayOutputStream;
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    public void setModificationStamp(long modStamp) {
        this.myModStamp = modStamp;
    }

    @NotNull
    public byte[] contentsToByteArray() {
        byte[] byArray = this.myText == null ? ArrayUtil.EMPTY_BYTE_ARRAY : this.myText.getBytes(CharsetToolkit.UTF8_CHARSET);
        if (byArray == null) {
            MockVirtualFile.$$$reportNull$$$0(9);
        }
        return byArray;
    }

    public long getTimeStamp() {
        return this.myTimeStamp;
    }

    public long getLength() {
        return this.myText == null ? 0L : (long)this.myText.length();
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    public InputStream getInputStream() {
        throw new UnsupportedOperationException("Method getInputStream is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void setListener(VirtualFileListener listener) {
        this.myListener = listener;
    }

    public void setContent(@Nullable Object requestor, String content, boolean fireEvent) {
        long oldStamp = this.myModStamp;
        this.myText = content;
        if (fireEvent) {
            this.myModStamp = LocalTimeCounter.currentTime();
            this.myListener.contentsChanged(new VirtualFileEvent(requestor, (VirtualFile)this, null, oldStamp, this.myModStamp));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockVirtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dir";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

