/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataImportListener;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectDataManagerImpl
implements ProjectDataManager {
    private static final Logger LOG = Logger.getInstance(ProjectDataManagerImpl.class);
    private static final com.intellij.openapi.util.Key<Boolean> DATA_READY = com.intellij.openapi.util.Key.create((String)"externalSystem.data.ready");
    @NotNull
    private final NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>> myServices = new NotNullLazyValue<Map<Key<?>, List<ProjectDataService<?, ?>>>>(){

        @NotNull
        protected Map<Key<?>, List<ProjectDataService<?, ?>>> compute() {
            HashMap result = ContainerUtilRt.newHashMap();
            for (ProjectDataService service : (ProjectDataService[])ProjectDataService.EP_NAME.getExtensions()) {
                List services = (List)result.get(service.getTargetDataKey());
                if (services == null) {
                    services = ContainerUtilRt.newArrayList();
                    result.put(service.getTargetDataKey(), services);
                }
                services.add(service);
            }
            for (List services : result.values()) {
                ExternalSystemApiUtil.orderAwareSort((List)services);
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                1.$$$reportNull$$$0(0);
            }
            return hashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl$1", "compute"));
        }
    };

    public static ProjectDataManagerImpl getInstance() {
        ProjectDataManager service = (ProjectDataManager)ServiceManager.getService(ProjectDataManager.class);
        return (ProjectDataManagerImpl)service;
    }

    public void importData(@NotNull Collection<DataNode<?>> nodes, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        ProjectSystemId projectSystemId;
        ProjectData projectData;
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(1);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(2);
        }
        if (project2.isDisposed()) {
            return;
        }
        MultiMap grouped = ExternalSystemApiUtil.recursiveGroup(nodes);
        for (Key key : ((Map)this.myServices.getValue()).keySet()) {
            if (grouped.containsKey((Object)key)) continue;
            grouped.put((Object)key, Collections.emptyList());
        }
        Collection projects = grouped.get((Object)ProjectKeys.PROJECT);
        assert (projects.size() == 1 || projects.isEmpty());
        DataNode projectNode = (DataNode)ContainerUtil.getFirstItem((Collection)projects);
        if (projectNode != null) {
            projectData = (ProjectData)projectNode.getData();
            projectSystemId = ((ProjectData)projectNode.getData()).getOwner();
            ExternalProjectsDataStorage.getInstance(project2).saveInclusionSettings((DataNode<ProjectData>)projectNode);
        } else {
            projectData = null;
            DataNode aModuleNode = (DataNode)ContainerUtil.getFirstItem((Collection)grouped.get((Object)ProjectKeys.MODULE));
            ProjectSystemId projectSystemId2 = projectSystemId = aModuleNode != null ? ((ModuleData)aModuleNode.getData()).getOwner() : null;
        }
        if (projectSystemId != null) {
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(project2, projectSystemId);
        }
        List onSuccessImportTasks = ContainerUtil.newSmartList();
        List onFailureImportTasks = ContainerUtil.newSmartList();
        try {
            Set entries = grouped.entrySet();
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.setIndeterminate(false);
            }
            int size = entries.size();
            int count = 0;
            List postImportTasks = ContainerUtil.newSmartList();
            for (Map.Entry entry : entries) {
                if (indicator != null) {
                    String message = ExternalSystemBundle.message((String)"progress.update.text", (Object[])new Object[]{projectSystemId != null ? projectSystemId.getReadableName() : "", "Refresh " + ProjectDataManagerImpl.getReadableText((Key)entry.getKey())});
                    indicator.setText(message);
                    indicator.setFraction((double)count++ / (double)size);
                }
                this.doImportData((Key)entry.getKey(), (Collection)entry.getValue(), projectData, project2, modelsProvider, postImportTasks, onSuccessImportTasks, onFailureImportTasks);
            }
            for (Runnable postImportTask : postImportTasks) {
                postImportTask.run();
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Imported data");
            if (indicator != null) {
                indicator.setIndeterminate(true);
            }
            ((ProjectDataImportListener)project2.getMessageBus().syncPublisher(ProjectDataImportListener.TOPIC)).onImportFinished(projectData != null ? projectData.getLinkedExternalProjectPath() : null);
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.runFinalTasks(synchronous, onFailureImportTasks);
            ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
        ProjectDataManagerImpl.runFinalTasks(synchronous, onSuccessImportTasks);
    }

    private static void runFinalTasks(boolean synchronous, List<Runnable> tasks) {
        Runnable runnable = () -> {
            for (Runnable task : ContainerUtil.reverse((List)tasks)) {
                task.run();
            }
        };
        if (synchronous) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    @NotNull
    private static String getReadableText(@NotNull Key key) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        String s = key.toString();
        for (int i = 0; i < s.length(); ++i) {
            char currChar = s.charAt(i);
            if (Character.isUpperCase(currChar)) {
                if (i != 0) {
                    buffer.append(' ');
                }
                buffer.append(StringUtil.toLowerCase((char)currChar));
                continue;
            }
            buffer.append(currChar);
        }
        String string = buffer.toString();
        if (string == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public <T> void importData(@NotNull Collection<DataNode<T>> nodes, @NotNull Project project2, boolean synchronous) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(6);
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.addAll(nodes);
        this.importData(dummy, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(8);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(9);
        }
        List dummy = ContainerUtil.newSmartList();
        dummy.add(node);
        this.importData(dummy, project2, modelsProvider, synchronous);
    }

    public <T> void importData(@NotNull DataNode<T> node, @NotNull Project project2, boolean synchronous) {
        if (node == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(10);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(11);
        }
        this.importData(node, project2, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    private <T> void doImportData(@NotNull Key<T> key, @NotNull Collection<DataNode<?>> nodes, @Nullable ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull List<Runnable> postImportTasks, @NotNull List<Runnable> onSuccessImportTasks, @NotNull List<Runnable> onFailureImportTasks) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(12);
        }
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(14);
        }
        if (modifiableModelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(15);
        }
        if (postImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(16);
        }
        if (onSuccessImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(17);
        }
        if (onFailureImportTasks == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(18);
        }
        if (project2.isDisposed()) {
            return;
        }
        if (project2 instanceof ProjectImpl) assert (((ProjectImpl)project2).isComponentsCreated());
        List toImport = ContainerUtil.newSmartList();
        List toIgnore = ContainerUtil.newSmartList();
        for (DataNode<?> node : nodes) {
            if (!key.equals((Object)node.getKey())) continue;
            if (node.isIgnored()) {
                toIgnore.add(node);
                continue;
            }
            toImport.add(node);
        }
        this.ensureTheDataIsReadyToUse(toImport);
        List services = (List)((Map)this.myServices.getValue()).get(key);
        if (services == null) {
            LOG.warn(String.format("Can't import data nodes '%s'. Reason: no service is registered for key %s. Available services for %s", toImport, key, ((Map)this.myServices.getValue()).keySet()));
        } else {
            for (ProjectDataService service : services) {
                long importStartTime = System.currentTimeMillis();
                service.importData((Collection)toImport, projectData, project2, modifiableModelsProvider);
                if (LOG.isDebugEnabled()) {
                    long importTimeInMs = System.currentTimeMillis() - importStartTime;
                    LOG.debug(String.format("Service %s imported data in %d ms", service.getClass().getSimpleName(), importTimeInMs));
                }
                if (projectData == null) continue;
                this.ensureTheDataIsReadyToUse(toIgnore);
                long removeStartTime = System.currentTimeMillis();
                Computable orphanIdeDataComputable = service.computeOrphanData((Collection)toImport, projectData, project2, modifiableModelsProvider);
                service.removeData(orphanIdeDataComputable, (Collection)toIgnore, projectData, project2, modifiableModelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s computed and removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
        }
        if (services != null && projectData != null) {
            postImportTasks.add(() -> {
                if (project2 == null) {
                    ProjectDataManagerImpl.$$$reportNull$$$0(48);
                }
                if (modifiableModelsProvider == null) {
                    ProjectDataManagerImpl.$$$reportNull$$$0(49);
                }
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).postProcess((Collection)toImport, projectData, project2, modifiableModelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run post import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onFailureImportTasks.add(() -> {
                if (project2 == null) {
                    ProjectDataManagerImpl.$$$reportNull$$$0(47);
                }
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onFailureImport(project2);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run failure import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
            onSuccessImportTasks.add(() -> {
                if (project2 == null) {
                    ProjectDataManagerImpl.$$$reportNull$$$0(46);
                }
                IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project2);
                for (ProjectDataService service : services) {
                    if (!(service instanceof AbstractProjectDataService)) continue;
                    long taskStartTime = System.currentTimeMillis();
                    ((AbstractProjectDataService)service).onSuccessImport((Collection)toImport, projectData, project2, (IdeModelsProvider)modelsProvider);
                    if (!LOG.isDebugEnabled()) continue;
                    long taskTimeInMs = System.currentTimeMillis() - taskStartTime;
                    LOG.debug(String.format("Service %s run success import task in %d ms", service.getClass().getSimpleName(), taskTimeInMs));
                }
            });
        }
    }

    public void ensureTheDataIsReadyToUse(@Nullable DataNode dataNode) {
        if (dataNode == null) {
            return;
        }
        if (Boolean.TRUE.equals(dataNode.getUserData(DATA_READY))) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode, dataNode1 -> {
            this.prepareDataToUse((DataNode)dataNode1);
            dataNode1.putUserData(DATA_READY, (Object)Boolean.TRUE);
        });
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, @NotNull IdeModifiableModelsProvider modelsProvider, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(19);
        }
        if (toRemove == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(20);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(21);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(22);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(23);
        }
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(24);
        }
        try {
            List services = (List)((Map)this.myServices.getValue()).get(key);
            for (ProjectDataService service : services) {
                long removeStartTime = System.currentTimeMillis();
                service.removeData((Computable)new Computable.PredefinedValueComputable(toRemove), toIgnore, projectData, project2, modelsProvider);
                if (!LOG.isDebugEnabled()) continue;
                long removeTimeInMs = System.currentTimeMillis() - removeStartTime;
                LOG.debug(String.format("Service %s removed data in %d ms", service.getClass().getSimpleName(), removeTimeInMs));
            }
            ProjectDataManagerImpl.commit(modelsProvider, project2, synchronous, "Removed data");
        }
        catch (Throwable t) {
            ProjectDataManagerImpl.dispose(modelsProvider, project2, synchronous);
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
        }
    }

    public <E, I> void removeData(@NotNull Key<E> key, @NotNull Collection<I> toRemove, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData, @NotNull Project project2, boolean synchronous) {
        if (key == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(25);
        }
        if (toRemove == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(26);
        }
        if (toIgnore == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(27);
        }
        if (projectData == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(28);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(29);
        }
        this.removeData(key, toRemove, toIgnore, projectData, project2, new IdeModifiableModelsProviderImpl(project2), synchronous);
    }

    public void updateExternalProjectData(@NotNull Project project2, @NotNull ExternalProjectInfo externalProjectInfo) {
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(30);
        }
        if (externalProjectInfo == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(31);
        }
        if (!project2.isDisposed()) {
            ExternalProjectsManagerImpl.getInstance(project2).updateExternalProjectData(externalProjectInfo);
        }
    }

    @Nullable
    public ExternalProjectInfo getExternalProjectData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(32);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(33);
        }
        if (externalProjectPath == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(34);
        }
        return !project2.isDisposed() ? ExternalProjectsDataStorage.getInstance(project2).get(projectSystemId, externalProjectPath) : null;
    }

    @NotNull
    public Collection<ExternalProjectInfo> getExternalProjectsData(@NotNull Project project2, @NotNull ProjectSystemId projectSystemId) {
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(35);
        }
        if (projectSystemId == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(36);
        }
        if (!project2.isDisposed()) {
            Collection<ExternalProjectInfo> collection = ExternalProjectsDataStorage.getInstance(project2).list(projectSystemId);
            if (collection == null) {
                ProjectDataManagerImpl.$$$reportNull$$$0(37);
            }
            return collection;
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(38);
        }
        return list;
    }

    private void ensureTheDataIsReadyToUse(@NotNull Collection<DataNode<?>> nodes) {
        if (nodes == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(39);
        }
        for (DataNode<?> node : nodes) {
            this.ensureTheDataIsReadyToUse(node);
        }
    }

    private void prepareDataToUse(@NotNull DataNode dataNode) {
        Map servicesByKey;
        List services;
        if (dataNode == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(40);
        }
        if ((services = (List)(servicesByKey = (Map)this.myServices.getValue()).get(dataNode.getKey())) != null) {
            try {
                dataNode.prepareData((ClassLoader[])ContainerUtil.map2Array((Collection)services, ClassLoader.class, service -> service.getClass().getClassLoader()));
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                dataNode.clear(true);
            }
        }
    }

    private static void commit(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous, final @NotNull String commitDesc) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(41);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(42);
        }
        if (commitDesc == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(43);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                long startTime = System.currentTimeMillis();
                modelsProvider.commit();
                long timeInMs = System.currentTimeMillis() - startTime;
                LOG.debug(String.format("%s committed in %d ms", commitDesc, timeInMs));
            }
        });
    }

    private static void dispose(final @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull Project project2, boolean synchronous) {
        if (modelsProvider == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(44);
        }
        if (project2 == null) {
            ProjectDataManagerImpl.$$$reportNull$$$0(45);
        }
        ExternalSystemApiUtil.executeProjectChangeAction((boolean)synchronous, (DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project2){

            public void execute() {
                modelsProvider.dispose();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 14: 
            case 23: 
            case 29: 
            case 30: 
            case 32: 
            case 35: 
            case 42: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 24: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 3: 
            case 12: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 15: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postImportTasks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onSuccessImportTasks";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFailureImportTasks";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ProjectDataManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadableText";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalProjectsData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReadableText";
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doImportData";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeData";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "updateExternalProjectData";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectData";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExternalProjectsData";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "ensureTheDataIsReadyToUse";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "prepareDataToUse";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$3";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$2";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doImportData$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

