/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.service.task.AbstractToolWindowService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483644)
public class ToolWindowModuleService
extends AbstractToolWindowService<ModuleData> {
    @NotNull
    public static final Function<DataNode<ModuleData>, ExternalProjectPojo> MAPPER = node -> ExternalProjectPojo.from((Named)((Named)node.getData()));

    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        if (key == null) {
            ToolWindowModuleService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    protected void processData(@NotNull Collection<DataNode<ModuleData>> nodes, @NotNull Project project2) {
        if (nodes == null) {
            ToolWindowModuleService.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ToolWindowModuleService.$$$reportNull$$$0(2);
        }
        if (nodes.isEmpty()) {
            return;
        }
        ProjectSystemId externalSystemId = ((ModuleData)nodes.iterator().next().getData()).getOwner();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        MultiMap grouped = ExternalSystemApiUtil.groupBy(nodes, (Key)ProjectKeys.PROJECT);
        HashMap data = ContainerUtilRt.newHashMap();
        for (Map.Entry entry : grouped.entrySet()) {
            data.put(ExternalProjectPojo.from((Named)((Named)((DataNode)entry.getKey()).getData())), ContainerUtilRt.map2List((Collection)((Collection)entry.getValue()), MAPPER));
        }
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project2);
        Set<String> pathsToForget = ToolWindowModuleService.detectRenamedProjects(data, settings.getAvailableProjects());
        if (!pathsToForget.isEmpty()) {
            settings.forgetExternalProjects(pathsToForget);
        }
        HashMap projects = ContainerUtilRt.newHashMap((Map)settings.getAvailableProjects());
        projects.putAll(data);
        settings.setAvailableProjects((Map)projects);
    }

    @NotNull
    private static Set<String> detectRenamedProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> currentInfo, @NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> oldInfo) {
        if (currentInfo == null) {
            ToolWindowModuleService.$$$reportNull$$$0(3);
        }
        if (oldInfo == null) {
            ToolWindowModuleService.$$$reportNull$$$0(4);
        }
        HashMap map = ContainerUtilRt.newHashMap();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : currentInfo.entrySet()) {
            map.put(entry.getKey().getPath(), entry.getKey().getName());
            for (ExternalProjectPojo pojo : entry.getValue()) {
                map.put(pojo.getPath(), pojo.getName());
            }
        }
        HashSet result = ContainerUtilRt.newHashSet();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : oldInfo.entrySet()) {
            String newName = (String)map.get(entry.getKey().getPath());
            if (newName != null && !newName.equals(entry.getKey().getName())) {
                result.add(entry.getKey().getPath());
            }
            for (ExternalProjectPojo pojo : entry.getValue()) {
                newName = (String)map.get(pojo.getPath());
                if (newName == null || newName.equals(pojo.getName())) continue;
                result.add(pojo.getPath());
            }
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            ToolWindowModuleService.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/task/ToolWindowModuleService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRenamedProjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectRenamedProjects";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

