/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelActionBase;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChangeLibraryLevelInClasspathAction
extends ChangeLibraryLevelActionBase {
    private final ClasspathPanel myPanel;

    public ChangeLibraryLevelInClasspathAction(@NotNull ClasspathPanel panel, @NotNull String targetTableName, @NotNull String targetTableLevel) {
        if (panel == null) {
            ChangeLibraryLevelInClasspathAction.$$$reportNull$$$0(0);
        }
        if (targetTableName == null) {
            ChangeLibraryLevelInClasspathAction.$$$reportNull$$$0(1);
        }
        if (targetTableLevel == null) {
            ChangeLibraryLevelInClasspathAction.$$$reportNull$$$0(2);
        }
        super(panel.getProject(), targetTableName, targetTableLevel, targetTableLevel.equals("module"));
        this.myPanel = panel;
    }

    public void actionPerformed(AnActionEvent event) {
        OrderEntry entry = this.myPanel.getSelectedEntry();
        if (!(entry instanceof LibraryOrderEntry)) {
            return;
        }
        LibraryOrderEntry libraryEntry = (LibraryOrderEntry)entry;
        LibraryEx library = (LibraryEx)libraryEntry.getLibrary();
        if (library == null) {
            return;
        }
        Library copied = this.doCopy(library);
        if (copied == null) {
            return;
        }
        if (!this.isConvertingToModuleLibrary()) {
            OrderEntryUtil.replaceLibrary((ModifiableRootModel)this.myPanel.getRootModel(), (Library)library, (Library)copied);
        } else {
            OrderEntryUtil.replaceLibraryEntryByAdded((ModifiableRootModel)this.myPanel.getRootModel(), (LibraryOrderEntry)libraryEntry);
        }
    }

    @Override
    protected boolean isEnabled() {
        LibraryOrderEntry libraryOrderEntry;
        OrderEntry entry = this.myPanel.getSelectedEntry();
        boolean enabled = false;
        if (entry instanceof LibraryOrderEntry && (libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary() != null) {
            boolean isToModuleLibrary;
            boolean isFromModuleLibrary = libraryOrderEntry.isModuleLevel();
            enabled = isFromModuleLibrary != (isToModuleLibrary = this.isConvertingToModuleLibrary());
        }
        return enabled;
    }

    @Override
    protected LibraryTableModifiableModelProvider getModifiableTableModelProvider() {
        return this.myPanel.getModifiableModelProvider(this.myTargetTableLevel);
    }

    @Override
    protected JComponent getParentComponent() {
        return this.myPanel.getComponent();
    }

    @Override
    @Nullable
    protected VirtualFile getBaseDir() {
        if (this.isConvertingToModuleLibrary()) {
            VirtualFile[] roots = this.myPanel.getRootModel().getContentRoots();
            if (roots.length > 0) {
                return roots[0];
            }
            VirtualFile moduleFile = this.myPanel.getRootModel().getModule().getModuleFile();
            if (moduleFile != null) {
                return moduleFile.getParent();
            }
        }
        return super.getBaseDir();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "panel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targetTableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "targetTableLevel";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelInClasspathAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

