/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.run;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTask;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProviderBase;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class BuildArtifactsBeforeRunTaskProvider
extends BuildArtifactsBeforeRunTaskProviderBase<BuildArtifactsBeforeRunTask> {
    @NonNls
    public static final String BUILD_ARTIFACTS_ID = "BuildArtifacts";
    public static final Key<BuildArtifactsBeforeRunTask> ID = Key.create((String)"BuildArtifacts");

    public BuildArtifactsBeforeRunTaskProvider(Project project2) {
        super(BuildArtifactsBeforeRunTask.class, project2);
    }

    public Key<BuildArtifactsBeforeRunTask> getId() {
        return ID;
    }

    public Icon getIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public String getName() {
        return CompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
    }

    public Icon getTaskIcon(BuildArtifactsBeforeRunTask task) {
        List<ArtifactPointer> pointers = task.getArtifactPointers();
        if (pointers == null || pointers.isEmpty()) {
            return this.getIcon();
        }
        Artifact artifact = pointers.get(0).getArtifact();
        if (artifact == null) {
            return this.getIcon();
        }
        return artifact.getArtifactType().getIcon();
    }

    public String getDescription(BuildArtifactsBeforeRunTask task) {
        List<ArtifactPointer> pointers = task.getArtifactPointers();
        if (pointers.isEmpty()) {
            return CompilerBundle.message((String)"build.artifacts.before.run.description.empty", (Object[])new Object[0]);
        }
        if (pointers.size() == 1) {
            return CompilerBundle.message((String)"build.artifacts.before.run.description.single", (Object[])new Object[]{pointers.get(0).getArtifactName()});
        }
        return CompilerBundle.message((String)"build.artifacts.before.run.description.multiple", (Object[])new Object[]{pointers.size()});
    }

    public static void setBuildArtifactBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, Project project2, @NotNull Artifact artifact, boolean enable) {
        BeforeRunTaskProvider provider;
        if (runConfigurationEditorComponent == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(1);
        }
        if ((provider = BuildArtifactsBeforeRunTaskProvider.getProvider((Project)project2, ID)) != null) {
            ((BuildArtifactsBeforeRunTaskProvider)provider).setBuildArtifactBeforeRunOption(runConfigurationEditorComponent, artifact, enable);
        }
    }

    public static void setBuildArtifactBeforeRun(@NotNull Project project2, @NotNull RunConfiguration configuration, @NotNull Artifact artifact) {
        if (project2 == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(2);
        }
        if (configuration == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            BuildArtifactsBeforeRunTaskProvider.$$$reportNull$$$0(4);
        }
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project2);
        ArrayList<BuildArtifactsBeforeRunTask> buildArtifactsTasks = new ArrayList<BuildArtifactsBeforeRunTask>(runManager.getBeforeRunTasks(configuration, ID));
        if (runManager.getBeforeRunTasks(configuration, ID).isEmpty()) {
            BuildArtifactsBeforeRunTask task = new BuildArtifactsBeforeRunTask(project2);
            buildArtifactsTasks.add(task);
            ArrayList<BuildArtifactsBeforeRunTask> tasks = new ArrayList<BuildArtifactsBeforeRunTask>(runManager.getBeforeRunTasks(configuration));
            tasks.add(task);
            runManager.setBeforeRunTasks(configuration, tasks);
        }
        for (BuildArtifactsBeforeRunTask task : buildArtifactsTasks) {
            task.setEnabled(true);
            task.addArtifact(artifact);
        }
    }

    @Override
    protected BuildArtifactsBeforeRunTask doCreateTask(Project project2) {
        return new BuildArtifactsBeforeRunTask(project2);
    }

    @Override
    protected ProjectTask createProjectTask(Project project2, List<Artifact> artifacts) {
        return ProjectTaskManager.getInstance((Project)project2).createArtifactsBuildTask(true, artifacts.toArray(new Artifact[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfigurationEditorComponent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/run/BuildArtifactsBeforeRunTaskProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setBuildArtifactBeforeRunOption";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setBuildArtifactBeforeRun";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

