/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.FindInFilesOptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import com.intellij.structuralsearch.impl.matcher.compiler.TestModeOptimizingSearchHelper;

public class CompileContext {
    private final OptimizingSearchHelper searchHelper;
    private final CompiledPattern pattern;
    private final MatchOptions options;
    private final Project project;

    public CompileContext(CompiledPattern _result, MatchOptions _options, Project _project) {
        this.options = _options;
        this.project = _project;
        this.pattern = _result;
        this.searchHelper = ApplicationManager.getApplication().isUnitTestMode() ? new TestModeOptimizingSearchHelper() : new FindInFilesOptimizingSearchHelper(this.options.getScope(), this.options.isCaseSensitiveMatch(), _project);
    }

    public void clear() {
        this.searchHelper.clear();
    }

    public OptimizingSearchHelper getSearchHelper() {
        return this.searchHelper;
    }

    public CompiledPattern getPattern() {
        return this.pattern;
    }

    public MatchOptions getOptions() {
        return this.options;
    }

    public Project getProject() {
        return this.project;
    }
}

