/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

abstract class OptimizingSearchHelperBase
implements OptimizingSearchHelper {
    private final THashSet<String> scanned = new THashSet();
    private final THashSet<String> scannedText = new THashSet();
    private final THashSet<String> scannedComments = new THashSet();
    private final THashSet<String> scannedLiterals = new THashSet();
    protected int scanRequest = 0;

    OptimizingSearchHelperBase() {
    }

    @Override
    public void clear() {
        this.scanned.clear();
        this.scannedText.clear();
        this.scannedComments.clear();
        this.scannedLiterals.clear();
    }

    @Override
    public void addWordToSearchInCode(String word) {
        if (word != null && this.doOptimizing() && this.scanned.add((Object)word)) {
            this.doAddSearchWordInCode(word);
        }
    }

    @Override
    public void addWordToSearchInText(String word) {
        if (word != null && this.doOptimizing() && this.scannedText.add((Object)word)) {
            this.doAddSearchWordInText(word);
        }
    }

    @Override
    public void addWordToSearchInComments(String word) {
        if (word != null && this.doOptimizing() && this.scannedComments.add((Object)word)) {
            this.doAddSearchWordInComments(word);
        }
    }

    @Override
    public void addWordToSearchInLiterals(String word) {
        if (word != null && this.doOptimizing() && this.scannedLiterals.add((Object)word)) {
            this.doAddSearchWordInLiterals(word);
        }
    }

    protected abstract void doAddSearchWordInCode(@NotNull String var1);

    protected abstract void doAddSearchWordInText(@NotNull String var1);

    protected abstract void doAddSearchWordInComments(@NotNull String var1);

    protected abstract void doAddSearchWordInLiterals(@NotNull String var1);

    @Override
    public void endTransaction() {
        ++this.scanRequest;
    }

    @Override
    public boolean isScannedSomething() {
        return !this.scanned.isEmpty() || !this.scannedText.isEmpty() || !this.scannedComments.isEmpty() || !this.scannedLiterals.isEmpty();
    }
}

