/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsKt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.TemporaryDirectoryKt;
import com.intellij.util.SmartList;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0002J\u001c\u0010\u0018\u001a\u00020\u00052\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001c\u001a\u00020\u001d2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/intellij/testFramework/TemporaryDirectory;", "Lorg/junit/rules/ExternalResource;", "()V", "paths", "Lcom/intellij/util/SmartList;", "Ljava/nio/file/Path;", "<set-?>", "", "sanitizedName", "getSanitizedName", "()Ljava/lang/String;", "setSanitizedName", "(Ljava/lang/String;)V", "sanitizedName$delegate", "Lkotlin/properties/ReadWriteProperty;", "after", "", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "generatePath", "suffix", "newPath", "directoryName", "refreshVfs", "", "newVirtualDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.testFramework"})
public final class TemporaryDirectory
extends ExternalResource {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final SmartList<Path> paths = new SmartList();
    private final ReadWriteProperty sanitizedName$delegate = Delegates.INSTANCE.notNull();

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TemporaryDirectory.class), "sanitizedName", "getSanitizedName()Ljava/lang/String;"))};
    }

    private final String getSanitizedName() {
        return (String)this.sanitizedName$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setSanitizedName(String string) {
        this.sanitizedName$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @NotNull Description description) {
        Intrinsics.checkParameterIsNotNull((Object)base, (String)"base");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        String string = description.getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"description.methodName");
        this.setSanitizedName(PathKt.sanitizeFileName$default((String)string, null, (boolean)false, (int)6, null));
        Statement statement2 = super.apply(base, description);
        Intrinsics.checkExpressionValueIsNotNull((Object)statement2, (String)"super.apply(base, description)");
        return statement2;
    }

    protected void after() {
        SmartList errors = new SmartList();
        for (Path path : this.paths) {
            try {
                Path path2 = path;
                Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"path");
                PathKt.delete((Path)path2);
            }
            catch (Throwable e) {
                errors.add((Object)e);
            }
        }
        CompoundRuntimeException.throwIfNotEmpty((List)((List)errors));
        this.paths.clear();
    }

    @NotNull
    public final Path newPath(@Nullable String directoryName, boolean refreshVfs) {
        Path path = this.generatePath(directoryName);
        if (refreshVfs) {
            VfsKt.refreshVfs((Path)path);
        }
        return path;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Path newPath$default(TemporaryDirectory temporaryDirectory, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return temporaryDirectory.newPath(string, bl);
    }

    private final Path generatePath(String suffix) {
        String fileName = this.getSanitizedName();
        if (suffix != null) {
            fileName = fileName + '_' + suffix;
        }
        Path path = TemporaryDirectoryKt.generateTemporaryPath(fileName);
        this.paths.add((Object)path);
        return path;
    }

    @NotNull
    public final VirtualFile newVirtualDirectory(@Nullable String directoryName) {
        Path path = this.generatePath(directoryName);
        PathKt.createDirectories((Path)path);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)path));
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            Intrinsics.throwNpe();
        }
        return virtualFile2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ VirtualFile newVirtualDirectory$default(TemporaryDirectory temporaryDirectory, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return temporaryDirectory.newVirtualDirectory(string);
    }
}

