/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.debugger.breakpoints.properties;

import com.intellij.debugger.InstanceFilter;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBreakpointProperties<T extends JavaBreakpointProperties>
extends XBreakpointProperties<T> {
    private boolean COUNT_FILTER_ENABLED = false;
    private int COUNT_FILTER = 0;
    private boolean CLASS_FILTERS_ENABLED = false;
    private ClassFilter[] myClassFilters;
    private ClassFilter[] myClassExclusionFilters;
    private boolean INSTANCE_FILTERS_ENABLED = false;
    private InstanceFilter[] myInstanceFilters;

    @XCollection(propertyElementName="instance-filters")
    public InstanceFilter[] getInstanceFilters() {
        return this.myInstanceFilters != null ? this.myInstanceFilters : InstanceFilter.EMPTY_ARRAY;
    }

    public boolean setInstanceFilters(InstanceFilter[] instanceFilters) {
        boolean changed = !JavaBreakpointProperties.filtersEqual(this.myInstanceFilters, instanceFilters);
        this.myInstanceFilters = instanceFilters;
        return changed;
    }

    public void addInstanceFilter(long l) {
        InstanceFilter newFilter = InstanceFilter.create(String.valueOf(l));
        this.myInstanceFilters = this.myInstanceFilters == null ? new InstanceFilter[]{newFilter} : (InstanceFilter[])ArrayUtil.append((Object[])this.myInstanceFilters, (Object)newFilter);
    }

    @XCollection(propertyElementName="class-filters")
    public final ClassFilter[] getClassFilters() {
        return this.myClassFilters != null ? this.myClassFilters : ClassFilter.EMPTY_ARRAY;
    }

    public final boolean setClassFilters(ClassFilter[] classFilters) {
        boolean changed = !JavaBreakpointProperties.filtersEqual(this.myClassFilters, classFilters);
        this.myClassFilters = classFilters;
        return changed;
    }

    protected static boolean filtersEqual(Object[] a, Object[] b) {
        if (!(a != null && a.length != 0 || b != null && b.length != 0)) {
            return true;
        }
        return Comparing.equal((Object[])a, (Object[])b);
    }

    @XCollection(propertyElementName="class-exclusion-filters")
    public ClassFilter[] getClassExclusionFilters() {
        return this.myClassExclusionFilters != null ? this.myClassExclusionFilters : ClassFilter.EMPTY_ARRAY;
    }

    public boolean setClassExclusionFilters(ClassFilter[] classExclusionFilters) {
        boolean changed = !JavaBreakpointProperties.filtersEqual(this.myClassExclusionFilters, classExclusionFilters);
        this.myClassExclusionFilters = classExclusionFilters;
        return changed;
    }

    @Nullable
    public T getState() {
        return (T)((Object)this);
    }

    public void loadState(@NotNull T state) {
        if (state == null) {
            JavaBreakpointProperties.$$$reportNull$$$0(0);
        }
        this.setCOUNT_FILTER_ENABLED(((JavaBreakpointProperties)((Object)state)).isCOUNT_FILTER_ENABLED());
        this.setCOUNT_FILTER(((JavaBreakpointProperties)((Object)state)).getCOUNT_FILTER());
        this.setCLASS_FILTERS_ENABLED(((JavaBreakpointProperties)((Object)state)).isCLASS_FILTERS_ENABLED());
        this.myClassFilters = ((JavaBreakpointProperties)((Object)state)).getClassFilters();
        this.myClassExclusionFilters = ((JavaBreakpointProperties)((Object)state)).getClassExclusionFilters();
        this.setINSTANCE_FILTERS_ENABLED(((JavaBreakpointProperties)((Object)state)).isINSTANCE_FILTERS_ENABLED());
        this.myInstanceFilters = ((JavaBreakpointProperties)((Object)state)).getInstanceFilters();
    }

    @OptionTag(value="count-filter-enabled")
    public boolean isCOUNT_FILTER_ENABLED() {
        return this.COUNT_FILTER_ENABLED;
    }

    public boolean setCOUNT_FILTER_ENABLED(boolean COUNT_FILTER_ENABLED) {
        boolean changed = this.COUNT_FILTER_ENABLED != COUNT_FILTER_ENABLED;
        this.COUNT_FILTER_ENABLED = COUNT_FILTER_ENABLED;
        return changed;
    }

    @OptionTag(value="count-filter")
    public int getCOUNT_FILTER() {
        return this.COUNT_FILTER;
    }

    public boolean setCOUNT_FILTER(int COUNT_FILTER) {
        boolean changed = this.COUNT_FILTER != COUNT_FILTER;
        this.COUNT_FILTER = COUNT_FILTER;
        return changed;
    }

    @OptionTag(value="class-filters-enabled")
    public boolean isCLASS_FILTERS_ENABLED() {
        return this.CLASS_FILTERS_ENABLED;
    }

    public boolean setCLASS_FILTERS_ENABLED(boolean CLASS_FILTERS_ENABLED) {
        boolean changed = this.CLASS_FILTERS_ENABLED != CLASS_FILTERS_ENABLED;
        this.CLASS_FILTERS_ENABLED = CLASS_FILTERS_ENABLED;
        return changed;
    }

    @OptionTag(value="instance-filters-enabled")
    public boolean isINSTANCE_FILTERS_ENABLED() {
        return this.INSTANCE_FILTERS_ENABLED;
    }

    public boolean setINSTANCE_FILTERS_ENABLED(boolean INSTANCE_FILTERS_ENABLED) {
        boolean changed = this.INSTANCE_FILTERS_ENABLED != INSTANCE_FILTERS_ENABLED;
        this.INSTANCE_FILTERS_ENABLED = INSTANCE_FILTERS_ENABLED;
        return changed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/java/debugger/breakpoints/properties/JavaBreakpointProperties", "loadState"));
    }
}

