/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner;

import com.intellij.ProjectTopics;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesUtilBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Pair;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringDescriptorManager {
    private Module myModule;
    private final Map<Pair<Locale, String>, PropertiesFile> myPropertiesFileCache = ContainerUtil.createSoftValueMap();

    public StringDescriptorManager(Module module, MessageBus bus) {
        this.myModule = module;
        bus.connect().subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rootsChanged(ModuleRootEvent event) {
                Map map = StringDescriptorManager.this.myPropertiesFileCache;
                synchronized (map) {
                    StringDescriptorManager.this.myPropertiesFileCache.clear();
                }
            }
        });
    }

    public static StringDescriptorManager getInstance(Module module) {
        StringDescriptorManager service = (StringDescriptorManager)ModuleServiceManager.getService((Module)module, StringDescriptorManager.class);
        if (service != null) {
            service.myModule = module;
        }
        return service;
    }

    @Nullable
    public String resolve(@NotNull RadComponent component, @Nullable StringDescriptor descriptor) {
        RadRootContainer root;
        if (component == null) {
            StringDescriptorManager.$$$reportNull$$$0(0);
        }
        Locale locale = (root = (RadRootContainer)FormEditingUtil.getRoot(component)) != null ? root.getStringDescriptorLocale() : null;
        return this.resolve(descriptor, locale);
    }

    @Nullable
    public String resolve(@Nullable StringDescriptor descriptor, @Nullable Locale locale) {
        String value;
        if (descriptor == null) {
            return null;
        }
        if (descriptor.getValue() != null) {
            return descriptor.getValue();
        }
        IProperty prop = this.resolveToProperty(descriptor, locale);
        if (prop != null && (value = prop.getUnescapedValue()) != null) {
            return value;
        }
        return "[" + descriptor.getKey() + " / " + descriptor.getBundleName() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProperty resolveToProperty(@NotNull StringDescriptor descriptor, @Nullable Locale locale) {
        IProperty propertyByKey;
        PropertiesFile propertiesFile;
        if (descriptor == null) {
            StringDescriptorManager.$$$reportNull$$$0(1);
        }
        String propFileName = descriptor.getDottedBundleName();
        Pair cacheKey = Pair.create((Object)locale, (Object)propFileName);
        Map<Pair<Locale, String>, PropertiesFile> map = this.myPropertiesFileCache;
        synchronized (map) {
            propertiesFile = this.myPropertiesFileCache.get(cacheKey);
        }
        if (propertiesFile == null || !propertiesFile.getContainingFile().isValid()) {
            propertiesFile = PropertiesUtilBase.getPropertiesFile((String)propFileName, (Module)this.myModule, (Locale)locale);
            map = this.myPropertiesFileCache;
            synchronized (map) {
                this.myPropertiesFileCache.put((Pair<Locale, String>)cacheKey, propertiesFile);
            }
        }
        if (propertiesFile != null && (propertyByKey = propertiesFile.findPropertyByKey(descriptor.getKey())) != null) {
            return propertyByKey;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uiDesigner/StringDescriptorManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolve";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveToProperty";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

