/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.notification.BrowseNotificationAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.ui.GuiUtils;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableProblemsNotifier {
    @NotNull
    private final Project myProject;
    @NotNull
    private final NotificationsManager myNotificationsManager;

    public static GitExecutableProblemsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(0);
        }
        return (GitExecutableProblemsNotifier)ServiceManager.getService((Project)project, GitExecutableProblemsNotifier.class);
    }

    public GitExecutableProblemsNotifier(@NotNull Project project, @NotNull NotificationsManager notificationsManager) {
        if (project == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(1);
        }
        if (notificationsManager == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myNotificationsManager = notificationsManager;
    }

    public static void showUnsupportedVersionDialog(@NotNull GitVersion version, @Nullable Project project) {
        if (version == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(3);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (version == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(18);
            }
            Messages.showWarningDialog((Project)project, (String)(GitBundle.message("git.executable.validation.error.version.subtitle", version.getPresentation()) + "\n\n" + GitBundle.message("git.executable.validation.error.version.message", GitVersion.MIN.getPresentation())), (String)GitBundle.getString("git.executable.validation.error.title"));
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    public static void showExecutionErrorDialog(@NotNull Throwable e, @NotNull String pathToExecutable, @Nullable Project project) {
        if (e == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(4);
        }
        if (pathToExecutable == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(5);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (pathToExecutable == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(16);
            }
            if (e == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(17);
            }
            Messages.showErrorDialog((Project)project, (String)(GitBundle.message("git.executable.validation.error.start.subtitle", pathToExecutable) + "\n\n" + GitExecutableProblemsNotifier.getPrettyErrorMessage(e)), (String)GitBundle.getString("git.executable.validation.error.title"));
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    public void notifyUnsupportedVersion(@NotNull GitVersion version) {
        if (version == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(6);
        }
        UnsupportedGitVersionNotification notification = new UnsupportedGitVersionNotification(version);
        ((BadGitExecutableNotification)notification).addConfigureGitActions(this.myProject);
        this.notify(notification);
    }

    public void notifyExecutionError(@NotNull String pathToExecutable, @NotNull Throwable exception) {
        if (pathToExecutable == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(7);
        }
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(8);
        }
        ErrorRunningGitNotification notification = new ErrorRunningGitNotification(GitExecutableProblemsNotifier.getPrettyErrorMessage(exception), pathToExecutable);
        ((BadGitExecutableNotification)notification).addConfigureGitActions(this.myProject);
        this.notify(notification);
    }

    private void notify(@NotNull BadGitExecutableNotification notification) {
        if (notification == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(9);
        }
        GuiUtils.invokeLaterIfNeeded(() -> {
            if (notification == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(15);
            }
            if (this.ensureSingularOfType(((Object)((Object)notification)).getClass())) {
                notification.notify(this.myProject);
            }
        }, (ModalityState)ModalityState.defaultModalityState());
    }

    private boolean ensureSingularOfType(@NotNull Class<? extends BadGitExecutableNotification> notificationType) {
        BadGitExecutableNotification[] currentNotifications;
        int notificationsCount;
        if (notificationType == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(10);
        }
        if ((notificationsCount = (currentNotifications = (BadGitExecutableNotification[])this.myNotificationsManager.getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)).length) <= 0) {
            return true;
        }
        for (int i = 0; i < notificationsCount - 1; ++i) {
            currentNotifications[i].expire();
        }
        BadGitExecutableNotification lastNotification = currentNotifications[notificationsCount - 1];
        if (((Object)((Object)lastNotification)).getClass() != notificationType) {
            lastNotification.expire();
            return true;
        }
        return false;
    }

    public void expireNotifications() {
        for (BadGitExecutableNotification notification : (BadGitExecutableNotification[])this.myNotificationsManager.getNotificationsOfType(BadGitExecutableNotification.class, this.myProject)) {
            notification.expire();
        }
    }

    @NotNull
    public static String getPrettyErrorMessage(@NotNull Throwable exception) {
        if (exception == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(11);
        }
        String errorMessage = null;
        if (exception instanceof GitVersionIdentificationException && exception.getCause() != null) {
            Throwable cause = exception.getCause();
            errorMessage = cause instanceof NoSuchFileException ? "File not found: " + cause.getMessage() : cause.getMessage();
        }
        if (errorMessage == null) {
            if (exception.getMessage() != null) {
                String string = exception.getMessage();
                if (string == null) {
                    GitExecutableProblemsNotifier.$$$reportNull$$$0(12);
                }
                return string;
            }
            String string = exception.getClass().getName();
            if (string == null) {
                GitExecutableProblemsNotifier.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = errorMessage;
        if (string == null) {
            GitExecutableProblemsNotifier.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationsManager";
                break;
            }
            case 3: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToExecutable";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableProblemsNotifier";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrettyErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showUnsupportedVersionDialog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showExecutionErrorDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "notifyUnsupportedVersion";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "notifyExecutionError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureSingularOfType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPrettyErrorMessage";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$notify$2";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showExecutionErrorDialog$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showUnsupportedVersionDialog$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class BadGitExecutableNotification
    extends Notification {
        public BadGitExecutableNotification(@NotNull String groupDisplayId, @Nullable Icon icon, @Nullable String title, @Nullable String subtitle, @Nullable String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
            if (groupDisplayId == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(0);
            }
            if (type == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(1);
            }
            super(groupDisplayId, icon, title, subtitle, content, type, listener);
        }

        private void addConfigureGitActions(@NotNull Project project) {
            if (project == null) {
                BadGitExecutableNotification.$$$reportNull$$$0(2);
            }
            this.addAction((AnAction)new BrowseNotificationAction(GitBundle.getString("git.executable.validation.error.action.download"), GitBundle.getString("git.executable.validation.error.action.download.link")));
            this.addAction((AnAction)NotificationAction.createSimple((String)GitBundle.getString("git.executable.validation.error.action.setting"), () -> {
                if (project == null) {
                    BadGitExecutableNotification.$$$reportNull$$$0(3);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, "Git");
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupDisplayId";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "git4idea/config/GitExecutableProblemsNotifier$BadGitExecutableNotification";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addConfigureGitActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$addConfigureGitActions$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ErrorRunningGitNotification
    extends BadGitExecutableNotification {
        public ErrorRunningGitNotification(@NotNull String error, @NotNull String pathToExecutable) {
            if (error == null) {
                ErrorRunningGitNotification.$$$reportNull$$$0(0);
            }
            if (pathToExecutable == null) {
                ErrorRunningGitNotification.$$$reportNull$$$0(1);
            }
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.getString("git.executable.validation.error.title"), GitBundle.message("git.executable.validation.error.start.subtitle", pathToExecutable), error, NotificationType.ERROR, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "error";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pathToExecutable";
                    break;
                }
            }
            objectArray[1] = "git4idea/config/GitExecutableProblemsNotifier$ErrorRunningGitNotification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnsupportedGitVersionNotification
    extends BadGitExecutableNotification {
        public UnsupportedGitVersionNotification(@NotNull GitVersion unsupportedVersion) {
            if (unsupportedVersion == null) {
                UnsupportedGitVersionNotification.$$$reportNull$$$0(0);
            }
            super(VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.getDisplayId(), null, GitBundle.getString("git.executable.validation.error.title"), GitBundle.message("git.executable.validation.error.version.subtitle", unsupportedVersion.getPresentation()), GitBundle.message("git.executable.validation.error.version.message", GitVersion.MIN.getPresentation()), NotificationType.WARNING, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unsupportedVersion", "git4idea/config/GitExecutableProblemsNotifier$UnsupportedGitVersionNotification", "<init>"));
        }
    }
}

