/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.difftool;

import com.intellij.diff.DiffContext;
import com.intellij.diff.FocusableContext;
import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.tools.ErrorDiffTool;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.difftool.SvnDiffSettingsHolder;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffViewer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class SvnDiffViewer
implements FrameDiffTool.DiffViewer {
    private static final Logger LOG = Logger.getInstance(SvnDiffViewer.class);
    public static final Key<MyPropertyContext> PROPERTY_CONTEXT_KEY = Key.create((String)"MyPropertyContext");
    public static final Key<Boolean> FOCUSED_VIEWER_KEY = Key.create((String)"SvnFocusedViewer");
    @Nullable
    private final Project myProject;
    @NotNull
    private final DiffContext myContext;
    @NotNull
    private final DiffRequest myPropertyRequest;
    @NotNull
    private final SvnDiffSettingsHolder.SvnDiffSettings mySettings;
    @NotNull
    private final JPanel myPanel;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final Wrapper myNotificationPanel;
    @NotNull
    private final FrameDiffTool.DiffViewer myContentViewer;
    @NotNull
    private final FrameDiffTool.DiffViewer myPropertiesViewer;
    @NotNull
    private final FocusListener myContentFocusListener;
    @NotNull
    private final FocusListener myPropertiesFocusListener;
    private boolean myPropertiesViewerFocused;
    private boolean myDumbContentViewer;

    public SvnDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest propertyRequest, @NotNull FrameDiffTool.DiffViewer wrappingViewer) {
        if (context == null) {
            SvnDiffViewer.$$$reportNull$$$0(0);
        }
        if (propertyRequest == null) {
            SvnDiffViewer.$$$reportNull$$$0(1);
        }
        if (wrappingViewer == null) {
            SvnDiffViewer.$$$reportNull$$$0(2);
        }
        this.myContentFocusListener = new MyFocusListener(false);
        this.myPropertiesFocusListener = new MyFocusListener(true);
        this.myProject = context.getProject();
        this.myContext = context;
        this.myPropertyRequest = propertyRequest;
        this.myContentViewer = wrappingViewer;
        this.myPropertyRequest.onAssigned(true);
        this.mySettings = SvnDiffViewer.initSettings(context);
        this.mySplitter = new MySplitter("Property Changes");
        this.mySplitter.setProportion(this.mySettings.getSplitterProportion());
        this.mySplitter.setFirstComponent(this.myContentViewer.getComponent());
        this.myNotificationPanel = new Wrapper();
        MyPropertyContext propertyContext = this.initPropertyContext(context);
        this.myPropertiesViewer = SvnDiffViewer.createPropertiesViewer(propertyRequest, propertyContext);
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add((Component)this.mySplitter, "Center");
        this.myPanel.add((Component)this.myNotificationPanel, "South");
        DataManager.registerDataProvider((JComponent)this.myPanel, dataId -> {
            DataProvider propertiesDataProvider = DataManagerImpl.getDataProviderEx((Object)this.myPropertiesViewer.getComponent());
            DataProvider contentDataProvider = DataManagerImpl.getDataProviderEx((Object)this.myContentViewer.getComponent());
            DataProvider defaultDP = this.myPropertiesViewerFocused ? propertiesDataProvider : contentDataProvider;
            DataProvider fallbackDP = this.myPropertiesViewerFocused ? contentDataProvider : propertiesDataProvider;
            return DiffUtil.getData((DataProvider)defaultDP, (DataProvider)fallbackDP, (String)dataId);
        });
        this.updatePropertiesPanel();
    }

    @NotNull
    private static FrameDiffTool.DiffViewer createPropertiesViewer(@NotNull DiffRequest propertyRequest, @NotNull MyPropertyContext propertyContext) {
        if (propertyRequest == null) {
            SvnDiffViewer.$$$reportNull$$$0(3);
        }
        if (propertyContext == null) {
            SvnDiffViewer.$$$reportNull$$$0(4);
        }
        if (propertyRequest instanceof SvnPropertiesDiffRequest) {
            SvnPropertiesDiffViewer svnPropertiesDiffViewer = SvnPropertiesDiffViewer.create(propertyContext, (SvnPropertiesDiffRequest)propertyRequest, true);
            if (svnPropertiesDiffViewer == null) {
                SvnDiffViewer.$$$reportNull$$$0(5);
            }
            return svnPropertiesDiffViewer;
        }
        FrameDiffTool.DiffViewer diffViewer = ErrorDiffTool.INSTANCE.createComponent((DiffContext)propertyContext, propertyRequest);
        if (diffViewer == null) {
            SvnDiffViewer.$$$reportNull$$$0(6);
        }
        return diffViewer;
    }

    @NotNull
    public FrameDiffTool.ToolbarComponents init() {
        this.installListeners();
        this.processContextHints();
        FrameDiffTool.ToolbarComponents properties = this.myPropertiesViewer.init();
        FrameDiffTool.ToolbarComponents components = new FrameDiffTool.ToolbarComponents();
        components.toolbarActions = this.createToolbar(properties.toolbarActions);
        FrameDiffTool.ToolbarComponents toolbarComponents = components;
        if (toolbarComponents == null) {
            SvnDiffViewer.$$$reportNull$$$0(7);
        }
        return toolbarComponents;
    }

    public void dispose() {
        this.destroyListeners();
        this.updateContextHints();
        Disposer.dispose((Disposable)this.myPropertiesViewer);
        this.myPropertyRequest.onAssigned(false);
    }

    private void processContextHints() {
        if (this.myContext.getUserData(FOCUSED_VIEWER_KEY) == Boolean.TRUE) {
            this.myPropertiesViewerFocused = true;
        }
        this.myDumbContentViewer = this.myContentViewer.getPreferredFocusedComponent() == null;
    }

    private void updateContextHints() {
        if (!this.myDumbContentViewer && !this.mySettings.isHideProperties()) {
            this.myContext.putUserData(FOCUSED_VIEWER_KEY, (Object)this.myPropertiesViewerFocused);
        }
        this.mySettings.setSplitterProportion(this.mySplitter.getProportion());
    }

    @Nullable
    private JComponent createNotification() {
        if (this.myPropertyRequest instanceof ErrorDiffRequest) {
            return SvnDiffViewer.createNotification(((ErrorDiffRequest)this.myPropertyRequest).getMessage());
        }
        List<DiffContent> contents = ((SvnPropertiesDiffRequest)this.myPropertyRequest).getContents();
        Map<String, PropertyValue> before = SvnDiffViewer.getProperties(contents.get(0));
        Map<String, PropertyValue> after = SvnDiffViewer.getProperties(contents.get(1));
        if (before.isEmpty() && after.isEmpty()) {
            return null;
        }
        if (!before.keySet().equals(after.keySet())) {
            return SvnDiffViewer.createNotification("SVN Properties changed");
        }
        for (String key : before.keySet()) {
            if (Comparing.equal((Object)before.get(key), (Object)after.get(key))) continue;
            return SvnDiffViewer.createNotification("SVN Properties changed");
        }
        return null;
    }

    @NotNull
    private static Map<String, PropertyValue> getProperties(@NotNull DiffContent content) {
        if (content == null) {
            SvnDiffViewer.$$$reportNull$$$0(8);
        }
        if (content instanceof EmptyContent) {
            Map<String, PropertyValue> map = Collections.emptyMap();
            if (map == null) {
                SvnDiffViewer.$$$reportNull$$$0(9);
            }
            return map;
        }
        List<PropertyData> properties = ((SvnPropertiesDiffRequest.PropertyContent)content).getProperties();
        HashMap<String, PropertyValue> map = new HashMap<String, PropertyValue>();
        for (PropertyData data : properties) {
            if (map.containsKey(data.getName())) {
                LOG.warn("Duplicated property: " + data.getName());
            }
            map.put(data.getName(), data.getValue());
        }
        HashMap<String, PropertyValue> hashMap = map;
        if (hashMap == null) {
            SvnDiffViewer.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    @NotNull
    private static JPanel createNotification(@NotNull String text) {
        if (text == null) {
            SvnDiffViewer.$$$reportNull$$$0(11);
        }
        EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel().text(text);
        if (editorNotificationPanel == null) {
            SvnDiffViewer.$$$reportNull$$$0(12);
        }
        return editorNotificationPanel;
    }

    private void updatePropertiesPanel() {
        DiffUtil.runPreservingFocus((FocusableContext)this.myContext, () -> {
            if (!this.mySettings.isHideProperties()) {
                this.mySplitter.setSecondComponent(this.myPropertiesViewer.getComponent());
                this.myNotificationPanel.setContent(null);
            } else {
                this.mySplitter.setSecondComponent(null);
                this.myNotificationPanel.setContent(this.createNotification());
            }
        });
    }

    @NotNull
    private List<AnAction> createToolbar(@Nullable List<AnAction> propertiesActions) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        if (propertiesActions != null) {
            result.addAll(propertiesActions);
        }
        result.add((AnAction)new ToggleHidePropertiesAction());
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            SvnDiffViewer.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private static SvnDiffSettingsHolder.SvnDiffSettings initSettings(@NotNull DiffContext context) {
        SvnDiffSettingsHolder.SvnDiffSettings settings;
        if (context == null) {
            SvnDiffViewer.$$$reportNull$$$0(14);
        }
        if ((settings = (SvnDiffSettingsHolder.SvnDiffSettings)context.getUserData(SvnDiffSettingsHolder.SvnDiffSettings.KEY)) == null) {
            settings = SvnDiffSettingsHolder.SvnDiffSettings.getSettings();
            context.putUserData(SvnDiffSettingsHolder.SvnDiffSettings.KEY, (Object)settings);
        }
        SvnDiffSettingsHolder.SvnDiffSettings svnDiffSettings = settings;
        if (svnDiffSettings == null) {
            SvnDiffViewer.$$$reportNull$$$0(15);
        }
        return svnDiffSettings;
    }

    @NotNull
    private MyPropertyContext initPropertyContext(@NotNull DiffContext context) {
        MyPropertyContext propertyContext;
        if (context == null) {
            SvnDiffViewer.$$$reportNull$$$0(16);
        }
        if ((propertyContext = (MyPropertyContext)((Object)context.getUserData(PROPERTY_CONTEXT_KEY))) == null) {
            propertyContext = new MyPropertyContext();
            context.putUserData(PROPERTY_CONTEXT_KEY, (Object)propertyContext);
        }
        MyPropertyContext myPropertyContext = propertyContext;
        if (myPropertyContext == null) {
            SvnDiffViewer.$$$reportNull$$$0(17);
        }
        return myPropertyContext;
    }

    private void installListeners() {
        this.myContentViewer.getComponent().addFocusListener(this.myContentFocusListener);
        this.myPropertiesViewer.getComponent().addFocusListener(this.myPropertiesFocusListener);
    }

    private void destroyListeners() {
        this.myContentViewer.getComponent().removeFocusListener(this.myContentFocusListener);
        this.myPropertiesViewer.getComponent().removeFocusListener(this.myPropertiesFocusListener);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            SvnDiffViewer.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (this.myPropertiesViewerFocused) {
            JComponent component = this.getPropertiesPreferredFocusedComponent();
            if (component != null) {
                return component;
            }
            return this.myContentViewer.getPreferredFocusedComponent();
        }
        JComponent component = this.myContentViewer.getPreferredFocusedComponent();
        if (component != null) {
            return component;
        }
        return this.getPropertiesPreferredFocusedComponent();
    }

    @Nullable
    private JComponent getPropertiesPreferredFocusedComponent() {
        if (this.mySettings.isHideProperties()) {
            return null;
        }
        return this.myPropertiesViewer.getPreferredFocusedComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyRequest";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappingViewer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/difftool/SvnDiffViewer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/difftool/SvnDiffViewer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertiesViewer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "initSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "initPropertyContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesViewer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "initSettings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "initPropertyContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySplitter
    extends Splitter {
        @NotNull
        private final String myLabelText;

        public MySplitter(@NotNull String text) {
            if (text == null) {
                MySplitter.$$$reportNull$$$0(0);
            }
            super(true);
            this.myLabelText = text;
        }

        protected Divider createDivider() {
            return new Splitter.DividerImpl(){

                public void setOrientation(boolean isVerticalSplit) {
                    if (!this.isVertical()) {
                        LOG.warn("unsupported state: splitter should be vertical");
                    }
                    this.removeAll();
                    this.setCursor(Cursor.getPredefinedCursor(8));
                    JLabel label = new JLabel(myLabelText);
                    label.setFont(UIUtil.getOptionPaneMessageFont());
                    label.setForeground(UIUtil.getLabelForeground());
                    this.add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, (Insets)JBUI.insets((int)2), 0, 0));
                    this.setDividerWidth(label.getPreferredSize().height + JBUI.scale((int)4));
                    this.revalidate();
                    this.repaint();
                }

                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    g.setColor(JBColor.border());
                    UIUtil.drawLine((Graphics)g, (int)0, (int)0, (int)this.getWidth(), (int)0);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/svn/difftool/SvnDiffViewer$MySplitter", "<init>"));
        }
    }

    private class MyFocusListener
    extends FocusAdapter {
        private final boolean myValue;

        public MyFocusListener(boolean value) {
            this.myValue = value;
        }

        @Override
        public void focusGained(FocusEvent e) {
            SvnDiffViewer.this.myPropertiesViewerFocused = this.myValue;
        }
    }

    private class MyPropertyContext
    extends DiffContext {
        private MyPropertyContext() {
        }

        @Nullable
        public Project getProject() {
            return SvnDiffViewer.this.myContext.getProject();
        }

        public boolean isWindowFocused() {
            return SvnDiffViewer.this.myContext.isWindowFocused();
        }

        public boolean isFocused() {
            return DiffUtil.isFocusedComponent((Project)this.getProject(), (Component)SvnDiffViewer.this.myPropertiesViewer.getComponent());
        }

        public void requestFocus() {
            DiffUtil.requestFocus((Project)this.getProject(), (Component)SvnDiffViewer.this.myPropertiesViewer.getPreferredFocusedComponent());
        }
    }

    private class ToggleHidePropertiesAction
    extends ToggleAction
    implements DumbAware {
        public ToggleHidePropertiesAction() {
            ActionUtil.copyFrom((AnAction)this, (String)"Subversion.TogglePropertiesDiff");
        }

        public boolean isSelected(AnActionEvent e) {
            return !SvnDiffViewer.this.mySettings.isHideProperties();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            SvnDiffViewer.this.mySettings.setHideProperties(!state);
            SvnDiffViewer.this.updatePropertiesPanel();
        }
    }
}

