/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import org.gradle.api.Action;
import org.gradle.api.InvalidActionClosureException;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.util.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClosureBackedAction<T>
implements Action<T> {
    private final Closure closure;
    private final int resolveStrategy;
    private final boolean configureableAware;

    public static <T> ClosureBackedAction<T> of(Closure<?> closure) {
        return new ClosureBackedAction<T>(closure);
    }

    public ClosureBackedAction(Closure closure) {
        this(closure, 1, true);
    }

    public ClosureBackedAction(Closure closure, int resolveStrategy) {
        this(closure, resolveStrategy, false);
    }

    public ClosureBackedAction(Closure closure, int resolveStrategy, boolean configureableAware) {
        this.closure = closure;
        this.resolveStrategy = resolveStrategy;
        this.configureableAware = configureableAware;
    }

    public static <T> void execute(T delegate, Closure<?> closure) {
        new ClosureBackedAction<T>(closure).execute(delegate);
    }

    @Override
    public void execute(T delegate) {
        if (this.closure == null) {
            return;
        }
        try {
            if (this.configureableAware && delegate instanceof Configurable) {
                ((Configurable)delegate).configure(this.closure);
            } else {
                Closure copy = (Closure)this.closure.clone();
                copy.setResolveStrategy(this.resolveStrategy);
                copy.setDelegate(delegate);
                if (copy.getMaximumNumberOfParameters() == 0) {
                    copy.call();
                } else {
                    copy.call(delegate);
                }
            }
        }
        catch (MissingMethodException e) {
            if (Objects.equal((Object)e.getType(), this.closure.getClass()) && Objects.equal((Object)e.getMethod(), (Object)"doCall")) {
                throw new InvalidActionClosureException(this.closure, delegate);
            }
            throw e;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClosureBackedAction that = (ClosureBackedAction)o;
        return this.configureableAware == that.configureableAware && this.resolveStrategy == that.resolveStrategy && this.closure.equals(that.closure);
    }

    public int hashCode() {
        int result = this.closure.hashCode();
        result = 31 * result + (this.configureableAware ? 1 : 0);
        result = 31 * result + this.resolveStrategy;
        return result;
    }
}

