/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.ModuleIdentifier;

public class DefaultModuleIdentifier
implements ModuleIdentifier {
    private final String group;
    private final String name;

    private DefaultModuleIdentifier(String group, String name) {
        assert (group != null) : "group cannot be null";
        assert (name != null) : "name cannot be null";
        this.group = group;
        this.name = name;
    }

    public static ModuleIdentifier newId(ModuleIdentifier other) {
        if (other instanceof DefaultModuleIdentifier) {
            return other;
        }
        return DefaultModuleIdentifier.newId(other.getGroup(), other.getName());
    }

    public static ModuleIdentifier newId(String group, String name) {
        return new DefaultModuleIdentifier(group, name);
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s:%s", this.group, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultModuleIdentifier other = (DefaultModuleIdentifier)obj;
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.group.equals(other.group);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() ^ this.group.hashCode();
    }
}

