/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.CompositeTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.DeclaredTaskOutputFileProperty;
import org.gradle.api.internal.tasks.DefaultCacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskOutputCachingState;
import org.gradle.api.internal.tasks.NonCacheableTaskOutputPropertySpec;
import org.gradle.api.internal.tasks.OutputType;
import org.gradle.api.internal.tasks.StaticValue;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidatingValue;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private static final TaskOutputCachingState ENABLED = DefaultTaskOutputCachingState.enabled();
    public static final TaskOutputCachingState DISABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.BUILD_CACHE_DISABLED, "Task output caching is disabled");
    private static final TaskOutputCachingState CACHING_NOT_ENABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NOT_ENABLED_FOR_TASK, "Caching has not been enabled for the task");
    private static final TaskOutputCachingState NO_OUTPUTS_DECLARED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NO_OUTPUTS_DECLARED, "No outputs declared");
    private final FileCollection allOutputFiles;
    private AndSpec<TaskInternal> upToDateSpec = AndSpec.empty();
    private List<SelfDescribingSpec<TaskInternal>> cacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private List<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs = new LinkedList<SelfDescribingSpec<TaskInternal>>();
    private TaskExecutionHistory history;
    private final List<DeclaredTaskOutputFileProperty> declaredFileProperties = Lists.newArrayList();
    private ImmutableSortedSet<TaskOutputFilePropertySpec> fileProperties;
    private final FileResolver resolver;
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private static final ValidationAction OUTPUT_FILE_VALIDATOR = new ValidationAction(){

        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            block2: {
                File file;
                block1: {
                    file = DefaultTaskOutputs.toFile(context, value);
                    if (!file.exists()) break block1;
                    if (!file.isDirectory()) break block2;
                    context.recordValidationMessage(severity, String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", file, propertyName));
                    break block2;
                }
                for (File candidate = file.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    context.recordValidationMessage(severity, String.format("Cannot write to file '%s' specified for property '%s', as ancestor '%s' is not a directory.", file, propertyName, candidate));
                    break;
                }
            }
        }
    };
    private static final ValidationAction OUTPUT_FILES_VALIDATOR = new ValidationAction(){

        public void validate(String propertyName, Object values, TaskValidationContext context, TaskValidationContext.Severity severity) {
            for (File file : DefaultTaskOutputs.toFiles(context, values)) {
                OUTPUT_FILE_VALIDATOR.validate(propertyName, file, context, severity);
            }
        }
    };
    private static final ValidationAction OUTPUT_DIRECTORY_VALIDATOR = new ValidationAction(){

        public void validate(String propertyName, Object value, TaskValidationContext context, TaskValidationContext.Severity severity) {
            File directory = DefaultTaskOutputs.toFile(context, value);
            if (directory.exists()) {
                if (!directory.isDirectory()) {
                    context.recordValidationMessage(severity, String.format("Directory '%s' specified for property '%s' is not a directory.", directory, propertyName));
                }
            } else {
                for (File candidate = directory.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                    if (!candidate.exists() || candidate.isDirectory()) continue;
                    context.recordValidationMessage(severity, String.format("Cannot write to directory '%s' specified for property '%s', as ancestor '%s' is not a directory.", directory, propertyName, candidate));
                    return;
                }
            }
        }
    };
    private static final ValidationAction OUTPUT_DIRECTORIES_VALIDATOR = new ValidationAction(){

        public void validate(String propertyName, Object values, TaskValidationContext context, TaskValidationContext.Severity severity) {
            for (File directory : DefaultTaskOutputs.toFiles(context, values)) {
                OUTPUT_DIRECTORY_VALIDATOR.validate(propertyName, directory, context, severity);
            }
        }
    };

    public DefaultTaskOutputs(FileResolver resolver, TaskInternal task, TaskMutator taskMutator) {
        this.resolver = resolver;
        this.task = task;
        this.taskMutator = taskMutator;
        this.allOutputFiles = new TaskOutputUnionFileCollection(task);
    }

    @Override
    public Spec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    @Override
    public void upToDateWhen(final Closure upToDateClosure) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Closure)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(upToDateClosure);
            }
        });
    }

    @Override
    public void upToDateWhen(final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.upToDateWhen(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.upToDateSpec = DefaultTaskOutputs.this.upToDateSpec.and(spec);
            }
        });
    }

    @Override
    public TaskOutputCachingState getCachingState() {
        if (this.cacheIfSpecs.isEmpty()) {
            return CACHING_NOT_ENABLED;
        }
        if (!this.hasDeclaredOutputs()) {
            return NO_OUTPUTS_DECLARED;
        }
        OverlappingOutputs overlappingOutputs = this.getOverlappingOutputs();
        if (overlappingOutputs != null) {
            String relativePath = this.task.getProject().relativePath(overlappingOutputs.getOverlappedFilePath());
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.OVERLAPPING_OUTPUTS, String.format("Gradle does not know how file '%s' was created (output property '%s'). Task output caching requires exclusive access to output paths to guarantee correctness.", relativePath, overlappingOutputs.getPropertyName()));
        }
        for (TaskPropertySpec spec : this.getFileProperties()) {
            if (!(spec instanceof NonCacheableTaskOutputPropertySpec)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.PLURAL_OUTPUTS, "Declares multiple output files for the single output property '" + ((NonCacheableTaskOutputPropertySpec)spec).getOriginalPropertyName() + "' via `@OutputFiles`, `@OutputDirectories` or `TaskOutputs.files()`");
        }
        for (SelfDescribingSpec<TaskInternal> selfDescribingSpec : this.cacheIfSpecs) {
            if (selfDescribingSpec.isSatisfiedBy(this.task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.CACHE_IF_SPEC_NOT_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' not satisfied");
        }
        for (SelfDescribingSpec<TaskInternal> selfDescribingSpec : this.doNotCacheIfSpecs) {
            if (!selfDescribingSpec.isSatisfiedBy(this.task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.DO_NOT_CACHE_IF_SPEC_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' satisfied");
        }
        return ENABLED;
    }

    @Nullable
    private OverlappingOutputs getOverlappingOutputs() {
        return this.history != null ? this.history.getOverlappingOutputs() : null;
    }

    @Override
    public void cacheIf(Spec<? super Task> spec) {
        this.cacheIf("Task outputs cacheable", spec);
    }

    @Override
    public void cacheIf(final String cachingEnabledReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.cacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.cacheIfSpecs.add(new SelfDescribingSpec(spec, cachingEnabledReason));
            }
        });
    }

    @Override
    public void doNotCacheIf(final String cachingDisabledReason, final Spec<? super Task> spec) {
        this.taskMutator.mutate("TaskOutputs.doNotCacheIf(Spec)", new Runnable(){

            public void run() {
                DefaultTaskOutputs.this.doNotCacheIfSpecs.add(new SelfDescribingSpec(spec, cachingDisabledReason));
            }
        });
    }

    @Override
    public boolean getHasOutput() {
        return this.hasDeclaredOutputs() || !this.upToDateSpec.isEmpty();
    }

    @Override
    public boolean hasDeclaredOutputs() {
        return !this.declaredFileProperties.isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.allOutputFiles;
    }

    @Override
    public ImmutableSortedSet<TaskOutputFilePropertySpec> getFileProperties() {
        if (this.fileProperties == null) {
            TaskPropertyUtils.ensurePropertiesHaveNames(this.declaredFileProperties);
            Iterator flattenedProperties = Iterators.concat(Iterables.transform(this.declaredFileProperties, (Function)new Function<TaskPropertySpec, Iterator<? extends TaskOutputFilePropertySpec>>(){

                public Iterator<? extends TaskOutputFilePropertySpec> apply(@Nullable TaskPropertySpec propertySpec) {
                    File outputFile;
                    if (propertySpec instanceof CompositeTaskOutputPropertySpec) {
                        return ((CompositeTaskOutputPropertySpec)propertySpec).resolveToOutputProperties();
                    }
                    if (propertySpec instanceof CacheableTaskOutputFilePropertySpec && (outputFile = ((CacheableTaskOutputFilePropertySpec)propertySpec).getOutputFile()) == null) {
                        return Iterators.emptyIterator();
                    }
                    return Iterators.singletonIterator((Object)((TaskOutputFilePropertySpec)propertySpec));
                }
            }).iterator());
            this.fileProperties = TaskPropertyUtils.collectFileProperties("output", flattenedProperties);
        }
        return this.fileProperties;
    }

    @Override
    public TaskOutputFilePropertyBuilder file(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.file(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.file(new StaticValue(path));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder file(ValidatingValue path) {
        return this.addSpec(new DefaultCacheableTaskOutputFilePropertySpec(this.task.getName(), this.resolver, OutputType.FILE, path, OUTPUT_FILE_VALIDATOR));
    }

    @Override
    public TaskOutputFilePropertyBuilder dir(final Object path) {
        return this.taskMutator.mutate("TaskOutputs.dir(Object)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.dir(new StaticValue(path));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder dir(ValidatingValue path) {
        return this.addSpec(new DefaultCacheableTaskOutputFilePropertySpec(this.task.getName(), this.resolver, OutputType.DIRECTORY, path, OUTPUT_DIRECTORY_VALIDATOR));
    }

    @Override
    public TaskOutputFilePropertyBuilder files(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.files(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.files(new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths)));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder files(ValidatingValue paths) {
        return this.addSpec(new CompositeTaskOutputPropertySpec(this.task.getName(), this.resolver, OutputType.FILE, paths, OUTPUT_FILES_VALIDATOR));
    }

    @Override
    public TaskOutputFilePropertyBuilder dirs(final Object ... paths) {
        return this.taskMutator.mutate("TaskOutputs.dirs(Object...)", new Callable<TaskOutputFilePropertyBuilder>(){

            @Override
            public TaskOutputFilePropertyBuilder call() throws Exception {
                return DefaultTaskOutputs.this.dirs(new StaticValue(DefaultTaskOutputs.resolveSingleArray(paths)));
            }
        });
    }

    @Override
    public TaskOutputFilePropertyBuilder dirs(ValidatingValue paths) {
        return this.addSpec(new CompositeTaskOutputPropertySpec(this.task.getName(), this.resolver, OutputType.DIRECTORY, paths, OUTPUT_DIRECTORIES_VALIDATOR));
    }

    @Nullable
    private static Object resolveSingleArray(@Nullable Object[] paths) {
        return paths != null && paths.length == 1 ? paths[0] : paths;
    }

    private TaskOutputFilePropertyBuilder addSpec(DeclaredTaskOutputFileProperty spec) {
        this.declaredFileProperties.add(spec);
        return spec;
    }

    @Override
    public Set<File> getPreviousOutputFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(@Nullable TaskExecutionHistory history) {
        this.history = history;
    }

    @Override
    public void validate(TaskValidationContext context) {
        TaskPropertyUtils.ensurePropertiesHaveNames(this.declaredFileProperties);
        for (DeclaredTaskOutputFileProperty property : this.declaredFileProperties) {
            property.validate(context);
        }
    }

    private static File toFile(TaskValidationContext context, Object value) {
        if (value instanceof File) {
            return (File)value;
        }
        return context.getResolver().resolve(value);
    }

    private static Iterable<? extends File> toFiles(TaskValidationContext context, Object value) {
        if (value instanceof Map) {
            return DefaultTaskOutputs.toFiles(context, ((Map)value).values());
        }
        if (value instanceof FileCollection) {
            return ((FileCollection)value).getFiles();
        }
        return context.getResolver().resolveFiles(value);
    }

    private class TaskOutputUnionFileCollection
    extends CompositeFileCollection
    implements Describable {
        private final TaskInternal buildDependencies;

        public TaskOutputUnionFileCollection(TaskInternal buildDependencies) {
            this.buildDependencies = buildDependencies;
        }

        public String getDisplayName() {
            return "task '" + DefaultTaskOutputs.this.task.getName() + "' output files";
        }

        public void visitContents(FileCollectionResolveContext context) {
            for (TaskFilePropertySpec propertySpec : DefaultTaskOutputs.this.getFileProperties()) {
                context.add(propertySpec.getPropertyFiles());
            }
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            context.add(this.buildDependencies);
            super.visitDependencies(context);
        }
    }
}

