/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class DefaultJarSnapshotCache
implements JarSnapshotCache {
    private final MinimalPersistentCache<HashCode, JarSnapshotData> cache;

    public DefaultJarSnapshotCache(PersistentIndexedCache<HashCode, JarSnapshotData> persistentCache) {
        this.cache = new MinimalPersistentCache<HashCode, JarSnapshotData>(persistentCache);
    }

    @Override
    public Map<File, JarSnapshot> getJarSnapshots(Map<File, HashCode> jarHashes) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        for (Map.Entry<File, HashCode> entry : jarHashes.entrySet()) {
            JarSnapshotData snapshotData = this.cache.get(entry.getValue());
            if (snapshotData == null) {
                throw new IllegalStateException("No Jar snapshot data available for " + entry.getKey() + " with hash " + entry.getValue() + ".");
            }
            JarSnapshot snapshot = new JarSnapshot(snapshotData);
            out.put(entry.getKey(), snapshot);
        }
        return out;
    }

    @Override
    public JarSnapshot get(HashCode key, final Factory<JarSnapshot> factory) {
        return new JarSnapshot(this.cache.get(key, new Factory<JarSnapshotData>(){

            @Override
            public JarSnapshotData create() {
                return ((JarSnapshot)factory.create()).getData();
            }
        }));
    }
}

