/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.detection.TestClassVisitor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.internal.FileUtils;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.impldep.org.objectweb.asm.ClassReader;
import org.gradle.internal.impldep.org.objectweb.asm.Type;

public abstract class AbstractTestFrameworkDetector<T extends TestClassVisitor>
implements TestFrameworkDetector {
    protected static final String TEST_CASE = "junit/framework/TestCase";
    protected static final String GROOVY_TEST_CASE = "groovy/util/GroovyTestCase";
    protected static final String JAVA_LANG_OBJECT = "java/lang/Object";
    private List<File> testClassDirectories;
    private final ClassFileExtractionManager classFileExtractionManager;
    private final Map<File, Boolean> superClasses;
    private TestClassProcessor testClassProcessor;
    private final List<String> knownTestCaseClassNames;
    private Set<File> testClassesDirectories;
    private Set<File> testClasspath;

    protected AbstractTestFrameworkDetector(ClassFileExtractionManager classFileExtractionManager) {
        assert (classFileExtractionManager != null);
        this.classFileExtractionManager = classFileExtractionManager;
        this.superClasses = new HashMap<File, Boolean>();
        this.knownTestCaseClassNames = new ArrayList<String>();
        this.addKnownTestCaseClassNames("org/gradle/internal/impldep/junit/framework/TestCase", GROOVY_TEST_CASE);
    }

    protected abstract T createClassVisitor();

    protected File getSuperTestClassFile(String superClassName) {
        this.prepareClasspath();
        if (StringUtils.isEmpty((String)superClassName)) {
            throw new IllegalArgumentException("superClassName is empty!");
        }
        Iterator<File> testClassDirectoriesIt = this.testClassDirectories.iterator();
        File superTestClassFile = null;
        while (superTestClassFile == null && testClassDirectoriesIt.hasNext()) {
            File testClassDirectory = testClassDirectoriesIt.next();
            File superTestClassFileCandidate = new File(testClassDirectory, superClassName + ".class");
            if (!superTestClassFileCandidate.exists()) continue;
            superTestClassFile = superTestClassFileCandidate;
        }
        if (superTestClassFile != null) {
            return superTestClassFile;
        }
        if (JAVA_LANG_OBJECT.equals(superClassName)) {
            return null;
        }
        return this.classFileExtractionManager.getLibraryClassFile(superClassName);
    }

    private void prepareClasspath() {
        if (this.testClassDirectories != null) {
            return;
        }
        this.testClassDirectories = new ArrayList<File>();
        if (this.testClassesDirectories != null) {
            this.testClassDirectories.addAll(this.testClassesDirectories);
        }
        if (this.testClasspath != null) {
            for (File file : this.testClasspath) {
                if (file.isDirectory()) {
                    this.testClassDirectories.add(file);
                    continue;
                }
                if (!file.isFile() || !FileUtils.hasExtension(file, ".jar")) continue;
                this.classFileExtractionManager.addLibraryJar(file);
            }
        }
    }

    @Override
    public void setTestClasses(Set<File> testClassesDirectories) {
        this.testClassesDirectories = testClassesDirectories;
    }

    @Override
    public void setTestClasspath(Set<File> testClasspath) {
        this.testClasspath = testClasspath;
    }

    protected TestClassVisitor classVisitor(File testClassFile) {
        T classVisitor = this.createClassVisitor();
        BufferedInputStream classStream = null;
        try {
            classStream = new BufferedInputStream(new FileInputStream(testClassFile));
            ClassReader classReader = new ClassReader(IOUtils.toByteArray((InputStream)classStream));
            classReader.accept(classVisitor, 7);
        }
        catch (Throwable e) {
            try {
                throw new GradleException("failed to read class file " + testClassFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(classStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)classStream);
        return classVisitor;
    }

    @Override
    public boolean processTestClass(File testClassFile) {
        return this.processTestClass(testClassFile, false);
    }

    protected abstract boolean processTestClass(File var1, boolean var2);

    protected boolean processSuperClass(File testClassFile) {
        boolean isTest = false;
        Boolean isSuperTest = this.superClasses.get(testClassFile);
        if (isSuperTest == null) {
            isTest = this.processTestClass(testClassFile, true);
            this.superClasses.put(testClassFile, isTest);
        } else {
            isTest = isSuperTest;
        }
        return isTest;
    }

    protected void publishTestClass(boolean isTest, TestClassVisitor classVisitor, boolean superClass) {
        if (isTest && !classVisitor.isAbstract() && !superClass) {
            String className = Type.getObjectType((String)classVisitor.getClassName()).getClassName();
            this.testClassProcessor.processTestClass(new DefaultTestClassRunInfo(className));
        }
    }

    @Override
    public void startDetection(TestClassProcessor testClassProcessor) {
        this.testClassProcessor = testClassProcessor;
    }

    public void addKnownTestCaseClassNames(String ... knownTestCaseClassNames) {
        if (knownTestCaseClassNames != null && knownTestCaseClassNames.length != 0) {
            for (String knownTestCaseClassName : knownTestCaseClassNames) {
                if (!StringUtils.isNotEmpty((String)knownTestCaseClassName)) continue;
                this.knownTestCaseClassNames.add(knownTestCaseClassName.replaceAll("\\.", "/"));
            }
        }
    }

    protected boolean isKnownTestCaseClassName(String testCaseClassName) {
        boolean isKnownTestCase = false;
        if (StringUtils.isNotEmpty((String)testCaseClassName)) {
            isKnownTestCase = this.knownTestCaseClassNames.contains(testCaseClassName);
        }
        return isKnownTestCase;
    }
}

