/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import java.io.File;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.tasks.testing.DefaultTestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;

public class DefaultTestClassScanner
implements Runnable {
    private final FileTree candidateClassFiles;
    private final TestFrameworkDetector testFrameworkDetector;
    private final TestClassProcessor testClassProcessor;

    public DefaultTestClassScanner(FileTree candidateClassFiles, TestFrameworkDetector testFrameworkDetector, TestClassProcessor testClassProcessor) {
        this.candidateClassFiles = candidateClassFiles;
        this.testFrameworkDetector = testFrameworkDetector;
        this.testClassProcessor = testClassProcessor;
    }

    @Override
    public void run() {
        if (this.testFrameworkDetector == null) {
            this.filenameScan();
        } else {
            this.detectionScan();
        }
    }

    private void detectionScan() {
        this.testFrameworkDetector.startDetection(this.testClassProcessor);
        this.candidateClassFiles.visit(new ClassFileVisitor(){

            @Override
            public void visitClassFile(FileVisitDetails fileDetails) {
                DefaultTestClassScanner.this.testFrameworkDetector.processTestClass(fileDetails.getFile());
            }
        });
    }

    private void filenameScan() {
        this.candidateClassFiles.visit(new ClassFileVisitor(){

            @Override
            public void visitClassFile(FileVisitDetails fileDetails) {
                String className = fileDetails.getRelativePath().getPathString().replaceAll("\\.class", "").replace('/', '.');
                DefaultTestClassRunInfo testClass = new DefaultTestClassRunInfo(className);
                DefaultTestClassScanner.this.testClassProcessor.processTestClass(testClass);
            }
        });
    }

    private abstract class ClassFileVisitor
    extends EmptyFileVisitor {
        private ClassFileVisitor() {
        }

        @Override
        public void visitFile(FileVisitDetails fileDetails) {
            File file = fileDetails.getFile();
            if (file.getAbsolutePath().endsWith(".class")) {
                this.visitClassFile(fileDetails);
            }
        }

        public abstract void visitClassFile(FileVisitDetails var1);
    }
}

