/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import groovy.lang.Closure;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.tasks.testing.DefaultTestTaskReports;
import org.gradle.api.internal.tasks.testing.TestExecuter;
import org.gradle.api.internal.tasks.testing.TestExecutionSpec;
import org.gradle.api.internal.tasks.testing.junit.result.Binary2JUnitXmlReportGenerator;
import org.gradle.api.internal.tasks.testing.junit.result.InMemoryTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputAssociation;
import org.gradle.api.internal.tasks.testing.junit.result.TestOutputStore;
import org.gradle.api.internal.tasks.testing.junit.result.TestReportDataCollector;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultSerializer;
import org.gradle.api.internal.tasks.testing.logging.DefaultTestLoggingContainer;
import org.gradle.api.internal.tasks.testing.logging.FullExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.ShortExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.TestCountLogger;
import org.gradle.api.internal.tasks.testing.logging.TestEventLogger;
import org.gradle.api.internal.tasks.testing.logging.TestExceptionFormatter;
import org.gradle.api.internal.tasks.testing.logging.TestWorkerProgressListener;
import org.gradle.api.internal.tasks.testing.report.DefaultTestReport;
import org.gradle.api.internal.tasks.testing.report.TestReporter;
import org.gradle.api.internal.tasks.testing.results.StateTrackingTestResultProcessor;
import org.gradle.api.internal.tasks.testing.results.TestListenerAdapter;
import org.gradle.api.internal.tasks.testing.results.TestListenerInternal;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.api.tasks.testing.JUnitXmlReport;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestOutputListener;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.api.tasks.testing.logging.TestLogging;
import org.gradle.api.tasks.testing.logging.TestLoggingContainer;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.org.bouncycastle.util.test.Test;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.util.ConfigureUtil;

public abstract class AbstractTestTask
extends ConventionTask
implements VerificationTask,
Reporting<TestTaskReports> {
    private final TestTaskReports reports;
    private final ListenerBroadcast<TestListener> testListenerBroadcaster;
    private final ListenerBroadcast<TestOutputListener> testOutputListenerBroadcaster;
    private final ListenerBroadcast<TestListenerInternal> testListenerInternalBroadcaster;
    private final TestLoggingContainer testLogging;
    private final DirectoryProperty binaryResultsDirectory;
    private TestReporter testReporter;
    private boolean ignoreFailures;

    public AbstractTestTask() {
        Instantiator instantiator = this.getInstantiator();
        this.testLogging = instantiator.newInstance(DefaultTestLoggingContainer.class, instantiator);
        ListenerManager listenerManager = this.getListenerManager();
        this.testListenerInternalBroadcaster = listenerManager.createAnonymousBroadcaster(TestListenerInternal.class);
        this.testOutputListenerBroadcaster = listenerManager.createAnonymousBroadcaster(TestOutputListener.class);
        this.testListenerBroadcaster = listenerManager.createAnonymousBroadcaster(TestListener.class);
        this.binaryResultsDirectory = this.newOutputDirectory();
        this.reports = instantiator.newInstance(DefaultTestTaskReports.class, this);
        this.reports.getJunitXml().setEnabled(true);
        this.reports.getHtml().setEnabled(true);
    }

    @Inject
    protected ProgressLoggerFactory getProgressLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected InetAddressFactory getInetAddressFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildOperationExecutor getBuildOperationExecutor() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected Instantiator getInstantiator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ListenerManager getListenerManager() {
        throw new UnsupportedOperationException();
    }

    @Incubating
    protected abstract TestExecuter<? extends TestExecutionSpec> createTestExecuter();

    @Incubating
    protected abstract TestExecutionSpec createTestExecutionSpec();

    @Internal
    @VisibleForTesting
    ListenerBroadcast<TestOutputListener> getTestOutputListenerBroadcaster() {
        return this.testOutputListenerBroadcaster;
    }

    @Internal
    @VisibleForTesting
    ListenerBroadcast<TestListenerInternal> getTestListenerInternalBroadcaster() {
        return this.testListenerInternalBroadcaster;
    }

    @VisibleForTesting
    void setTestReporter(TestReporter testReporter) {
        this.testReporter = testReporter;
    }

    private LogLevel determineCurrentLogLevel() {
        for (LogLevel level : LogLevel.values()) {
            if (!this.getLogger().isEnabled(level)) continue;
            return level;
        }
        throw new AssertionError((Object)"could not determine current log level");
    }

    @OutputDirectory
    @Incubating
    public File getBinResultsDir() {
        return this.binaryResultsDirectory.getAsFile().getOrNull();
    }

    @Incubating
    public void setBinResultsDir(File binResultsDir) {
        this.binaryResultsDirectory.set(binResultsDir);
    }

    @Internal
    @Incubating
    public DirectoryProperty getBinaryResultsDirectory() {
        return this.binaryResultsDirectory;
    }

    public void addTestListener(TestListener listener) {
        this.testListenerBroadcaster.add(listener);
    }

    public void addTestOutputListener(TestOutputListener listener) {
        this.testOutputListenerBroadcaster.add(listener);
    }

    public void removeTestListener(TestListener listener) {
        this.testListenerBroadcaster.remove(listener);
    }

    public void removeTestOutputListener(TestOutputListener listener) {
        this.testOutputListenerBroadcaster.remove(listener);
    }

    @Override
    @Internal
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    private TestExceptionFormatter getExceptionFormatter(TestLogging testLogging) {
        switch (testLogging.getExceptionFormat()) {
            case SHORT: {
                return new ShortExceptionFormatter(testLogging);
            }
            case FULL: {
                return new FullExceptionFormatter(testLogging);
            }
        }
        throw new AssertionError();
    }

    public void onOutput(Closure closure) {
        this.testOutputListenerBroadcaster.add(new ClosureBackedMethodInvocationDispatch("onOutput", closure));
    }

    public void beforeSuite(Closure closure) {
        this.testListenerBroadcaster.add(new ClosureBackedMethodInvocationDispatch("beforeSuite", closure));
    }

    public void afterSuite(Closure closure) {
        this.testListenerBroadcaster.add(new ClosureBackedMethodInvocationDispatch("afterSuite", closure));
    }

    public void beforeTest(Closure closure) {
        this.testListenerBroadcaster.add(new ClosureBackedMethodInvocationDispatch("beforeTest", closure));
    }

    public void afterTest(Closure closure) {
        this.testListenerBroadcaster.add(new ClosureBackedMethodInvocationDispatch("afterTest", closure));
    }

    @Internal
    public TestLoggingContainer getTestLogging() {
        return this.testLogging;
    }

    public void testLogging(Closure closure) {
        ConfigureUtil.configure(closure, this.testLogging);
    }

    public void testLogging(Action<? super TestLoggingContainer> action) {
        action.execute(this.testLogging);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void executeTests() {
        LogLevel currentLevel = this.determineCurrentLogLevel();
        TestLogging levelLogging = this.getTestLogging().get(currentLevel);
        TestExceptionFormatter exceptionFormatter = this.getExceptionFormatter(levelLogging);
        TestEventLogger eventLogger = new TestEventLogger(this.getTextOutputFactory(), currentLevel, levelLogging, exceptionFormatter);
        this.addTestListener(eventLogger);
        this.addTestOutputListener(eventLogger);
        File binaryResultsDir = this.getBinResultsDir();
        this.getProject().delete(binaryResultsDir);
        this.getProject().mkdir(binaryResultsDir);
        HashMap<String, TestClassResult> results = new HashMap<String, TestClassResult>();
        TestOutputStore testOutputStore = new TestOutputStore(binaryResultsDir);
        TestOutputStore.Writer outputWriter = testOutputStore.writer();
        TestReportDataCollector testReportDataCollector = new TestReportDataCollector(results, outputWriter);
        this.addTestListener(testReportDataCollector);
        this.addTestOutputListener(testReportDataCollector);
        TestCountLogger testCountLogger = new TestCountLogger(this.getProgressLoggerFactory());
        this.addTestListener(testCountLogger);
        this.getTestListenerInternalBroadcaster().add(new TestListenerAdapter(this.testListenerBroadcaster.getSource(), this.getTestOutputListenerBroadcaster().getSource()));
        ProgressLogger parentProgressLogger = this.getProgressLoggerFactory().newOperation(Test.class);
        parentProgressLogger.setDescription("Test Execution");
        parentProgressLogger.started();
        TestWorkerProgressListener testWorkerProgressListener = new TestWorkerProgressListener(this.getProgressLoggerFactory(), parentProgressLogger);
        this.getTestListenerInternalBroadcaster().add(testWorkerProgressListener);
        StateTrackingTestResultProcessor resultProcessor = new StateTrackingTestResultProcessor(this.getTestListenerInternalBroadcaster().getSource());
        TestExecuter<? extends TestExecutionSpec> testExecuter = this.createTestExecuter();
        try {
            testExecuter.execute(this.createTestExecutionSpec(), resultProcessor);
        }
        finally {
            parentProgressLogger.completed();
            testWorkerProgressListener.completeAll();
            this.testListenerBroadcaster.removeAll();
            this.getTestOutputListenerBroadcaster().removeAll();
            this.getTestListenerInternalBroadcaster().removeAll();
            outputWriter.close();
        }
        new TestResultSerializer(binaryResultsDir).write(results.values());
        this.createReporting(results, testOutputStore);
        if (testCountLogger.hadFailures()) {
            this.handleTestFailures();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createReporting(Map<String, TestClassResult> results, TestOutputStore testOutputStore) {
        InMemoryTestResultsProvider testResultsProvider;
        block5: {
            testResultsProvider = new InMemoryTestResultsProvider(results.values(), testOutputStore);
            try {
                DirectoryReport html;
                JUnitXmlReport junitXml;
                if (this.testReporter == null) {
                    this.testReporter = new DefaultTestReport(this.getBuildOperationExecutor());
                }
                if ((junitXml = this.reports.getJunitXml()).isEnabled()) {
                    TestOutputAssociation outputAssociation = junitXml.isOutputPerTestCase() ? TestOutputAssociation.WITH_TESTCASE : TestOutputAssociation.WITH_SUITE;
                    Binary2JUnitXmlReportGenerator binary2JUnitXmlReportGenerator = new Binary2JUnitXmlReportGenerator(junitXml.getDestination(), testResultsProvider, outputAssociation, this.getBuildOperationExecutor(), this.getInetAddressFactory().getHostname());
                    binary2JUnitXmlReportGenerator.generate();
                }
                if (!(html = this.reports.getHtml()).isEnabled()) {
                    this.getLogger().info("Test report disabled, omitting generation of the HTML test report.");
                    break block5;
                }
                this.testReporter.generateReport(testResultsProvider, html.getDestination());
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable(testResultsProvider).stop();
                this.testReporter = null;
                throw throwable;
            }
        }
        CompositeStoppable.stoppable(testResultsProvider).stop();
        this.testReporter = null;
    }

    @Override
    @Nested
    public TestTaskReports getReports() {
        return this.reports;
    }

    @Override
    public TestTaskReports reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Override
    public TestTaskReports reports(Action<? super TestTaskReports> configureAction) {
        configureAction.execute(this.reports);
        return this.reports;
    }

    private void handleTestFailures() {
        String message = "There were failing tests";
        DirectoryReport htmlReport = this.getReports().getHtml();
        if (htmlReport.isEnabled()) {
            String reportUrl = new ConsoleRenderer().asClickableFileUrl(htmlReport.getEntryPoint());
            message = message.concat(". See the report at: " + reportUrl);
        } else {
            JUnitXmlReport junitXmlReport = this.getReports().getJunitXml();
            if (junitXmlReport.isEnabled()) {
                String resultsUrl = new ConsoleRenderer().asClickableFileUrl(junitXmlReport.getEntryPoint());
                message = message.concat(". See the results at: " + resultsUrl);
            }
        }
        if (!this.getIgnoreFailures()) {
            throw new GradleException(message);
        }
        this.getLogger().warn(message);
    }
}

