/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Ordering;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FixedSizeOldestCacheCleanup
implements Action<PersistentCache> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixedSizeOldestCacheCleanup.class);
    private static final Comparator<File> NEWEST_FIRST = Ordering.natural().onResultOf((Function)new Function<File, Comparable<Long>>(){

        public Comparable<Long> apply(File input) {
            return input.lastModified();
        }
    }).reverse();
    private final BuildOperationExecutor buildOperationExecutor;
    private final long targetSizeInMB;
    private final String partialFileSuffix;

    public FixedSizeOldestCacheCleanup(BuildOperationExecutor buildOperationExecutor, long targetSizeInMB, String partialFileSuffix) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.targetSizeInMB = targetSizeInMB;
        this.partialFileSuffix = partialFileSuffix;
    }

    @Override
    public void execute(final PersistentCache persistentCache) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext context) {
                FixedSizeOldestCacheCleanup.this.cleanup(persistentCache);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Clean up " + persistentCache);
            }
        });
    }

    private void cleanup(final PersistentCache persistentCache) {
        List<File> filesForDeletion;
        final File[] filesEligibleForCleanup = this.buildOperationExecutor.call(new CallableBuildOperation<File[]>(){

            @Override
            public File[] call(BuildOperationContext context) {
                return FixedSizeOldestCacheCleanup.this.findEligibleFiles(persistentCache.getBaseDir());
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Scan " + persistentCache.getBaseDir());
            }
        });
        if (filesEligibleForCleanup.length > 0 && !(filesForDeletion = this.buildOperationExecutor.call(new CallableBuildOperation<List<File>>(){

            @Override
            public List<File> call(BuildOperationContext context) {
                return FixedSizeOldestCacheCleanup.this.findFilesToDelete(persistentCache, filesEligibleForCleanup);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Choose files to delete from " + persistentCache);
            }
        })).isEmpty()) {
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                @Override
                public void run(BuildOperationContext context) {
                    FixedSizeOldestCacheCleanup.this.cleanupFiles(persistentCache, filesForDeletion);
                }

                @Override
                public BuildOperationDescriptor.Builder description() {
                    return BuildOperationDescriptor.displayName("Delete files for " + persistentCache);
                }
            });
        }
    }

    List<File> findFilesToDelete(PersistentCache persistentCache, File[] filesEligibleForCleanup) {
        Arrays.sort(filesEligibleForCleanup, NEWEST_FIRST);
        long totalSize = 0L;
        long targetSize = this.targetSizeInMB * 1024L * 1024L;
        ArrayList filesForDeletion = Lists.newArrayList();
        for (File file : filesEligibleForCleanup) {
            long size = file.length();
            if ((totalSize += size) <= targetSize) continue;
            filesForDeletion.add(file);
        }
        LOGGER.info("{} consuming {} (target: {} MB).", new Object[]{persistentCache, FileUtils.byteCountToDisplaySize((long)totalSize), this.targetSizeInMB});
        return filesForDeletion;
    }

    File[] findEligibleFiles(File cacheDir) {
        return cacheDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return FixedSizeOldestCacheCleanup.this.canBeDeleted(name);
            }
        });
    }

    void cleanupFiles(PersistentCache persistentCache, List<File> filesForDeletion) {
        long removedSize = this.deleteFiles(filesForDeletion);
        LOGGER.info("{} removing {} cache entries ({} reclaimed).", new Object[]{persistentCache, filesForDeletion.size(), FileUtils.byteCountToDisplaySize((long)removedSize)});
    }

    private long deleteFiles(List<File> files) {
        long removedSize = 0L;
        for (File file : files) {
            try {
                long size = file.length();
                if (!file.delete()) continue;
                removedSize += size;
            }
            catch (Exception e) {
                LOGGER.debug("Could not clean up cache " + file, (Throwable)e);
            }
        }
        return removedSize;
    }

    boolean canBeDeleted(String name) {
        return !name.endsWith(".properties") && !name.endsWith(".lock") && !name.endsWith(this.partialFileSuffix);
    }
}

