/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.initialization.ConfigurableIncludedBuild;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.component.DefaultBuildIdentifier;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.composite.internal.DefaultProjectPathRegistry;
import org.gradle.composite.internal.IncludedBuildDependencySubstitutionsBuilder;
import org.gradle.composite.internal.IncludedBuildFactory;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuildRegistry;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.component.local.model.DefaultProjectComponentIdentifier;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

public class DefaultIncludedBuildRegistry
implements IncludedBuildRegistry,
Stoppable {
    private final IncludedBuildFactory includedBuildFactory;
    private final DefaultProjectPathRegistry projectRegistry;
    private final IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder;
    private final Map<File, IncludedBuildInternal> includedBuilds = Maps.newLinkedHashMap();

    public DefaultIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, DefaultProjectPathRegistry projectRegistry, IncludedBuildDependencySubstitutionsBuilder dependencySubstitutionsBuilder, CompositeBuildContext compositeBuildContext) {
        this.includedBuildFactory = includedBuildFactory;
        this.projectRegistry = projectRegistry;
        this.dependencySubstitutionsBuilder = dependencySubstitutionsBuilder;
        compositeBuildContext.setIncludedBuildRegistry(this);
    }

    @Override
    public boolean hasIncludedBuilds() {
        return !this.includedBuilds.isEmpty();
    }

    @Override
    public Map<File, IncludedBuild> getIncludedBuilds() {
        return Collections.unmodifiableMap(this.includedBuilds);
    }

    @Override
    public IncludedBuildInternal addExplicitBuild(File buildDirectory, NestedBuildFactory nestedBuildFactory) {
        return this.registerBuild(buildDirectory, nestedBuildFactory);
    }

    @Override
    public IncludedBuild getBuild(final BuildIdentifier buildIdentifier) {
        return CollectionUtils.findFirst(this.includedBuilds.values(), new Spec<IncludedBuild>(){

            @Override
            public boolean isSatisfiedBy(IncludedBuild includedBuild) {
                return includedBuild.getName().equals(buildIdentifier.getName());
            }
        });
    }

    @Override
    public void validateExplicitIncludedBuilds(SettingsInternal settings) {
        this.validateIncludedBuilds(settings);
        this.registerRootBuildProjects(settings);
        Collection<IncludedBuild> includedBuilds = this.getIncludedBuilds().values();
        settings.getGradle().setIncludedBuilds(includedBuilds);
        this.registerProjects(includedBuilds);
        this.registerSubstitutions(includedBuilds);
    }

    private void validateIncludedBuilds(SettingsInternal settings) {
        HashSet names = Sets.newHashSet();
        for (IncludedBuild includedBuild : this.includedBuilds.values()) {
            String buildName = includedBuild.getName();
            if (!names.add(buildName)) {
                throw new GradleException("Included build '" + buildName + "' is not unique in composite.");
            }
            if (settings.getRootProject().getName().equals(buildName)) {
                throw new GradleException("Included build '" + buildName + "' collides with root project name.");
            }
            if (settings.findProject(":" + buildName) == null) continue;
            throw new GradleException("Included build '" + buildName + "' collides with subproject of the same name.");
        }
    }

    private void registerSubstitutions(Iterable<IncludedBuild> includedBuilds) {
        for (IncludedBuild includedBuild : includedBuilds) {
            this.dependencySubstitutionsBuilder.build((IncludedBuildInternal)includedBuild);
        }
    }

    @Override
    public ConfigurableIncludedBuild addImplicitBuild(File buildDirectory, NestedBuildFactory nestedBuildFactory) {
        ConfigurableIncludedBuild includedBuild = this.includedBuilds.get(buildDirectory);
        if (includedBuild == null) {
            includedBuild = this.registerBuild(buildDirectory, nestedBuildFactory);
            this.registerProjects(Collections.singletonList(includedBuild));
        }
        return includedBuild;
    }

    private IncludedBuildInternal registerBuild(File buildDirectory, NestedBuildFactory nestedBuildFactory) {
        IncludedBuildInternal includedBuild = this.includedBuilds.get(buildDirectory);
        if (includedBuild == null) {
            includedBuild = this.includedBuildFactory.createBuild(buildDirectory, nestedBuildFactory);
            this.includedBuilds.put(buildDirectory, includedBuild);
        }
        return includedBuild;
    }

    private void registerRootBuildProjects(SettingsInternal settings) {
        ProjectRegistry<DefaultProjectDescriptor> settingsProjectRegistry = settings.getProjectRegistry();
        String rootName = settingsProjectRegistry.getRootProject().getName();
        DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(rootName, true);
        this.registerProjects(Path.ROOT, buildIdentifier, settingsProjectRegistry.getAllProjects());
    }

    private void registerProjects(Iterable<IncludedBuild> includedBuilds) {
        for (IncludedBuild includedBuild : includedBuilds) {
            Path rootProjectPath = Path.ROOT.child(includedBuild.getName());
            DefaultBuildIdentifier buildIdentifier = new DefaultBuildIdentifier(includedBuild.getName());
            Set<DefaultProjectDescriptor> allProjects = ((IncludedBuildInternal)includedBuild).getLoadedSettings().getProjectRegistry().getAllProjects();
            this.registerProjects(rootProjectPath, buildIdentifier, allProjects);
        }
    }

    private void registerProjects(Path rootPath, BuildIdentifier buildIdentifier, Set<DefaultProjectDescriptor> allProjects) {
        for (DefaultProjectDescriptor project : allProjects) {
            Path projectIdentityPath = rootPath.append(project.path());
            ProjectComponentIdentifier projectComponentIdentifier = DefaultProjectComponentIdentifier.newProjectId(buildIdentifier, project.getPath());
            this.projectRegistry.add(projectIdentityPath, projectComponentIdentifier);
        }
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable(this.includedBuilds.values()).stop();
    }
}

