/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.StartParameter;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.initialization.EvaluateSettingsBuildOperationType;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;

public class NotifyingSettingsProcessor
implements SettingsProcessor {
    private final SettingsProcessor settingsProcessor;
    private final BuildOperationExecutor buildOperationExecutor;

    public NotifyingSettingsProcessor(SettingsProcessor settingsProcessor, BuildOperationExecutor buildOperationExecutor) {
        this.settingsProcessor = settingsProcessor;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public SettingsInternal process(final GradleInternal gradle, final SettingsLocation settingsLocation, final ClassLoaderScope buildRootClassLoaderScope, final StartParameter startParameter) {
        return this.buildOperationExecutor.call(new CallableBuildOperation<SettingsInternal>(){

            @Override
            public SettingsInternal call(BuildOperationContext context) {
                SettingsInternal settingsInternal = NotifyingSettingsProcessor.this.settingsProcessor.process(gradle, settingsLocation, buildRootClassLoaderScope, startParameter);
                context.setResult(new EvaluateSettingsBuildOperationType.Result(){});
                return settingsInternal;
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Evaluate settings").progressDisplayName("settings").details(new EvaluateSettingsBuildOperationType.Details(){

                    public String getSettingsDir() {
                        return settingsLocation.getSettingsDir().getAbsolutePath();
                    }

                    public String getSettingsFile() {
                        return settingsLocation.getSettingsScriptSource().getFileName();
                    }
                });
            }
        });
    }
}

