/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.serializer;

import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.events.ProgressStartEvent;
import org.gradle.internal.progress.BuildOperationCategory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressStartEventSerializer
implements Serializer<ProgressStartEvent> {
    private static final byte PARENT_PROGRESS_ID = 1;
    private static final byte SHORT_DESCRIPTION = 2;
    private static final byte LOGGING_HEADER = 4;
    private static final byte BUILD_OPERATION_ID = 8;
    private static final byte PARENT_BUILD_OPERATION_ID = 16;
    private static final byte BUILD_OPERATION_CATEGORY_TASK = 32;
    private static final byte BUILD_OPERATION_CATEGORY_PROJECT = 64;

    @Override
    public void write(Encoder encoder, ProgressStartEvent event) throws Exception {
        BuildOperationCategory buildOperationCategory;
        Object parentBuildOperationId;
        Object buildOperationId;
        String loggingHeader;
        String shortDescription;
        byte flags = 0;
        OperationIdentifier parentProgressOperationId = event.getParentProgressOperationId();
        if (parentProgressOperationId != null) {
            flags = (byte)(flags | 1);
        }
        if ((shortDescription = event.getShortDescription()) != null) {
            flags = (byte)(flags | 2);
        }
        if ((loggingHeader = event.getLoggingHeader()) != null) {
            flags = (byte)(flags | 4);
        }
        if ((buildOperationId = event.getBuildOperationId()) != null) {
            flags = (byte)(flags | 8);
        }
        if ((parentBuildOperationId = event.getParentBuildOperationId()) != null) {
            flags = (byte)(flags | 0x10);
        }
        if ((buildOperationCategory = event.getBuildOperationCategory()) == BuildOperationCategory.CONFIGURE_PROJECT) {
            flags = (byte)(flags | 0x40);
        } else if (buildOperationCategory == BuildOperationCategory.TASK) {
            flags = (byte)(flags | 0x20);
        } else if (buildOperationCategory != BuildOperationCategory.UNCATEGORIZED) {
            throw new IllegalArgumentException("Can't handle build operation category " + (Object)((Object)buildOperationCategory));
        }
        encoder.writeByte(flags);
        encoder.writeSmallLong(event.getProgressOperationId().getId());
        if (parentProgressOperationId != null) {
            encoder.writeSmallLong(parentProgressOperationId.getId());
        }
        encoder.writeLong(event.getTimestamp());
        encoder.writeString(event.getCategory());
        encoder.writeString(event.getDescription());
        if (shortDescription != null) {
            encoder.writeString(shortDescription);
        }
        if (loggingHeader != null) {
            encoder.writeString(loggingHeader);
        }
        encoder.writeString(event.getStatus());
        encoder.writeInt(event.getTotalProgress());
        if (buildOperationId != null) {
            encoder.writeSmallLong(((OperationIdentifier)buildOperationId).getId());
        }
        if (parentBuildOperationId != null) {
            encoder.writeSmallLong(((OperationIdentifier)parentBuildOperationId).getId());
        }
    }

    @Override
    public ProgressStartEvent read(Decoder decoder) throws Exception {
        byte flags = decoder.readByte();
        OperationIdentifier progressOperationId = new OperationIdentifier(decoder.readSmallLong());
        OperationIdentifier parentProgressOperationId = null;
        if ((flags & 1) != 0) {
            parentProgressOperationId = new OperationIdentifier(decoder.readSmallLong());
        }
        long timestamp = decoder.readLong();
        String category = decoder.readString();
        String description = decoder.readString();
        String shortDescription = null;
        if ((flags & 2) != 0) {
            shortDescription = decoder.readString();
        }
        String loggingHeader = null;
        if ((flags & 4) != 0) {
            loggingHeader = decoder.readString();
        }
        String status = decoder.readString();
        int totalProgress = decoder.readInt();
        OperationIdentifier buildOperationId = null;
        if ((flags & 8) != 0) {
            buildOperationId = new OperationIdentifier(decoder.readSmallLong());
        }
        OperationIdentifier parentBuildOperationId = null;
        if ((flags & 0x10) != 0) {
            parentBuildOperationId = new OperationIdentifier(decoder.readSmallLong());
        }
        BuildOperationCategory buildOperationCategory = (flags & 0x40) == 64 ? BuildOperationCategory.CONFIGURE_PROJECT : ((flags & 0x20) == 32 ? BuildOperationCategory.TASK : BuildOperationCategory.UNCATEGORIZED);
        return new ProgressStartEvent(progressOperationId, parentProgressOperationId, timestamp, category, description, shortDescription, loggingHeader, status, totalProgress, buildOperationId, parentBuildOperationId, buildOperationCategory);
    }
}

