/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import java.util.List;
import java.util.Map;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.operations.trace.BuildOperationRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildOperationTree {
    public final List<BuildOperationRecord> roots;
    public final Map<Object, BuildOperationRecord> records;

    BuildOperationTree(List<BuildOperationRecord> roots) {
        ImmutableMap.Builder records = ImmutableMap.builder();
        for (BuildOperationRecord record : roots) {
            this.visit((ImmutableMap.Builder<Object, BuildOperationRecord>)records, record);
        }
        this.roots = roots;
        this.records = records.build();
    }

    private void visit(ImmutableMap.Builder<Object, BuildOperationRecord> records, BuildOperationRecord record) {
        records.put(record.id, (Object)record);
        for (BuildOperationRecord child : record.children) {
            this.visit(records, child);
        }
    }

    static List<Map<String, ?>> serialize(List<BuildOperationRecord> roots) {
        return Lists.transform(roots, (Function)new Function<BuildOperationRecord, Map<String, ?>>(){

            public Map<String, ?> apply(BuildOperationRecord input) {
                return input.toSerializable();
            }
        });
    }
}

