/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal;

import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public abstract class Names {
    public static Names of(String name) {
        if (name.equals("main")) {
            return new Main();
        }
        if (name.endsWith("Executable")) {
            return new Other(name.substring(0, name.length() - 10));
        }
        return new Other(name);
    }

    public abstract String withPrefix(String var1);

    public abstract String withSuffix(String var1);

    public abstract String getTaskName(String var1);

    public abstract String getCompileTaskName(String var1);

    public abstract String getDependTaskName(String var1);

    public abstract String getDirName();

    private static class Other
    extends Names {
        private final String baseName;
        private final String capitalizedBaseName;
        private final String dirName;

        Other(String name) {
            int i;
            StringBuilder baseName = new StringBuilder();
            StringBuilder capBaseName = new StringBuilder();
            StringBuilder dirName = new StringBuilder();
            int startLast = 0;
            for (i = 0; i < name.length(); ++i) {
                if (!Character.isUpperCase(name.charAt(i))) continue;
                if (i > startLast) {
                    this.append(name, startLast, i, baseName, capBaseName, dirName);
                }
                startLast = i;
            }
            if (i > startLast) {
                this.append(name, startLast, i, baseName, capBaseName, dirName);
            }
            this.baseName = baseName.toString();
            this.capitalizedBaseName = capBaseName.toString();
            this.dirName = dirName.toString();
        }

        @Override
        public String withPrefix(String prefix) {
            return prefix + this.capitalizedBaseName;
        }

        @Override
        public String withSuffix(String suffix) {
            return this.baseName + StringUtils.capitalize((String)suffix);
        }

        @Override
        public String getTaskName(String action) {
            return action + this.capitalizedBaseName;
        }

        @Override
        public String getCompileTaskName(String language) {
            return "compile" + this.capitalizedBaseName + StringUtils.capitalize((String)language);
        }

        @Override
        public String getDependTaskName(String language) {
            return "depend" + this.capitalizedBaseName + StringUtils.capitalize((String)language);
        }

        @Override
        public String getDirName() {
            return this.dirName;
        }

        private void append(String name, int start, int end, StringBuilder baseName, StringBuilder capBaseName, StringBuilder dirName) {
            dirName.append(Character.toLowerCase(name.charAt(start)));
            dirName.append(name.substring(start + 1, end));
            dirName.append('/');
            if (start != 0 || end != 4 || !name.startsWith("main")) {
                if (baseName.length() == 0) {
                    baseName.append(Character.toLowerCase(name.charAt(start)));
                    baseName.append(name.substring(start + 1, end));
                } else {
                    baseName.append(name.substring(start, end));
                }
                capBaseName.append(Character.toUpperCase(name.charAt(start)));
                capBaseName.append(name.substring(start + 1, end));
            }
        }
    }

    private static class Main
    extends Names {
        private Main() {
        }

        @Override
        public String getCompileTaskName(String language) {
            return "compile" + StringUtils.capitalize((String)language);
        }

        @Override
        public String getDependTaskName(String language) {
            return "depend" + StringUtils.capitalize((String)language);
        }

        @Override
        public String getTaskName(String action) {
            return action;
        }

        @Override
        public String getDirName() {
            return "main/";
        }

        @Override
        public String withPrefix(String prefix) {
            return prefix;
        }

        @Override
        public String withSuffix(String suffix) {
            return suffix;
        }
    }
}

