/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.model.ModelMap;
import org.gradle.model.ModelSet;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.manage.schema.CollectionSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTypeInitializationException
extends GradleException {
    private static final String MANAGED_TYPE_DESCRIPTION = "A managed type (annotated with @Managed)";
    private static final String UNMANAGED_PROPERTY_DESCRIPTION = "An unmanaged property (i.e. annotated with @Unmanaged)";

    public ModelTypeInitializationException(NodeInitializerContext<?> context, ModelSchemaStore schemaStore, Iterable<? extends ModelType<?>> scalarTypes, Iterable<? extends ModelType<?>> constructibleTypes) {
        super(ModelTypeInitializationException.toMessage(context, schemaStore, scalarTypes, constructibleTypes));
    }

    private static <T> String toMessage(NodeInitializerContext<T> context, ModelSchemaStore schemaStore, Iterable<? extends ModelType<?>> scalarTypes, Iterable<? extends ModelType<?>> constructibleTypes) {
        Optional<NodeInitializerContext.PropertyContext> propertyContextOptional = context.getPropertyContextOptional();
        StringBuilder s = new StringBuilder();
        if (propertyContextOptional.isPresent()) {
            NodeInitializerContext.PropertyContext propertyContext = (NodeInitializerContext.PropertyContext)propertyContextOptional.get();
            s.append(String.format("A model element of type: '%s' can not be constructed.%n", propertyContext.getDeclaringType().getName()));
            String propertyName = propertyContext.getName();
            ModelType<?> propertyType = propertyContext.getType();
            if (ModelTypeInitializationException.isManagedCollection(propertyType)) {
                s.append(String.format("Its property '%s %s' is not a valid managed collection%n", propertyType.getName(), propertyName));
                CollectionSchema schema = (CollectionSchema)schemaStore.getSchema(propertyType);
                s.append(String.format("A managed collection can not contain '%s's%n", schema.getElementType()));
                ModelTypeInitializationException.appendManagedCollections(s, 1, constructibleTypes);
            } else if (ModelTypeInitializationException.isScalarCollection(propertyType, propertyContext.isDeclaredAsHavingUnmanagedType())) {
                ModelType<?> innerType = propertyType.getTypeVariables().get(0);
                s.append(String.format("Its property '%s %s' is not a valid scalar collection%n", propertyType.getName(), propertyName));
                s.append(String.format("A scalar collection can not contain '%s's%n", innerType));
                s.append(ModelTypeInitializationException.explainScalarCollections(scalarTypes));
            } else {
                s.append(String.format("Its property '%s %s' can not be constructed%n", propertyType.getName(), propertyName));
                s.append(String.format("It must be one of:%n", new Object[0]));
                s.append(String.format("    - %s%n", MANAGED_TYPE_DESCRIPTION));
                s.append("    - A managed collection. ");
                ModelTypeInitializationException.appendManagedCollections(s, 1, constructibleTypes);
                s.append(String.format("%n    - A scalar collection. %s%n    - %s", ModelTypeInitializationException.explainScalarCollections(scalarTypes), UNMANAGED_PROPERTY_DESCRIPTION));
                ModelTypeInitializationException.maybeAppendConstructibles(s, constructibleTypes, 1);
            }
        } else {
            s.append(String.format("A model element of type: '%s' can not be constructed.%n", context.getModelType().getName()));
            s.append(String.format("It must be one of:%n", new Object[0]));
            s.append(String.format("    - %s", MANAGED_TYPE_DESCRIPTION));
            ModelTypeInitializationException.maybeAppendConstructibles(s, constructibleTypes, 1);
        }
        return s.toString();
    }

    private static String explainScalarCollections(Iterable<? extends ModelType<?>> scalarTypes) {
        return String.format("A valid scalar collection takes the form of List<T> or Set<T> where 'T' is one of (%s)", ModelTypeInitializationException.describe(scalarTypes));
    }

    private static String appendManagedCollections(StringBuilder s, int pad, Iterable<? extends ModelType<?>> constructibleTypes) {
        s.append(String.format("A valid managed collection takes the form of ModelSet<T> or ModelMap<T> where 'T' is:%n        - %s", MANAGED_TYPE_DESCRIPTION));
        ModelTypeInitializationException.maybeAppendConstructibles(s, constructibleTypes, pad + 1);
        return s.toString();
    }

    private static void maybeAppendConstructibles(StringBuilder s, Iterable<? extends ModelType<?>> constructibleTypes, int pad) {
        if (!Iterables.isEmpty(constructibleTypes)) {
            String padding = ModelTypeInitializationException.pad(pad);
            s.append(String.format("%n%s- or a type which Gradle is capable of constructing:", padding));
            for (ModelType<?> modelType : constructibleTypes) {
                s.append(String.format("%n    %s- %s", padding, modelType.getName()));
            }
        }
    }

    private static String pad(int padding) {
        return Strings.padStart((String)"", (int)(padding * 4), (char)' ');
    }

    private static boolean isScalarCollection(ModelType<?> propertyType, boolean declaredAsHavingUnmanagedType) {
        Class<?> concreteClass = propertyType.getConcreteClass();
        return (concreteClass.equals(List.class) || concreteClass.equals(Set.class)) && !declaredAsHavingUnmanagedType;
    }

    private static String describe(Iterable<? extends ModelType<?>> types) {
        return Joiner.on((String)", ").join((Iterable)ImmutableSet.copyOf((Iterable)Iterables.transform(types, (Function)new Function<ModelType<?>, String>(){

            public String apply(ModelType<?> input) {
                return input.getDisplayName();
            }
        })));
    }

    private static boolean isManagedCollection(ModelType<?> type) {
        Class<?> concreteClass = type.getConcreteClass();
        return concreteClass.equals(ModelMap.class) || concreteClass.equals(ModelSet.class);
    }
}

