/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.artifacts.dependencies.DefaultSelfResolvingDependency;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.plugins.SwiftExecutablePlugin;
import org.gradle.language.swift.plugins.SwiftLibraryPlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.MacOSSdkPlatformPathLocator;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XcTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.testing.base.plugins.TestingBasePlugin;
import org.gradle.util.GUtil;

@Incubating
public class XCTestConventionPlugin
implements Plugin<ProjectInternal> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
    }

    @Override
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(TestingBasePlugin.class);
        project.getPluginManager().apply(SwiftBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        SwiftXCTestSuite testSuite = XCTestConventionPlugin.createTestSuite(project);
        Task testingTask = XCTestConventionPlugin.createTestingTask(project, testSuite);
        this.configureTestSuiteBuildingTasks(project, testSuite);
        this.configureTestSuiteWithTestedComponentWhenAvailable(project);
        Task test = tasks.create(testSuite.getName());
        test.dependsOn(testingTask);
        if (OperatingSystem.current().isMacOsX() || OperatingSystem.current().isLinux()) {
            Object check = tasks.getByName("check");
            check.dependsOn(test);
        }
    }

    private void configureTestSuiteBuildingTasks(ProjectInternal project, SwiftXCTestSuite testSuite) {
        DefaultTask install;
        AbstractLinkTask link;
        TaskContainerInternal tasks = project.getTasks();
        final SwiftXCTestBinary binary = testSuite.getTestExecutable();
        final Names names = Names.of(binary.getName());
        SwiftCompile compile = (SwiftCompile)tasks.getByName(names.getCompileTaskName("swift"));
        DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
        ModelRegistry modelRegistry = project.getModelRegistry();
        NativeToolChain toolChain = (NativeToolChain)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class).getForPlatform(currentPlatform);
        if (OperatingSystem.current().isMacOsX()) {
            compile.getCompilerArgs().addAll(project.provider(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Arrays.asList("-parse-as-library", "-g", "-F" + frameworkDir.getAbsolutePath());
                }
            }));
            link = tasks.create(names.getTaskName("link"), LinkMachOBundle.class);
            link.getLinkerArgs().set(project.provider(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    File frameworkDir = new File(XCTestConventionPlugin.this.sdkPlatformPathLocator.find(), "Developer/Library/Frameworks");
                    return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
                }
            }));
            install = tasks.create(names.getTaskName("install"), InstallXCTestBundle.class);
            ((InstallXCTestBundle)install).getBundleBinaryFile().set(binary.getExecutableTestFile());
            ((InstallXCTestBundle)install).getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            ((DefaultSwiftXCTestBinary)binary).getInstallDirectory().set(((InstallXCTestBundle)install).getInstallDirectory());
            ((DefaultSwiftXCTestBinary)binary).getRunScriptFile().set(((InstallXCTestBundle)install).getRunScriptFile());
        } else {
            link = tasks.create(names.getTaskName("link"), LinkExecutable.class);
            install = tasks.create(names.getTaskName("install"), InstallExecutable.class);
            ((InstallExecutable)install).setPlatform(currentPlatform);
            ((InstallExecutable)install).setToolChain(toolChain);
            ((InstallExecutable)install).getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
            ((InstallExecutable)install).getSourceFile().set(binary.getExecutableTestFile());
            ((InstallExecutable)install).lib(binary.getRuntimeLibraries());
            ((DefaultSwiftXCTestBinary)binary).getInstallDirectory().set(((InstallExecutable)install).getInstallDirectory());
            ((DefaultSwiftXCTestBinary)binary).getRunScriptFile().set(((InstallExecutable)install).getRunScriptFile());
        }
        link.source(binary.getObjects());
        link.lib(binary.getLinkLibraries());
        final PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select(currentPlatform);
        Provider<RegularFile> exeLocation = project.getLayout().getBuildDirectory().file(project.getProviders().provider(new Callable<String>(){

            @Override
            public String call() {
                return toolProvider.getExecutableName("exe/" + names.getDirName() + binary.getModule().get());
            }
        }));
        link.setOutputFile(exeLocation);
        link.setTargetPlatform(currentPlatform);
        link.setToolChain(toolChain);
        link.setDebuggable(binary.isDebuggable());
        ((DefaultSwiftXCTestBinary)binary).getExecutableTestFile().set(link.getBinaryFile());
    }

    private static Task createTestingTask(Project project, SwiftXCTestSuite testSuite) {
        TaskContainer tasks = project.getTasks();
        XcTest testTask = tasks.create("xcTest", XcTest.class);
        SwiftXCTestBinary binary = testSuite.getDevelopmentBinary();
        testTask.getTestInstallDirectory().set(binary.getInstallDirectory());
        testTask.getRunScriptFile().set(binary.getRunScriptFile());
        testTask.getWorkingDirectory().set(binary.getInstallDirectory());
        testTask.setGroup("verification");
        testTask.setDescription("Executes XCTest suites");
        return testTask;
    }

    private static SwiftXCTestSuite createTestSuite(Project project) {
        SwiftXCTestSuite testSuite = project.getObjects().newInstance(DefaultSwiftXCTestSuite.class, "test", project.getConfigurations());
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", testSuite);
        project.getComponents().add(testSuite);
        project.getComponents().add(testSuite.getDevelopmentBinary());
        testSuite.getModule().set(GUtil.toCamelCase(project.getName() + "Test"));
        return testSuite;
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project) {
        project.getPlugins().withType(SwiftExecutablePlugin.class, XCTestConventionPlugin.configureTestSuiteWithTestedComponent(project));
        project.getPlugins().withType(SwiftLibraryPlugin.class, XCTestConventionPlugin.configureTestSuiteWithTestedComponent(project));
    }

    private static <T> Action<? super T> configureTestSuiteWithTestedComponent(final Project project) {
        return new Action<T>(){

            @Override
            public void execute(T plugin) {
                TaskContainer tasks = project.getTasks();
                SwiftComponent testedComponent = (SwiftComponent)project.getComponents().withType(SwiftComponent.class).getByName("main");
                SwiftXCTestSuite testSuite = project.getExtensions().getByType(SwiftXCTestSuite.class);
                ((DefaultSwiftXCTestSuite)testSuite).getTestedComponent().set(testedComponent);
                SwiftCompile compileMain = tasks.withType(SwiftCompile.class).getByName("compileDebugSwift");
                SwiftCompile compileTest = tasks.withType(SwiftCompile.class).getByName("compileTestSwift");
                compileTest.getModules().from(compileMain.getModuleFile());
                testSuite.getImplementationDependencies().extendsFrom(testedComponent.getImplementationDependencies());
                ((Configuration)testSuite.getDevelopmentBinary().getCompileModules()).getDependencies().add(new DefaultSelfResolvingDependency((FileCollectionInternal)((Object)project.files(((DefaultSwiftBinary)testedComponent.getDevelopmentBinary()).getModuleFile().map(new Transformer<File, RegularFile>(){

                    @Override
                    public File transform(RegularFile regularFile) {
                        return regularFile.getAsFile().getParentFile();
                    }
                })))));
                AbstractLinkTask linkTest = tasks.withType(AbstractLinkTask.class).getByName("linkTest");
                if (testedComponent instanceof SwiftApplication) {
                    final UnexportMainSymbol relocate = tasks.create("relocateMainForTest", UnexportMainSymbol.class);
                    relocate.source(testedComponent.getDevelopmentBinary().getObjects());
                    linkTest.source(relocate);
                    linkTest.source(testedComponent.getDevelopmentBinary().getObjects().filter((Spec<? super File>)new Spec<File>(){

                        @Override
                        public boolean isSatisfiedBy(File objectFile) {
                            return !objectFile.equals(relocate.getMainObject());
                        }
                    }));
                } else {
                    linkTest.source(testedComponent.getDevelopmentBinary().getObjects());
                }
            }
        };
    }
}

