/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp.version;

import java.io.File;
import org.gradle.internal.FileUtils;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.DefaultVisualStudioMetadata;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetadata;
import org.gradle.util.VersionNumber;

public class VisualStudioMetadataBuilder {
    private File installDir;
    private File visualCppDir;
    private VersionNumber version = VersionNumber.UNKNOWN;
    private VersionNumber visualCppVersion = VersionNumber.UNKNOWN;
    private VisualStudioMetadata.Compatibility compatibility;

    public VisualStudioMetadataBuilder installDir(File installDir) {
        this.installDir = FileUtils.canonicalize(installDir);
        return this;
    }

    public VisualStudioMetadataBuilder visualCppDir(File visualCppDir) {
        this.visualCppDir = FileUtils.canonicalize(visualCppDir);
        return this;
    }

    public VisualStudioMetadataBuilder version(VersionNumber version) {
        this.version = version;
        return this;
    }

    public VisualStudioMetadataBuilder visualCppVersion(VersionNumber version) {
        this.visualCppVersion = version;
        return this;
    }

    public VisualStudioMetadataBuilder compatibility(VisualStudioMetadata.Compatibility compatibility) {
        this.compatibility = compatibility;
        return this;
    }

    public VisualStudioMetadata build() {
        return new DefaultVisualStudioMetadata(this.installDir, this.visualCppDir, this.version, this.visualCppVersion, this.compatibility);
    }
}

