/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.plugins.PluginDescriptor;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.model.Model;
import org.gradle.model.RuleSource;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.gradle.plugin.devel.plugins.IvyPluginPublishingRules;
import org.gradle.plugin.devel.plugins.MavenPluginPublishingRules;
import org.gradle.plugin.devel.tasks.GeneratePluginDescriptors;
import org.gradle.plugin.devel.tasks.PluginUnderTestMetadata;
import org.gradle.plugin.devel.tasks.ValidateTaskProperties;

@Incubating
public class JavaGradlePluginPlugin
implements Plugin<Project> {
    private static final Logger LOGGER = Logging.getLogger(JavaGradlePluginPlugin.class);
    static final String COMPILE_CONFIGURATION = "compile";
    static final String JAR_TASK = "jar";
    static final String PROCESS_RESOURCES_TASK = "processResources";
    static final String GRADLE_PLUGINS = "gradle-plugins";
    static final String PLUGIN_DESCRIPTOR_PATTERN = "META-INF/gradle-plugins/*.properties";
    static final String CLASSES_PATTERN = "**/*.class";
    static final String BAD_IMPL_CLASS_WARNING_MESSAGE = "%s: A valid plugin descriptor was found for %s but the implementation class %s was not found in the jar.";
    static final String INVALID_DESCRIPTOR_WARNING_MESSAGE = "%s: A plugin descriptor was found for %s but it was invalid.";
    static final String NO_DESCRIPTOR_WARNING_MESSAGE = "%s: No valid plugin descriptors were found in META-INF/gradle-plugins";
    static final String DECLARED_PLUGIN_MISSING_MESSAGE = "%s: Could not find plugin descriptor of %s at META-INF/gradle-plugins/%s.properties";
    static final String DECLARATION_MISSING_ID_MESSAGE = "Missing id for %s";
    static final String DECLARATION_MISSING_IMPLEMENTATION_MESSAGE = "Missing implementationClass for %s";
    static final String EXTENSION_NAME = "gradlePlugin";
    static final String PLUGIN_UNDER_TEST_METADATA_TASK_NAME = "pluginUnderTestMetadata";
    static final String GENERATE_PLUGIN_DESCRIPTORS_TASK_NAME = "pluginDescriptors";
    static final String VALIDATE_TASK_PROPERTIES_TASK_NAME = "validateTaskProperties";
    static final String PLUGIN_DEVELOPMENT_GROUP = "Plugin development";
    static final String PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION = "Generates the metadata for plugin functional tests.";
    static final String GENERATE_PLUGIN_DESCRIPTORS_TASK_DESCRIPTION = "Generates plugin descriptors from plugin declarations.";
    static final String VALIDATE_TASK_PROPERTIES_TASK_DESCRIPTION = "Validates task property annotations for the plugin.";

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaPlugin.class);
        this.applyDependencies(project);
        GradlePluginDevelopmentExtension extension = this.createExtension(project);
        this.configureJarTask(project, extension);
        this.configureTestKit(project, extension);
        this.configurePublishing(project);
        this.configureDescriptorGeneration(project, extension);
        this.validatePluginDeclarations(project, extension);
        this.configureTaskPropertiesValidation(project);
    }

    private void applyDependencies(Project project) {
        DependencyHandler dependencies = project.getDependencies();
        dependencies.add(COMPILE_CONFIGURATION, dependencies.gradleApi());
    }

    private void configureJarTask(Project project, GradlePluginDevelopmentExtension extension) {
        Jar jarTask = (Jar)project.getTasks().findByName(JAR_TASK);
        ArrayList<PluginDescriptor> descriptors = new ArrayList<PluginDescriptor>();
        HashSet<String> classList = new HashSet<String>();
        PluginDescriptorCollectorAction pluginDescriptorCollector = new PluginDescriptorCollectorAction(descriptors);
        ClassManifestCollectorAction classManifestCollector = new ClassManifestCollectorAction(classList);
        PluginValidationAction pluginValidationAction = new PluginValidationAction(extension.getPlugins(), descriptors, classList);
        jarTask.filesMatching(PLUGIN_DESCRIPTOR_PATTERN, (Action)pluginDescriptorCollector);
        jarTask.filesMatching(CLASSES_PATTERN, (Action)classManifestCollector);
        jarTask.appendParallelSafeAction(pluginValidationAction);
    }

    private GradlePluginDevelopmentExtension createExtension(Project project) {
        JavaPluginConvention javaConvention = project.getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet defaultPluginSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
        SourceSet defaultTestSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
        return project.getExtensions().create(EXTENSION_NAME, GradlePluginDevelopmentExtension.class, project, defaultPluginSourceSet, defaultTestSourceSet);
    }

    private void configureTestKit(Project project, GradlePluginDevelopmentExtension extension) {
        PluginUnderTestMetadata pluginUnderTestMetadataTask = this.createAndConfigurePluginUnderTestMetadataTask(project, extension);
        this.establishTestKitAndPluginClasspathDependencies(project, extension, pluginUnderTestMetadataTask);
    }

    private PluginUnderTestMetadata createAndConfigurePluginUnderTestMetadataTask(final Project project, final GradlePluginDevelopmentExtension extension) {
        final PluginUnderTestMetadata pluginUnderTestMetadataTask = project.getTasks().create(PLUGIN_UNDER_TEST_METADATA_TASK_NAME, PluginUnderTestMetadata.class);
        pluginUnderTestMetadataTask.setGroup(PLUGIN_DEVELOPMENT_GROUP);
        pluginUnderTestMetadataTask.setDescription(PLUGIN_UNDER_TEST_METADATA_TASK_DESCRIPTION);
        final Configuration gradlePluginConfiguration = project.getConfigurations().detachedConfiguration(project.getDependencies().gradleApi());
        ConventionMapping conventionMapping = new DslObject(pluginUnderTestMetadataTask).getConventionMapping();
        conventionMapping.map("pluginClasspath", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                FileCollection gradleApi = gradlePluginConfiguration.getIncoming().getFiles();
                return extension.getPluginSourceSet().getRuntimeClasspath().minus(gradleApi);
            }
        });
        conventionMapping.map("outputDirectory", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return new File(project.getBuildDir(), pluginUnderTestMetadataTask.getName());
            }
        });
        return pluginUnderTestMetadataTask;
    }

    private void establishTestKitAndPluginClasspathDependencies(Project project, GradlePluginDevelopmentExtension extension, PluginUnderTestMetadata pluginClasspathTask) {
        project.afterEvaluate(new TestKitAndPluginClasspathDependenciesAction(extension, pluginClasspathTask));
    }

    private void configurePublishing(final Project project) {
        project.getPluginManager().withPlugin("maven-publish", (Action<? super AppliedPlugin>)new Action<AppliedPlugin>(){

            @Override
            public void execute(AppliedPlugin appliedPlugin) {
                project.getPluginManager().apply(MavenPluginPublishingRules.class);
            }
        });
        project.getPluginManager().withPlugin("ivy-publish", (Action<? super AppliedPlugin>)new Action<AppliedPlugin>(){

            @Override
            public void execute(AppliedPlugin appliedPlugin) {
                project.getPluginManager().apply(IvyPluginPublishingRules.class);
            }
        });
    }

    private void configureDescriptorGeneration(final Project project, final GradlePluginDevelopmentExtension extension) {
        final GeneratePluginDescriptors generatePluginDescriptors = project.getTasks().create(GENERATE_PLUGIN_DESCRIPTORS_TASK_NAME, GeneratePluginDescriptors.class);
        generatePluginDescriptors.setGroup(PLUGIN_DEVELOPMENT_GROUP);
        generatePluginDescriptors.setDescription(GENERATE_PLUGIN_DESCRIPTORS_TASK_DESCRIPTION);
        generatePluginDescriptors.conventionMapping("declarations", new Callable<List<PluginDeclaration>>(){

            @Override
            public List<PluginDeclaration> call() throws Exception {
                return Lists.newArrayList(extension.getPlugins());
            }
        });
        generatePluginDescriptors.conventionMapping("outputDirectory", new Callable<File>(){

            @Override
            public File call() throws Exception {
                return new File(project.getBuildDir(), generatePluginDescriptors.getName());
            }
        });
        Copy processResources = (Copy)project.getTasks().getByName(PROCESS_RESOURCES_TASK);
        CopySpecInternal copyPluginDescriptors = processResources.getRootSpec().addChild();
        copyPluginDescriptors.into("META-INF/gradle-plugins");
        copyPluginDescriptors.from(new Callable<File>(){

            @Override
            public File call() throws Exception {
                return generatePluginDescriptors.getOutputDirectory();
            }
        });
        processResources.dependsOn(generatePluginDescriptors);
    }

    private void validatePluginDeclarations(Project project, final GradlePluginDevelopmentExtension extension) {
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(Project project) {
                for (PluginDeclaration declaration : extension.getPlugins()) {
                    if (declaration.getId() == null) {
                        throw new IllegalArgumentException(String.format(JavaGradlePluginPlugin.DECLARATION_MISSING_ID_MESSAGE, declaration.getName()));
                    }
                    if (declaration.getImplementationClass() != null) continue;
                    throw new IllegalArgumentException(String.format(JavaGradlePluginPlugin.DECLARATION_MISSING_IMPLEMENTATION_MESSAGE, declaration.getName()));
                }
            }
        });
    }

    private void configureTaskPropertiesValidation(Project project) {
        ValidateTaskProperties validator = project.getTasks().create(VALIDATE_TASK_PROPERTIES_TASK_NAME, ValidateTaskProperties.class);
        validator.setGroup(PLUGIN_DEVELOPMENT_GROUP);
        validator.setDescription(VALIDATE_TASK_PROPERTIES_TASK_DESCRIPTION);
        File reportsDir = new File(project.getBuildDir(), "reports");
        File validatorReportsDir = new File(reportsDir, "task-properties");
        validator.setOutputFile(new File(validatorReportsDir, "report.txt"));
        SourceSet mainSourceSet = (SourceSet)project.getConvention().getPlugin(JavaPluginConvention.class).getSourceSets().getByName("main");
        validator.setClasses(mainSourceSet.getOutput().getClassesDirs());
        validator.setClasspath(mainSourceSet.getCompileClasspath());
        validator.dependsOn(mainSourceSet.getOutput());
        project.getTasks().getByName("check").dependsOn(validator);
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        public GradlePluginDevelopmentExtension gradlePluginDevelopmentExtension(ExtensionContainer extensionContainer) {
            return extensionContainer.getByType(GradlePluginDevelopmentExtension.class);
        }
    }

    static class TestKitAndPluginClasspathDependenciesAction
    implements Action<Project> {
        private final GradlePluginDevelopmentExtension extension;
        private final PluginUnderTestMetadata pluginClasspathTask;

        private TestKitAndPluginClasspathDependenciesAction(GradlePluginDevelopmentExtension extension, PluginUnderTestMetadata pluginClasspathTask) {
            this.extension = extension;
            this.pluginClasspathTask = pluginClasspathTask;
        }

        @Override
        public void execute(Project project) {
            DependencyHandler dependencies = project.getDependencies();
            Set<SourceSet> testSourceSets = this.extension.getTestSourceSets();
            for (SourceSet testSourceSet : testSourceSets) {
                String compileConfigurationName = testSourceSet.getCompileConfigurationName();
                dependencies.add(compileConfigurationName, dependencies.gradleTestKit());
                String runtimeConfigurationName = testSourceSet.getRuntimeConfigurationName();
                dependencies.add(runtimeConfigurationName, project.files(this.pluginClasspathTask));
            }
        }
    }

    static class ClassManifestCollectorAction
    implements Action<FileCopyDetails> {
        Set<String> classList;

        ClassManifestCollectorAction(Set<String> classList) {
            this.classList = classList;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            this.classList.add(fileCopyDetails.getRelativePath().toString());
        }
    }

    static class PluginDescriptorCollectorAction
    implements Action<FileCopyDetails> {
        List<PluginDescriptor> descriptors;

        PluginDescriptorCollectorAction(List<PluginDescriptor> descriptors) {
            this.descriptors = descriptors;
        }

        @Override
        public void execute(FileCopyDetails fileCopyDetails) {
            PluginDescriptor descriptor;
            try {
                descriptor = new PluginDescriptor(fileCopyDetails.getFile().toURI().toURL());
            }
            catch (MalformedURLException e) {
                return;
            }
            if (descriptor.getImplementationClassName() != null) {
                this.descriptors.add(descriptor);
            }
        }
    }

    static class PluginValidationAction
    implements Action<Task> {
        private final Collection<PluginDeclaration> plugins;
        private final Collection<PluginDescriptor> descriptors;
        private final Set<String> classes;

        PluginValidationAction(Collection<PluginDeclaration> plugins, Collection<PluginDescriptor> descriptors, Set<String> classes) {
            this.plugins = plugins;
            this.descriptors = descriptors;
            this.classes = classes;
        }

        @Override
        public void execute(Task task) {
            if (this.descriptors == null || this.descriptors.isEmpty()) {
                LOGGER.warn(String.format(JavaGradlePluginPlugin.NO_DESCRIPTOR_WARNING_MESSAGE, task.getPath()));
            } else {
                HashSet pluginFileNames = Sets.newHashSet();
                for (PluginDescriptor descriptor : this.descriptors) {
                    URI descriptorURI = null;
                    try {
                        descriptorURI = descriptor.getPropertiesFileUrl().toURI();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    String pluginFileName = descriptorURI != null ? new File(descriptorURI).getName() : "UNKNOWN";
                    pluginFileNames.add(pluginFileName);
                    String pluginImplementation = descriptor.getImplementationClassName();
                    if (pluginImplementation.length() == 0) {
                        LOGGER.warn(String.format(JavaGradlePluginPlugin.INVALID_DESCRIPTOR_WARNING_MESSAGE, task.getPath(), pluginFileName));
                        continue;
                    }
                    if (this.hasFullyQualifiedClass(pluginImplementation)) continue;
                    LOGGER.warn(String.format(JavaGradlePluginPlugin.BAD_IMPL_CLASS_WARNING_MESSAGE, task.getPath(), pluginFileName, pluginImplementation));
                }
                for (PluginDeclaration declaration : this.plugins) {
                    if (pluginFileNames.contains(declaration.getId() + ".properties")) continue;
                    LOGGER.warn(String.format(JavaGradlePluginPlugin.DECLARED_PLUGIN_MISSING_MESSAGE, task.getPath(), declaration.getName(), declaration.getId()));
                }
            }
        }

        boolean hasFullyQualifiedClass(String fqClass) {
            return this.classes.contains(fqClass.replaceAll("\\.", "/") + ".class");
        }
    }
}

