/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.resolver.model;

import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeLocalFileDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeProjectDependency;
import org.gradle.plugins.ide.internal.resolver.model.IdeRepoFileDependency;

public abstract class IdeDependencyKey<T extends IdeDependency, R> {
    protected final T ideDependency;
    private final DependencyBuilder<T, ? extends R> dependencyBuilder;

    public static IdeDependencyKey<IdeExtendedRepoFileDependency, Dependency> forRepoFileDependency(IdeExtendedRepoFileDependency dependency, DependencyBuilder<IdeExtendedRepoFileDependency, Dependency> dependencyBuilder) {
        return new RepoFileDependencyKey<Dependency>(dependency, dependencyBuilder);
    }

    public static <D> IdeDependencyKey<IdeProjectDependency, D> forProjectDependency(IdeProjectDependency dependency, DependencyBuilder<IdeProjectDependency, D> dependencyBuilder) {
        return new ProjectDependencyKey(dependency, dependencyBuilder);
    }

    public static <D> IdeDependencyKey<IdeLocalFileDependency, D> forLocalFileDependency(IdeLocalFileDependency dependency, DependencyBuilder<IdeLocalFileDependency, D> dependencyBuilder) {
        return new LocalFileDependencyKey(dependency, dependencyBuilder);
    }

    protected IdeDependencyKey(T ideDependency, DependencyBuilder<T, R> dependencyBuilder) {
        this.ideDependency = (IdeDependency)Preconditions.checkNotNull(ideDependency);
        this.dependencyBuilder = (DependencyBuilder)Preconditions.checkNotNull(dependencyBuilder);
    }

    public R buildDependency(String scope) {
        return this.dependencyBuilder.buildDependency(this.ideDependency, scope);
    }

    protected abstract boolean isSameDependency(IdeDependency var1);

    protected abstract int dependencyHashCode();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdeDependencyKey)) {
            return false;
        }
        IdeDependencyKey that = (IdeDependencyKey)o;
        return this.isSameDependency((IdeDependency)that.ideDependency);
    }

    public int hashCode() {
        return this.dependencyHashCode();
    }

    private static class RepoFileDependencyKey<R>
    extends IdeDependencyKey<IdeExtendedRepoFileDependency, R> {
        private RepoFileDependencyKey(IdeExtendedRepoFileDependency dependency, DependencyBuilder<IdeExtendedRepoFileDependency, R> dependencyBuilder) {
            super(dependency, dependencyBuilder);
        }

        @Override
        protected int dependencyHashCode() {
            int hash = ((IdeExtendedRepoFileDependency)this.ideDependency).getFile().hashCode();
            hash = 31 * hash + (((IdeExtendedRepoFileDependency)this.ideDependency).getId() != null ? ((IdeExtendedRepoFileDependency)this.ideDependency).getId().hashCode() : 1);
            return hash;
        }

        @Override
        protected boolean isSameDependency(IdeDependency otherDependency) {
            if (!(otherDependency instanceof IdeRepoFileDependency)) {
                return false;
            }
            IdeRepoFileDependency that = (IdeRepoFileDependency)otherDependency;
            return Objects.equal((Object)((IdeExtendedRepoFileDependency)this.ideDependency).getFile(), (Object)that.getFile()) && Objects.equal((Object)((IdeExtendedRepoFileDependency)this.ideDependency).getId(), (Object)that.getId());
        }

        public String toString() {
            return "RepoFileDependencyKey{" + ((IdeExtendedRepoFileDependency)this.ideDependency).getId() + "}";
        }
    }

    private static class ProjectDependencyKey<R>
    extends IdeDependencyKey<IdeProjectDependency, R> {
        private ProjectDependencyKey(IdeProjectDependency dependency, DependencyBuilder<IdeProjectDependency, R> dependencyBuilder) {
            super(dependency, dependencyBuilder);
        }

        @Override
        protected int dependencyHashCode() {
            return ((IdeProjectDependency)this.ideDependency).getProjectId().hashCode();
        }

        @Override
        protected boolean isSameDependency(IdeDependency otherDependency) {
            return otherDependency instanceof IdeProjectDependency && Objects.equal((Object)((IdeProjectDependency)this.ideDependency).getProjectId(), (Object)((IdeProjectDependency)otherDependency).getProjectId());
        }

        public String toString() {
            return "ProjectDependencyKey{" + ((IdeProjectDependency)this.ideDependency).getProjectId() + "}";
        }
    }

    private static class LocalFileDependencyKey<R>
    extends IdeDependencyKey<IdeLocalFileDependency, R> {
        private LocalFileDependencyKey(IdeLocalFileDependency dependency, DependencyBuilder<IdeLocalFileDependency, R> dependencyBuilder) {
            super(dependency, dependencyBuilder);
        }

        @Override
        protected int dependencyHashCode() {
            return ((IdeLocalFileDependency)this.ideDependency).getFile().hashCode();
        }

        @Override
        protected boolean isSameDependency(IdeDependency otherDependency) {
            return otherDependency instanceof IdeLocalFileDependency && Objects.equal((Object)((IdeLocalFileDependency)this.ideDependency).getFile(), (Object)((IdeLocalFileDependency)otherDependency).getFile());
        }

        public String toString() {
            return "LocalFileDependencyKey{" + ((IdeLocalFileDependency)this.ideDependency).getFile() + "}";
        }
    }

    public static interface DependencyBuilder<T extends IdeDependency, R> {
        public R buildDependency(T var1, String var2);
    }
}

