/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.git.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.gradle.internal.UncheckedException;
import org.gradle.vcs.git.GitVersionControlSpec;

public class DefaultGitVersionControlSpec
implements GitVersionControlSpec {
    private URI url;

    @Override
    public URI getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(URI url) {
        this.url = url;
    }

    @Override
    public void setUrl(String url) {
        try {
            this.setUrl(new URI(url));
        }
        catch (URISyntaxException e) {
            throw new UncheckedException(e);
        }
    }

    @Override
    public String getDisplayName() {
        return "Git Repository at " + this.getUrl();
    }

    @Override
    public String getUniqueId() {
        return "git-repo:" + this.getUrl().toASCIIString();
    }

    @Override
    public String getRepoName() {
        String[] pathParts = this.url.getPath().split("/");
        String repoPart = pathParts[pathParts.length - 1];
        if (repoPart.endsWith(".git")) {
            repoPart = repoPart.substring(0, repoPart.indexOf(".git"));
        }
        return repoPart;
    }
}

