/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.util.Map;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.main.extern.IIdentifierRenamer;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.modules.renamer.ConverterHelper;
import org.jetbrains.java.decompiler.modules.renamer.IdentifierConverter;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.IDecompiledData;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructContext;
import org.jetbrains.java.decompiler.struct.lazy.LazyLoader;
import org.jetbrains.java.decompiler.util.TextBuffer;

public class Fernflower
implements IDecompiledData {
    private final StructContext structContext;
    private final ClassesProcessor classProcessor;
    private IIdentifierRenamer helper;
    private IdentifierConverter converter;

    public Fernflower(IBytecodeProvider provider, IResultSaver saver, Map<String, Object> options, IFernflowerLogger logger) {
        this.structContext = new StructContext(saver, this, new LazyLoader(provider));
        this.classProcessor = new ClassesProcessor(this.structContext);
        PoolInterceptor interceptor = null;
        Object rename = options.get("ren");
        if ("1".equals(rename) || rename == null && "1".equals(IFernflowerPreferences.DEFAULTS.get("ren"))) {
            this.helper = Fernflower.loadHelper((String)options.get("urc"));
            interceptor = new PoolInterceptor();
            this.converter = new IdentifierConverter(this.structContext, this.helper, interceptor);
        }
        DecompilerContext.initContext(options, logger, this.structContext, this.classProcessor, interceptor);
    }

    public void decompileContext() {
        if (this.converter != null) {
            this.converter.rename();
        }
        this.classProcessor.loadClasses(this.helper);
        this.structContext.saveContext();
    }

    private static IIdentifierRenamer loadHelper(String className) {
        if (className != null) {
            try {
                Class<?> renamerClass = Fernflower.class.getClassLoader().loadClass(className);
                return (IIdentifierRenamer)renamerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ConverterHelper();
    }

    public void clearContext() {
        DecompilerContext.clearContext();
    }

    public StructContext getStructContext() {
        return this.structContext;
    }

    @Override
    public String getClassEntryName(StructClass cl, String entryName) {
        ClassesProcessor.ClassNode node = this.classProcessor.getMapRootClasses().get(cl.qualifiedName);
        if (node.type != 0) {
            return null;
        }
        if (this.converter != null) {
            String simpleClassName = cl.qualifiedName.substring(cl.qualifiedName.lastIndexOf(47) + 1);
            return entryName.substring(0, entryName.lastIndexOf(47) + 1) + simpleClassName + ".java";
        }
        return entryName.substring(0, entryName.lastIndexOf(".class")) + ".java";
    }

    @Override
    public String getClassContent(StructClass cl) {
        try {
            TextBuffer buffer = new TextBuffer(16384);
            buffer.append(DecompilerContext.getProperty("ban").toString());
            this.classProcessor.writeClass(cl, buffer);
            return buffer.toString();
        }
        catch (Throwable ex) {
            DecompilerContext.getLogger().writeMessage("Class " + cl.qualifiedName + " couldn't be fully decompiled.", ex);
            return null;
        }
    }
}

