/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.testDiscovery.instrumentation;

import com.intellij.rt.coverage.testDiscovery.instrumentation.InstrumentedMethodsFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class TestDiscoveryInstrumenter
extends ClassVisitor {
    private static final int ADDED_CODE_STACK_SIZE = 6;
    private final String myClassName;
    private final String myInternalClassName;
    private final ClassLoader myClassLoader;
    private final String myInternalCounterClassJVMName;
    private static final String myInternalCounterClassName = "int";
    private final InstrumentedMethodsFilter myMethodFilter;
    private final String[] myMethodNames;
    private int myCurrentMethodCount;
    private boolean myVisitedStaticBlock;
    private int myClassVersion;
    private volatile Method myDefineClassMethodRef;
    private static final String METHODS_VISITED = "__$methodsVisited$__";
    private static final String METHODS_VISITED_CLASS = "[Z";
    private static final boolean INLINE_COUNTERS = System.getProperty("idea.inline.counter.fields") != null;

    TestDiscoveryInstrumenter(ClassVisitor classVisitor, ClassReader cr, String className, ClassLoader loader) {
        super(393216, classVisitor);
        this.myMethodFilter = new InstrumentedMethodsFilter(className);
        this.myClassName = className.replace('$', '.');
        this.myInternalClassName = className.replace('.', '/');
        this.myInternalCounterClassJVMName = this.myInternalClassName + "$" + myInternalCounterClassName;
        this.myClassLoader = loader;
        this.myMethodNames = this.collectMethodNames(cr, className);
    }

    private String[] collectMethodNames(ClassReader cr, final String className) {
        final ArrayList instrumentedMethods = new ArrayList();
        ClassVisitor instrumentedMethodCounter = new ClassVisitor(393216){
            final InstrumentedMethodsFilter methodsFilter;
            {
                super(x0);
                this.methodsFilter = new InstrumentedMethodsFilter(className);
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.methodsFilter.visit(version, access, name, signature, superName, interfaces);
                TestDiscoveryInstrumenter.this.myClassVersion = version;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (this.methodsFilter.shouldVisitMethod(access, name, desc, signature, exceptions)) {
                    if ("<init>".equals(name)) {
                        int slashPos = className.lastIndexOf(46);
                        int $Pos = className.lastIndexOf(36);
                        name = className.substring(Math.max(slashPos, $Pos) + 1);
                    }
                    instrumentedMethods.add(name);
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        };
        cr.accept(instrumentedMethodCounter, 0);
        return instrumentedMethods.toArray(new String[0]);
    }

    private void generateInnerClassWithCounter() {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(this.myClassVersion, 4152, this.myInternalCounterClassJVMName, null, "java/lang/Object", null);
        cw.visitOuterClass(this.myInternalClassName, this.myInternalCounterClassJVMName, null);
        cw.visitField(25, METHODS_VISITED, METHODS_VISITED_CLASS, null, null);
        MethodVisitor staticBlockVisitor = cw.visitMethod(8, "<clinit>", "()V", null, null);
        staticBlockVisitor = new StaticBlockMethodVisitor(staticBlockVisitor);
        staticBlockVisitor.visitCode();
        staticBlockVisitor.visitInsn(177);
        staticBlockVisitor.visitMaxs(6, 0);
        staticBlockVisitor.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        try {
            byte[] bytes = cw.toByteArray();
            Method defineClassMethodRef = this.myDefineClassMethodRef;
            if (defineClassMethodRef == null && (defineClassMethodRef = ClassLoader.class.getDeclaredMethod("defineClass", byte[].class, Integer.TYPE, Integer.TYPE)) != null) {
                defineClassMethodRef.setAccessible(true);
                this.myDefineClassMethodRef = defineClassMethodRef;
            }
            defineClassMethodRef.invoke((Object)this.myClassLoader, bytes, 0, bytes.length);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.myMethodFilter.visit(version, access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (mv == null) {
            return null;
        }
        if ("<clinit>".equals(name)) {
            if (INLINE_COUNTERS) {
                this.myVisitedStaticBlock = true;
                return new StaticBlockMethodVisitor(mv);
            }
            return mv;
        }
        if (!this.myMethodFilter.shouldVisitMethod(access, name, desc, signature, exceptions)) {
            return mv;
        }
        return new MethodVisitor(393216, mv){
            final int myMethodId;
            {
                this.myMethodId = TestDiscoveryInstrumenter.this.myCurrentMethodCount++;
            }

            public void visitCode() {
                this.visitFieldInsn(178, INLINE_COUNTERS ? TestDiscoveryInstrumenter.this.myInternalClassName : TestDiscoveryInstrumenter.this.myInternalCounterClassJVMName, TestDiscoveryInstrumenter.METHODS_VISITED, TestDiscoveryInstrumenter.METHODS_VISITED_CLASS);
                TestDiscoveryInstrumenter.pushInstruction(this, this.myMethodId);
                this.visitInsn(4);
                this.visitInsn(84);
                super.visitCode();
            }
        };
    }

    public void visitEnd() {
        if (INLINE_COUNTERS) {
            this.visitField(25, METHODS_VISITED, METHODS_VISITED_CLASS, null, null);
            if (!this.myVisitedStaticBlock) {
                MethodVisitor mv = super.visitMethod(8, "<clinit>", "()V", null, null);
                mv = new StaticBlockMethodVisitor(mv);
                mv.visitCode();
                mv.visitInsn(177);
                mv.visitMaxs(6, 0);
                mv.visitEnd();
            }
        } else if (this.myMethodNames.length > 0) {
            this.generateInnerClassWithCounter();
            this.visitInnerClass(this.myInternalCounterClassJVMName, this.myInternalClassName, myInternalCounterClassName, 26);
        }
        super.visitEnd();
    }

    private static void pushInstruction(MethodVisitor mv, int operand) {
        if (operand < 127) {
            mv.visitIntInsn(16, operand);
        } else {
            mv.visitIntInsn(17, operand);
        }
    }

    private class StaticBlockMethodVisitor
    extends MethodVisitor {
        StaticBlockMethodVisitor(MethodVisitor mv) {
            super(393216, mv);
        }

        public void visitCode() {
            super.visitCode();
            this.visitLdcInsn(TestDiscoveryInstrumenter.this.myClassName);
            TestDiscoveryInstrumenter.pushInstruction(this, TestDiscoveryInstrumenter.this.myMethodNames.length);
            this.visitIntInsn(188, 4);
            TestDiscoveryInstrumenter.pushInstruction(this, TestDiscoveryInstrumenter.this.myMethodNames.length);
            this.visitTypeInsn(189, "java/lang/String");
            for (int i = 0; i < TestDiscoveryInstrumenter.this.myMethodNames.length; ++i) {
                this.visitInsn(89);
                TestDiscoveryInstrumenter.pushInstruction(this, i);
                this.visitLdcInsn(TestDiscoveryInstrumenter.this.myMethodNames[i]);
                this.visitInsn(83);
            }
            this.visitMethodInsn(184, "com/intellij/rt/coverage/data/TestDiscoveryProjectData", "trace", "(Ljava/lang/String;[Z[Ljava/lang/String;)[Z", false);
            this.visitFieldInsn(179, INLINE_COUNTERS ? TestDiscoveryInstrumenter.this.myInternalClassName : TestDiscoveryInstrumenter.this.myInternalCounterClassJVMName, TestDiscoveryInstrumenter.METHODS_VISITED, TestDiscoveryInstrumenter.METHODS_VISITED_CLASS);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            super.visitMaxs(Math.max(6, maxStack), maxLocals);
        }
    }
}

