/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.reflection;

import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.reflection.ModelMethod;

public abstract class TypeUtil {
    public static final String BYTE = "B";
    public static final String CHAR = "C";
    public static final String DOUBLE = "D";
    public static final String FLOAT = "F";
    public static final String INT = "I";
    public static final String LONG = "J";
    public static final String SHORT = "S";
    public static final String VOID = "V";
    public static final String BOOLEAN = "Z";
    public static final String ARRAY = "[";
    public static final String CLASS_PREFIX = "L";
    public static final String CLASS_SUFFIX = ";";
    private static TypeUtil sInstance;

    public abstract String getDescription(ModelClass var1);

    public abstract String getDescription(ModelMethod var1);

    public String toBinaryName(String name) {
        if (name.endsWith("[]")) {
            return ARRAY + this.toBinaryName(name.substring(0, name.length() - 2));
        }
        if (Boolean.TYPE.getSimpleName().equals(name)) {
            return BOOLEAN;
        }
        if (Byte.TYPE.getSimpleName().equals(name)) {
            return BYTE;
        }
        if (Short.TYPE.getSimpleName().equals(name)) {
            return SHORT;
        }
        if (Integer.TYPE.getSimpleName().equals(name)) {
            return INT;
        }
        if (Long.TYPE.getSimpleName().equals(name)) {
            return LONG;
        }
        if (Character.TYPE.getSimpleName().equals(name)) {
            return CHAR;
        }
        if (Float.TYPE.getSimpleName().equals(name)) {
            return FLOAT;
        }
        if (Double.TYPE.getSimpleName().equals(name)) {
            return DOUBLE;
        }
        if (Void.TYPE.getSimpleName().equals(name)) {
            return VOID;
        }
        return name;
    }

    public static TypeUtil getInstance() {
        if (sInstance == null) {
            sInstance = ModelAnalyzer.getInstance().createTypeUtil();
        }
        return sInstance;
    }
}

