/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class ByteCodeViewerComponent
extends JPanel
implements Disposable {
    private final Editor myEditor;

    public ByteCodeViewerComponent(Project project) {
        super(new BorderLayout());
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = ((EditorFactoryImpl)factory).createDocument((CharSequence)"", true, false);
        doc.setReadOnly(true);
        this.myEditor = factory.createEditor(doc, project);
        EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.getInstance();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)StdFileTypes.JAVA, (Project)project, null);
        ((EditorEx)this.myEditor).setHighlighter(editorHighlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme()));
        ((EditorEx)this.myEditor).setCaretVisible(true);
        EditorSettings settings = this.myEditor.getSettings();
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        this.myEditor.setBorder(null);
        this.add((Component)this.myEditor.getComponent(), "Center");
    }

    public void setText(String bytecode) {
        this.setText(bytecode, 0);
    }

    public void setText(String bytecode, PsiElement element) {
        Document document;
        int offset = 0;
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (file != null && (document = FileDocumentManager.getInstance().getDocument(file)) != null) {
            int lineNumber = document.getLineNumber(element.getTextOffset());
            LineNumbersMapping mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY);
            if (mapping != null) {
                int mappedLine = mapping.sourceToBytecode(lineNumber);
                while (mappedLine == -1 && lineNumber < document.getLineCount()) {
                    mappedLine = mapping.sourceToBytecode(++lineNumber);
                }
                if (mappedLine > 0) {
                    lineNumber = mappedLine;
                }
            }
            offset = bytecode.indexOf("LINENUMBER " + lineNumber);
            while (offset == -1 && lineNumber < document.getLineCount()) {
                offset = bytecode.indexOf("LINENUMBER " + lineNumber++);
            }
        }
        this.setText(bytecode, Math.max(0, offset));
    }

    public void setText(String bytecode, int offset) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            Document fragmentDoc = this.myEditor.getDocument();
            fragmentDoc.setReadOnly(false);
            fragmentDoc.replaceString(0, fragmentDoc.getTextLength(), (CharSequence)bytecode);
            fragmentDoc.setReadOnly(true);
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        });
    }

    public String getText() {
        return this.myEditor.getDocument().getText();
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

