/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.service;

import com.android.tools.datastore.DataStoreService;
import com.android.tools.datastore.ServicePassThrough;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.datastore.database.ProfilerTable;
import com.android.tools.datastore.poller.ProfilerDevicePoller;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Profiler;
import com.android.tools.profiler.proto.ProfilerServiceGrpc;
import com.google.common.collect.Maps;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ProfilerService
extends ProfilerServiceGrpc.ProfilerServiceImplBase
implements ServicePassThrough {
    private final Map<Channel, ProfilerDevicePoller> myPollers;
    private final Consumer<Runnable> myFetchExecutor;
    private final ProfilerTable myTable;
    private final DataStoreService myService;

    public ProfilerService(@NotNull DataStoreService service, Consumer<Runnable> fetchExecutor, @NotNull Map<Common.Session, Long> sessionIdLookup) {
        if (service == null) {
            ProfilerService.$$$reportNull$$$0(0);
        }
        if (sessionIdLookup == null) {
            ProfilerService.$$$reportNull$$$0(1);
        }
        this.myPollers = Maps.newHashMap();
        this.myService = service;
        this.myFetchExecutor = fetchExecutor;
        this.myTable = new ProfilerTable(sessionIdLookup);
    }

    public void getCurrentTime(Profiler.TimeRequest request, StreamObserver<Profiler.TimeResponse> observer) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.getCurrentTime(request));
        } else {
            observer.onNext((Object)Profiler.TimeResponse.getDefaultInstance());
        }
        observer.onCompleted();
    }

    public void getVersion(Profiler.VersionRequest request, StreamObserver<Profiler.VersionResponse> observer) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(request.getSession());
        if (client != null) {
            observer.onNext((Object)client.getVersion(request));
        }
        observer.onCompleted();
    }

    public void getDevices(Profiler.GetDevicesRequest request, StreamObserver<Profiler.GetDevicesResponse> observer) {
        Profiler.GetDevicesResponse response = this.myTable.getDevices(request);
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getProcesses(Profiler.GetProcessesRequest request, StreamObserver<Profiler.GetProcessesResponse> observer) {
        Profiler.GetProcessesResponse response = this.myTable.getProcesses(request);
        observer.onNext((Object)response);
        observer.onCompleted();
    }

    public void getAgentStatus(Profiler.AgentStatusRequest request, StreamObserver<Profiler.AgentStatusResponse> observer) {
        observer.onNext((Object)this.myTable.getAgentStatus(request));
        observer.onCompleted();
    }

    public void attachAgent(Profiler.AgentAttachRequest request, StreamObserver<Profiler.AgentAttachResponse> responseObserver) {
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(request.getSession());
        responseObserver.onNext((Object)(client == null ? Profiler.AgentAttachResponse.getDefaultInstance() : client.attachAgent(request)));
        responseObserver.onCompleted();
    }

    public void startMonitoring(Channel channel) {
        assert (!this.myPollers.containsKey(channel));
        ProfilerServiceGrpc.ProfilerServiceBlockingStub stub = ProfilerServiceGrpc.newBlockingStub((Channel)channel);
        ProfilerDevicePoller poller = new ProfilerDevicePoller(this.myService, this.myTable, stub);
        this.myPollers.put(channel, poller);
        DataStoreTable.addDataStoreErrorCallback(poller);
        this.myFetchExecutor.accept(this.myPollers.get(channel));
    }

    public void stopMonitoring(Channel channel) {
        if (this.myPollers.containsKey(channel)) {
            ProfilerDevicePoller poller = this.myPollers.remove(channel);
            poller.stop();
            DataStoreTable.removeDataStoreErrorCallback(poller);
        }
    }

    public void getBytes(Profiler.BytesRequest request, StreamObserver<Profiler.BytesResponse> responseObserver) {
        Profiler.BytesResponse response = this.myTable.getBytes(request);
        ProfilerServiceGrpc.ProfilerServiceBlockingStub client = this.myService.getProfilerClient(request.getSession());
        if (response == null && client != null) {
            response = this.myService.getProfilerClient(request.getSession()).getBytes(request);
            this.myTable.insertOrUpdateBytes(request.getId(), request.getSession(), response);
        } else if (response == null) {
            response = Profiler.BytesResponse.getDefaultInstance();
        }
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
    }

    @Override
    @NotNull
    public List<DataStoreService.BackingNamespace> getBackingNamespaces() {
        List<DataStoreService.BackingNamespace> list = Collections.singletonList(DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        if (list == null) {
            ProfilerService.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public void setBackingStore(@NotNull DataStoreService.BackingNamespace namespace, @NotNull Connection connection) {
        if (namespace == null) {
            ProfilerService.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            ProfilerService.$$$reportNull$$$0(4);
        }
        assert (namespace == DataStoreService.BackingNamespace.DEFAULT_SHARED_NAMESPACE);
        this.myTable.initialize(connection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionIdLookup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/datastore/service/ProfilerService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/datastore/service/ProfilerService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingNamespaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBackingStore";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

