/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.flat.FlatButton;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.profilers.IdeProfilerComponents;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.MemoryProfilerAspect;
import com.android.tools.profilers.memory.MemoryProfilerStage;
import com.android.tools.profilers.memory.adapters.CaptureObject;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryCaptureView
extends AspectObserver {
    @NotNull
    private final MemoryProfilerStage myStage;
    @NotNull
    private final JLabel myLabel;
    @NotNull
    private final JButton myExportButton;
    @NotNull
    private final JPanel myPanel;
    @Nullable
    private CaptureObject myCaptureObject;

    private static Logger getLogger() {
        return Logger.getInstance(MemoryCaptureView.class);
    }

    MemoryCaptureView(@NotNull MemoryProfilerStage stage, @NotNull IdeProfilerComponents ideProfilerComponents) {
        if (stage == null) {
            MemoryCaptureView.$$$reportNull$$$0(0);
        }
        if (ideProfilerComponents == null) {
            MemoryCaptureView.$$$reportNull$$$0(1);
        }
        this.myCaptureObject = null;
        this.myStage = stage;
        this.myStage.getAspect().addDependency((AspectObserver)this).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADING_CAPTURE, this::reset).onChange((Enum)MemoryProfilerAspect.CURRENT_LOADED_CAPTURE, this::refresh);
        this.myPanel = new JPanel(ProfilerLayout.TOOLBAR_LAYOUT);
        this.myLabel = new JLabel();
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.myExportButton = new FlatButton(AllIcons.Actions.Export);
        this.myExportButton.setToolTipText("Export capture to file");
        this.myExportButton.addActionListener(e -> {
            if (ideProfilerComponents == null) {
                MemoryCaptureView.$$$reportNull$$$0(5);
            }
            if (stage == null) {
                MemoryCaptureView.$$$reportNull$$$0(6);
            }
            ideProfilerComponents.openExportDialog(() -> "Export As", this::getFileExtension, file -> {
                if (stage == null) {
                    MemoryCaptureView.$$$reportNull$$$0(7);
                }
                stage.getStudioProfilers().getIdeServices().saveFile((File)file, this::saveToFile, null);
            });
        });
        this.reset();
    }

    @VisibleForTesting
    @NotNull
    JLabel getLabel() {
        JLabel jLabel = this.myLabel;
        if (jLabel == null) {
            MemoryCaptureView.$$$reportNull$$$0(2);
        }
        return jLabel;
    }

    @NotNull
    JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            MemoryCaptureView.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void reset() {
        this.myPanel.removeAll();
        this.myLabel.setText("");
        this.myCaptureObject = this.myStage.getSelectedCapture();
        this.myExportButton.setEnabled(false);
    }

    private void refresh() {
        boolean validCapture;
        CaptureObject captureObject = this.myStage.getSelectedCapture();
        boolean bl = validCapture = captureObject == this.myCaptureObject && this.myCaptureObject != null;
        if (validCapture) {
            if (captureObject.isExportable()) {
                this.myExportButton.setEnabled(captureObject.isExportable());
                this.myPanel.add(this.myExportButton);
                this.myPanel.add((Component)new FlatSeparator());
            }
            this.myLabel.setText(this.myCaptureObject.getName());
            this.myPanel.add(this.myLabel);
            this.myPanel.add((Component)new FlatSeparator());
        }
    }

    @Nullable
    private String getFileExtension() {
        return this.myCaptureObject == null ? null : this.myCaptureObject.getExportableExtension();
    }

    private void saveToFile(@NotNull FileOutputStream outputStream) {
        if (outputStream == null) {
            MemoryCaptureView.$$$reportNull$$$0(4);
        }
        if (this.myCaptureObject != null) {
            try {
                this.myCaptureObject.saveToFile(outputStream);
            }
            catch (IOException e) {
                MemoryCaptureView.getLogger().warn((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProfilerComponents";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/profilers/memory/MemoryCaptureView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/profilers/memory/MemoryCaptureView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "saveToFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

