/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@ApiStatus.Experimental
public class YamlNumberType
extends YamlScalarType {
    private static final YamlNumberType SHARED_INSTANCE = new YamlNumberType();

    public static YamlNumberType getInstance() {
        return SHARED_INSTANCE;
    }

    public YamlNumberType() {
        super("yaml:number");
        this.setDisplayName("number");
    }

    @Override
    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        if (scalarValue == null) {
            YamlNumberType.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            YamlNumberType.$$$reportNull$$$0(1);
        }
        try {
            Float.parseFloat(scalarValue.getTextValue());
        }
        catch (NumberFormatException e) {
            holder.registerProblem((PsiElement)scalarValue, "Numeric value expected", new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scalarValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/yaml/meta/model/YamlNumberType";
        objectArray[2] = "validateScalarValue";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

