/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.smali.psi.SmaliClassName;
import com.android.tools.idea.smali.psi.SmaliClassSpec;
import com.android.tools.idea.smali.psi.SmaliFile;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DexSourceFiles {
    public static final String SMALI_ROOT_FOLDER_NAME = "smali";
    public static final String SMALI_OUTPUT_FOLDER_NAME = "out";
    @NotNull
    private final Project myProject;
    @NotNull
    private final File myOutputFolderPath;

    @NotNull
    public static DexSourceFiles getInstance(@NotNull Project project) {
        if (project == null) {
            DexSourceFiles.$$$reportNull$$$0(0);
        }
        DexSourceFiles dexSourceFiles = (DexSourceFiles)ServiceManager.getService((Project)project, DexSourceFiles.class);
        if (dexSourceFiles == null) {
            DexSourceFiles.$$$reportNull$$$0(1);
        }
        return dexSourceFiles;
    }

    public DexSourceFiles(@NotNull Project project) {
        if (project == null) {
            DexSourceFiles.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myOutputFolderPath = this.getDefaultSmaliOutputFolderPath();
    }

    @NotNull
    public File getDefaultSmaliOutputFolderPath() {
        File file = new File(Projects.getBaseDirPath(this.myProject), FileUtil.join((String[])new String[]{SMALI_ROOT_FOLDER_NAME, SMALI_OUTPUT_FOLDER_NAME}));
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(3);
        }
        return file;
    }

    public boolean isJavaFile(@NotNull VirtualFile file) {
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(4);
        }
        return !file.isDirectory() && "java".equals(file.getExtension());
    }

    @Nullable
    public String findJavaClassName(@NotNull SmaliFile smaliFile) {
        SmaliClassSpec classSpec;
        if (smaliFile == null) {
            DexSourceFiles.$$$reportNull$$$0(5);
        }
        if ((classSpec = (SmaliClassSpec)PsiTreeUtil.findChildOfType((PsiElement)smaliFile, SmaliClassSpec.class)) != null) {
            SmaliClassName className = classSpec.getClassName();
            return className != null ? className.getJavaClassName() : null;
        }
        return null;
    }

    public boolean navigateToJavaFile(@NotNull String classFqn) {
        PsiClass javaPsiClass;
        if (classFqn == null) {
            DexSourceFiles.$$$reportNull$$$0(6);
        }
        if ((javaPsiClass = this.findJavaPsiClass(classFqn)) != null) {
            NavigationUtil.openFileWithPsiElement((PsiElement)javaPsiClass, (boolean)true, (boolean)true);
            return true;
        }
        return false;
    }

    @Nullable
    public PsiClass findJavaPsiClass(@NotNull String classFqn) {
        if (classFqn == null) {
            DexSourceFiles.$$$reportNull$$$0(7);
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(classFqn, GlobalSearchScope.allScope((Project)this.myProject));
    }

    @NotNull
    public List<String> findJavaClassesIn(@NotNull VirtualFile file) {
        PsiClass[] classes;
        PsiJavaFile psiFile;
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(8);
        }
        if ((psiFile = this.findPsiJavaFileFor(file)) != null && (classes = psiFile.getClasses()).length > 0) {
            List<String> list = Arrays.stream(classes).map(PsiClass::getQualifiedName).collect(Collectors.toList());
            if (list == null) {
                DexSourceFiles.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            DexSourceFiles.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public String findJavaPackageNameIn(@NotNull VirtualFile file) {
        PsiJavaFile psiFile;
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(11);
        }
        return (psiFile = this.findPsiJavaFileFor(file)) != null ? psiFile.getPackageName() : null;
    }

    public boolean isSmaliFile(@NotNull VirtualFile file) {
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(12);
        }
        return !file.isDirectory() && SMALI_ROOT_FOLDER_NAME.equals(file.getExtension());
    }

    @Nullable
    private PsiJavaFile findPsiJavaFileFor(@NotNull VirtualFile file) {
        PsiFile psiFile;
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(13);
        }
        return (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) instanceof PsiJavaFile ? (PsiJavaFile)psiFile : null;
    }

    @Nullable
    public VirtualFile findSmaliFile(@NotNull String classFqn) {
        File filePath;
        if (classFqn == null) {
            DexSourceFiles.$$$reportNull$$$0(14);
        }
        if ((filePath = this.findSmaliFilePathForClass(classFqn)).isFile()) {
            return LocalFileSystem.getInstance().findFileByPath(filePath.getPath());
        }
        return null;
    }

    @NotNull
    public File findSmaliFilePathForClass(@NotNull String classFqn) {
        if (classFqn == null) {
            DexSourceFiles.$$$reportNull$$$0(15);
        }
        File file = new File(this.myOutputFolderPath, classFqn.replace('.', File.separatorChar) + ".smali");
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(16);
        }
        return file;
    }

    @NotNull
    public File findSmaliFilePathForPackage(@NotNull String packageFqn) {
        if (packageFqn == null) {
            DexSourceFiles.$$$reportNull$$$0(17);
        }
        File file = new File(this.myOutputFolderPath, packageFqn.replace('.', File.separatorChar));
        if (file == null) {
            DexSourceFiles.$$$reportNull$$$0(18);
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/apk/debugging/DexSourceFiles";
                break;
            }
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smaliFile";
                break;
            }
            case 6: 
            case 7: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/apk/debugging/DexSourceFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSmaliOutputFolderPath";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaClassesIn";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findSmaliFilePathForClass";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findSmaliFilePathForPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isJavaFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findJavaClassName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "navigateToJavaFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findJavaPsiClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findJavaClassesIn";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findJavaPackageNameIn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSmaliFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findPsiJavaFileFor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSmaliFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findSmaliFilePathForClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findSmaliFilePathForPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 10: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

