/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IClientChangeListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(DevicePanel.class);
    private JPanel myPanel;
    private final DeviceContext myDeviceContext;
    @Nullable
    private AndroidDebugBridge myBridge;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<String, String> myPreferredClients;
    public boolean myIgnoreActionEvents;
    @NotNull
    private JComboBox myDeviceCombo;
    @NotNull
    private JComboBox myClientCombo;
    private final NullableLazyValue<String> myCandidateClientName;
    @NotNull
    private DeviceRenderer.DeviceComboBoxRenderer myDeviceRenderer;

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext context) {
        if (project == null) {
            DevicePanel.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DevicePanel.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myCandidateClientName = new NullableLazyValue<String>(){

            @Nullable
            protected String compute() {
                return DevicePanel.this.getApplicationName();
            }
        };
        this.myProject = project;
        this.myDeviceContext = context;
        this.myPreferredClients = Maps.newHashMap();
        Disposer.register((Disposable)this.myProject, (Disposable)this);
        this.initializeDeviceCombo();
        this.initializeClientCombo();
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    private void initializeDeviceCombo() {
        AccessibleContextUtil.setName((Component)this.myDeviceCombo, (String)"Devices");
        this.myDeviceCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DevicePanel.this.myIgnoreActionEvents) {
                    return;
                }
                DevicePanel.this.updateClientCombo();
                Object sel = DevicePanel.this.myDeviceCombo.getSelectedItem();
                IDevice device = sel instanceof IDevice ? (IDevice)sel : null;
                DevicePanel.this.myDeviceContext.fireDeviceSelected(device);
            }
        });
        boolean showSerial = false;
        if (this.myBridge != null) {
            showSerial = DeviceRenderer.shouldShowSerialNumbers(Arrays.asList(this.myBridge.getDevices()));
        }
        this.myDeviceRenderer = new DeviceRenderer.DeviceComboBoxRenderer("No Connected Devices", showSerial);
        this.myDeviceCombo.setRenderer(this.myDeviceRenderer);
        Dimension size = this.myDeviceCombo.getMinimumSize();
        this.myDeviceCombo.setMinimumSize(new Dimension(200, size.height));
    }

    private void initializeClientCombo() {
        AccessibleContextUtil.setName((Component)this.myClientCombo, (String)"Processes");
        this.myClientCombo.setName("Processes");
        this.myClientCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DevicePanel.this.myIgnoreActionEvents) {
                    return;
                }
                Client client = (Client)DevicePanel.this.myClientCombo.getSelectedItem();
                if (client != null) {
                    DevicePanel.this.myPreferredClients.put(client.getDevice().getName(), client.getClientData().getClientDescription());
                }
                DevicePanel.this.myDeviceContext.fireClientSelected(client);
            }
        });
        this.myClientCombo.setRenderer(new ClientCellRenderer("No Debuggable Processes"));
        Dimension size = this.myClientCombo.getMinimumSize();
        this.myClientCombo.setMinimumSize(new Dimension(250, size.height));
    }

    public void selectDevice(IDevice device) {
        this.myDeviceCombo.setSelectedItem(device);
    }

    public void selectClient(Client client) {
        this.myClientCombo.setSelectedItem(client);
    }

    @Nullable
    private String getApplicationName() {
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    public void dispose() {
        if (this.myBridge != null) {
            AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
            AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
            AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
            this.myBridge = null;
        }
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            this.myBridge = bridge;
            this.updateDeviceCombo();
        }));
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(2);
        }
        LOG.info("Device connected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(3);
        }
        LOG.info("Device disconnected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(4);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (device == null) {
                DevicePanel.$$$reportNull$$$0(6);
            }
            if ((changeMask & 2) != 0) {
                this.updateClientCombo();
            } else if ((changeMask & 1) != 0) {
                this.updateDeviceCombo();
            }
            this.myDeviceContext.fireDeviceChanged(device, changeMask);
        });
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        if (client == null) {
            DevicePanel.$$$reportNull$$$0(5);
        }
        if ((changeMask & 1) != 0) {
            ApplicationManager.getApplication().invokeLater(this::updateClientCombo);
        }
    }

    private void updateDeviceCombo() {
        this.myIgnoreActionEvents = true;
        boolean update = true;
        IDevice selected = (IDevice)this.myDeviceCombo.getSelectedItem();
        this.myDeviceCombo.removeAllItems();
        boolean shouldAddSelected = true;
        if (this.myBridge != null) {
            IDevice[] devices = this.myBridge.getDevices();
            this.myDeviceRenderer.setShowSerial(DeviceRenderer.shouldShowSerialNumbers(Arrays.asList(devices)));
            for (IDevice device : devices) {
                boolean isSelectedReattached;
                this.myDeviceCombo.addItem(device);
                boolean bl = isSelectedReattached = selected != null && !selected.isEmulator() && selected.getSerialNumber().equals(device.getSerialNumber());
                if (selected != device && !isSelectedReattached) continue;
                this.myDeviceCombo.setSelectedItem(device);
                shouldAddSelected = false;
                update = selected != device;
            }
        }
        if (selected != null && shouldAddSelected) {
            this.myDeviceCombo.addItem(selected);
            this.myDeviceCombo.setSelectedItem(selected);
        }
        if (update) {
            this.myDeviceContext.fireDeviceSelected((IDevice)this.myDeviceCombo.getSelectedItem());
            this.updateClientCombo();
        }
        this.myIgnoreActionEvents = false;
    }

    private void updateClientCombo() {
        this.myIgnoreActionEvents = true;
        IDevice device = (IDevice)this.myDeviceCombo.getSelectedItem();
        Client selected = (Client)this.myClientCombo.getSelectedItem();
        Client toSelect = null;
        boolean update = true;
        this.myClientCombo.removeAllItems();
        if (device != null) {
            boolean selectedClientDied;
            Client preferredClient;
            String preferred = this.getPreferredClientForDevice(device.getName());
            if (preferred != null && (preferredClient = device.getClient(preferred)) != null) {
                toSelect = preferredClient;
            }
            ArrayList clients = Lists.newArrayList((Object[])device.getClients());
            boolean bl = selectedClientDied = selected != null && selected.getDevice() == device && !clients.contains(selected);
            if (selectedClientDied) {
                if (toSelect == null) {
                    toSelect = selected;
                }
                clients.add(selected);
            }
            Collections.sort(clients, new ClientCellRenderer.ClientComparator());
            for (Client client : clients) {
                this.myClientCombo.addItem(client);
            }
            this.myClientCombo.setSelectedItem(toSelect);
            update = toSelect != selected;
        }
        this.myIgnoreActionEvents = false;
        if (update) {
            this.myDeviceContext.fireClientSelected((Client)this.myClientCombo.getSelectedItem());
        }
    }

    @Nullable
    private String getPreferredClientForDevice(String deviceName) {
        String client = this.myPreferredClients.get(deviceName);
        return client == null ? (String)this.myCandidateClientName.getValue() : client;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/DevicePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "deviceConnected";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "deviceDisconnected";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "deviceChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clientChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$deviceChanged$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeviceCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myClientCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, new Dimension(20, -1), new Dimension(27, 11), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

