/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.tools.idea.ddms.EdtExecutor;
import com.android.tools.idea.editors.vmtrace.VmTraceCaptureType;
import com.android.tools.idea.profiling.capture.Capture;
import com.android.tools.idea.profiling.capture.CaptureHandle;
import com.android.tools.idea.profiling.capture.CaptureService;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;

public class OpenVmTraceHandler
implements ClientData.IMethodProfilingHandler {
    private static final Logger LOG = Logger.getInstance(OpenVmTraceHandler.class);
    private final Project myProject;

    public OpenVmTraceHandler(Project project) {
        this.myProject = project;
    }

    public void onSuccess(String remoteFilePath, Client client) {
        this.showError("Method profiling: Older devices (API level < 10) are not supported yet. Please manually retrieve the file " + remoteFilePath + " from the device and open the file to view the results.");
    }

    public void onSuccess(final @NotNull byte[] data, final @NotNull Client client) {
        if (data == null) {
            OpenVmTraceHandler.$$$reportNull$$$0(0);
        }
        if (client == null) {
            OpenVmTraceHandler.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    final CaptureService service = CaptureService.getInstance(OpenVmTraceHandler.this.myProject);
                    String name = service.getSuggestedName(client);
                    CaptureHandle handle = service.startCaptureFile(VmTraceCaptureType.class, name, false);
                    service.appendData(handle, data);
                    service.finalizeCaptureFileAsynchronous(handle, new FutureCallback<Capture>(){

                        public void onSuccess(Capture result) {
                            service.notifyCaptureReady(result);
                        }

                        public void onFailure(Throwable t) {
                            LOG.error("Method Profiling - error when writing trace: " + t);
                        }
                    }, (Executor)EdtExecutor.INSTANCE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void onStartFailure(Client client, String message) {
        this.showError(message);
    }

    public void onEndFailure(Client client, String message) {
        this.showError(message);
    }

    private void showError(final String message) {
        LOG.error("Method Profiling: " + message);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showErrorDialog((Project)OpenVmTraceHandler.this.myProject, (String)message, (String)"Method Trace");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "data";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "client";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/ddms/OpenVmTraceHandler";
        objectArray[2] = "onSuccess";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

