/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.datamodels;

import com.android.ide.common.rendering.api.ItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.ThemeEditorVirtualFile;
import com.android.tools.idea.res.AppResourceRepository;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ProjectResourceRepository;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeEditorStyle {
    private static final Logger LOG = Logger.getInstance(ThemeEditorStyle.class);
    @NotNull
    private final ConfigurationManager myManager;
    @NotNull
    private final String myQualifiedName;

    public ThemeEditorStyle(@NotNull ConfigurationManager manager, @NotNull String qualifiedName) {
        if (manager == null) {
            ThemeEditorStyle.$$$reportNull$$$0(0);
        }
        if (qualifiedName == null) {
            ThemeEditorStyle.$$$reportNull$$$0(1);
        }
        this.myManager = manager;
        this.myQualifiedName = qualifiedName;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            ThemeEditorStyle.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = ResolutionUtils.getNameFromQualifiedName(this.myQualifiedName);
        if (string == null) {
            ThemeEditorStyle.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isFramework() {
        return this.myQualifiedName.startsWith("android:");
    }

    public boolean isProjectStyle() {
        if (this.isFramework()) {
            return false;
        }
        ProjectResourceRepository repository = ProjectResourceRepository.getOrCreateInstance(this.myManager.getModule());
        assert (repository != null);
        return repository.hasResourceItem(ResourceType.STYLE, this.myQualifiedName);
    }

    @NotNull
    protected Collection<com.android.ide.common.res2.ResourceItem> getStyleResourceItems() {
        ImmutableList resultItems;
        assert (!this.isFramework());
        Module module = this.myManager.getModule();
        if (this.isProjectStyle()) {
            AndroidFacet facet = AndroidFacet.getInstance(module);
            assert (facet != null) : module.getName() + " module doesn't have AndroidFacet";
            HashMap resourceItems = Maps.newHashMap();
            ThemeEditorUtils.acceptResourceResolverVisitor(facet, (resources, moduleName, variantName, isSourceSelected) -> {
                if (!isSourceSelected) {
                    return;
                }
                List items = resources.getResourceItem(ResourceType.STYLE, this.myQualifiedName);
                if (items == null) {
                    return;
                }
                for (com.android.ide.common.res2.ResourceItem item : items) {
                    String key = item.getConfiguration().toShortDisplayString() + "/" + item.getName();
                    resourceItems.put(key, item);
                }
            });
            resultItems = ImmutableList.copyOf(resourceItems.values());
        } else {
            AppResourceRepository resourceRepository = AppResourceRepository.getOrCreateInstance(module);
            assert (resourceRepository != null);
            ImmutableList items = resourceRepository.getResourceItem(ResourceType.STYLE, this.myQualifiedName);
            resultItems = items != null ? items : Collections.emptyList();
        }
        ImmutableList immutableList = resultItems;
        if (immutableList == null) {
            ThemeEditorStyle.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    @NotNull
    public Collection<FolderConfiguration> getFolders() {
        if (this.isFramework()) {
            ImmutableList immutableList = ImmutableList.of((Object)new FolderConfiguration());
            if (immutableList == null) {
                ThemeEditorStyle.$$$reportNull$$$0(5);
            }
            return immutableList;
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            result.add((Object)styleItem.getConfiguration());
        }
        ImmutableList immutableList = result.build();
        if (immutableList == null) {
            ThemeEditorStyle.$$$reportNull$$$0(6);
        }
        return immutableList;
    }

    @NotNull
    public Collection<ItemResourceValue> getValues(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(7);
        }
        if (this.isFramework()) {
            IAndroidTarget target = this.myManager.getHighestApiTarget();
            assert (target != null);
            ResourceItem styleItem = this.myManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), target).getResourceItem(ResourceType.STYLE, this.getName());
            for (ResourceFile file : styleItem.getSourceFileList()) {
                if (!file.getConfiguration().equals((Object)configuration)) continue;
                StyleResourceValue style = (StyleResourceValue)file.getValue(ResourceType.STYLE, this.getName());
                Collection collection = style.getValues();
                if (collection == null) {
                    ThemeEditorStyle.$$$reportNull$$$0(8);
                }
                return collection;
            }
            throw new IllegalArgumentException("bad folder config " + configuration);
        }
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            StyleResourceValue style;
            if (!configuration.equals((Object)styleItem.getConfiguration()) || (style = (StyleResourceValue)styleItem.getResourceValue(false)) == null) continue;
            Collection collection = style.getValues();
            if (collection == null) {
                ThemeEditorStyle.$$$reportNull$$$0(9);
            }
            return collection;
        }
        throw new IllegalArgumentException("bad folder config " + configuration);
    }

    @Nullable
    public String getParentName(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(10);
        }
        if (this.isFramework()) {
            IAndroidTarget target = this.myManager.getHighestApiTarget();
            assert (target != null);
            ResourceItem styleItem = this.myManager.getResolverCache().getFrameworkResources(new FolderConfiguration(), target).getResourceItem(ResourceType.STYLE, this.getName());
            for (ResourceFile file : styleItem.getSourceFileList()) {
                if (!file.getConfiguration().equals((Object)configuration)) continue;
                StyleResourceValue style = (StyleResourceValue)file.getValue(ResourceType.STYLE, this.getName());
                return ResolutionUtils.getParentQualifiedName(style);
            }
            throw new IllegalArgumentException("bad folder config " + configuration);
        }
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            if (!configuration.equals((Object)styleItem.getConfiguration())) continue;
            StyleResourceValue style = (StyleResourceValue)styleItem.getResourceValue(false);
            assert (style != null);
            return ResolutionUtils.getParentQualifiedName(style);
        }
        throw new IllegalArgumentException("bad folder config " + configuration);
    }

    @Nullable
    private XmlTag findXmlTagFromConfiguration(@NotNull FolderConfiguration configuration) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(11);
        }
        for (com.android.ide.common.res2.ResourceItem item : this.getStyleResourceItems()) {
            if (!item.getConfiguration().equals((Object)configuration)) continue;
            return LocalResourceRepository.getItemTag(this.myManager.getProject(), item);
        }
        return null;
    }

    @NotNull
    private ImmutableCollection<FolderConfiguration> findToBeCopied(int desiredApi) {
        HashMap bestVersionCopyFrom = Maps.newHashMap();
        for (com.android.ide.common.res2.ResourceItem styleItem : this.getStyleResourceItems()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)styleItem.getConfiguration());
            int styleItemVersion = ThemeEditorUtils.getVersionFromConfiguration(configuration);
            configuration.setVersionQualifier(null);
            if (styleItemVersion > desiredApi || bestVersionCopyFrom.containsKey(configuration) && ((VersionQualifier)bestVersionCopyFrom.get(configuration)).getVersion() >= styleItemVersion) continue;
            bestVersionCopyFrom.put(configuration, new VersionQualifier(styleItemVersion));
        }
        ImmutableList.Builder toBeCopied = ImmutableList.builder();
        for (FolderConfiguration key : bestVersionCopyFrom.keySet()) {
            FolderConfiguration configuration = FolderConfiguration.copyOf((FolderConfiguration)key);
            VersionQualifier version = (VersionQualifier)bestVersionCopyFrom.get(key);
            if (version.getVersion() != -1) {
                configuration.setVersionQualifier(version);
            }
            if (version.getVersion() >= desiredApi) continue;
            toBeCopied.add((Object)configuration);
        }
        ImmutableList immutableList = toBeCopied.build();
        if (immutableList == null) {
            ThemeEditorStyle.$$$reportNull$$$0(12);
        }
        return immutableList;
    }

    private void setValue(@NotNull FolderConfiguration configuration, @NotNull String attribute, @NotNull String value) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(13);
        }
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(14);
        }
        if (value == null) {
            ThemeEditorStyle.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        XmlTag tag = this.getValueTag(styleTag, attribute);
        if (tag != null) {
            tag.getValue().setEscapedText(value);
        } else {
            XmlTag child = styleTag.createChildTag("item", styleTag.getNamespace(), value, false);
            child.setAttribute("name", attribute);
            styleTag.addSubTag(child, false);
        }
    }

    public void setValue(final @NotNull String attribute, final @NotNull String value) {
        int minSdk;
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(16);
        }
        if (value == null) {
            ThemeEditorStyle.$$$reportNull$$$0(17);
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final Project project = this.myManager.getProject();
        int maxApi = Math.max(ResolutionUtils.getOriginalApiLevel(value, this.myManager.getProject()), ResolutionUtils.getOriginalApiLevel(attribute, project));
        final int desiredApi = maxApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myManager.getModule())) ? -1 : maxApi;
        new WriteCommandAction.Simple(project, "Setting value of " + attribute, new PsiFile[0]){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myManager.getModule())) != null) {
                    facet.refreshResources();
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                Collection<com.android.ide.common.res2.ResourceItem> styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (com.android.ide.common.res2.ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version < desiredApi) continue;
                    ThemeEditorStyle.this.setValue(configuration, attribute, value);
                }
            }
        }.execute();
    }

    private void setParent(@NotNull FolderConfiguration configuration, @NotNull String newParent) {
        if (configuration == null) {
            ThemeEditorStyle.$$$reportNull$$$0(18);
        }
        if (newParent == null) {
            ThemeEditorStyle.$$$reportNull$$$0(19);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XmlTag styleTag = this.findXmlTagFromConfiguration(configuration);
        assert (styleTag != null);
        styleTag.setAttribute("parent", newParent);
    }

    public void setParent(final @NotNull String qualifiedThemeName) {
        int minSdk;
        Project project;
        if (qualifiedThemeName == null) {
            ThemeEditorStyle.$$$reportNull$$$0(20);
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        assert (!qualifiedThemeName.startsWith("@android:style/"));
        assert (!qualifiedThemeName.startsWith("@style/"));
        String newParentResourceUrl = ResolutionUtils.getStyleResourceUrl(qualifiedThemeName);
        int parentApi = ResolutionUtils.getOriginalApiLevel(newParentResourceUrl, project = this.myManager.getProject());
        final int desiredApi = parentApi <= (minSdk = ThemeEditorUtils.getMinApiLevel(this.myManager.getModule())) ? -1 : parentApi;
        new WriteCommandAction.Simple(project, "Updating Parent to " + qualifiedThemeName, new PsiFile[0]){

            protected void run() {
                AndroidFacet facet;
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                ImmutableCollection toBeCopied = ThemeEditorStyle.this.findToBeCopied(desiredApi);
                for (FolderConfiguration configuration : toBeCopied) {
                    XmlTag styleTag = ThemeEditorStyle.this.findXmlTagFromConfiguration(configuration);
                    assert (styleTag != null);
                    ThemeEditorUtils.copyTheme(desiredApi, styleTag);
                }
                if (!toBeCopied.isEmpty() && (facet = AndroidFacet.getInstance(ThemeEditorStyle.this.myManager.getModule())) != null) {
                    facet.refreshResources();
                    FileDocumentManager.getInstance().saveAllDocuments();
                }
                Collection<com.android.ide.common.res2.ResourceItem> styleItems = ThemeEditorStyle.this.getStyleResourceItems();
                for (com.android.ide.common.res2.ResourceItem style : styleItems) {
                    FolderConfiguration configuration = style.getConfiguration();
                    int version = ThemeEditorUtils.getVersionFromConfiguration(configuration);
                    if (version < desiredApi) continue;
                    ThemeEditorStyle.this.setParent(configuration, qualifiedThemeName);
                }
            }
        }.execute();
    }

    @Nullable
    private XmlTag getValueTag(@NotNull XmlTag sourceTag, final @NotNull String attribute) {
        if (sourceTag == null) {
            ThemeEditorStyle.$$$reportNull$$$0(21);
        }
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(22);
        }
        if (!this.isProjectStyle()) {
            return null;
        }
        final Ref resultXmlTag = new Ref();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        sourceTag.acceptChildren(new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                super.visitElement(element);
                if (!(element instanceof XmlTag)) {
                    return;
                }
                XmlTag tag = (XmlTag)element;
                if ("item".equals(tag.getName()) && attribute.equals(tag.getAttributeValue("name"))) {
                    resultXmlTag.set((Object)tag);
                }
            }
        });
        return (XmlTag)resultXmlTag.get();
    }

    public void removeAttribute(@NotNull String attribute) {
        if (attribute == null) {
            ThemeEditorStyle.$$$reportNull$$$0(23);
        }
        if (!this.isProjectStyle()) {
            throw new UnsupportedOperationException("Non project styles can not be modified");
        }
        final Project project = this.myManager.getProject();
        HashSet toBeEdited = new HashSet();
        HashSet toBeRemoved = new HashSet();
        for (com.android.ide.common.res2.ResourceItem resourceItem : this.getStyleResourceItems()) {
            XmlTag sourceXml = LocalResourceRepository.getItemTag(project, resourceItem);
            assert (sourceXml != null);
            XmlTag tag = this.getValueTag(sourceXml, attribute);
            if (tag == null) continue;
            toBeEdited.add(tag.getContainingFile());
            toBeRemoved.add(tag);
        }
        new WriteCommandAction.Simple(project, "Removing " + attribute, toBeEdited.toArray(new PsiFile[toBeEdited.size()]), (Collection)toBeRemoved){
            final /* synthetic */ Collection val$toBeRemoved;
            {
                this.val$toBeRemoved = collection;
                super(x0, x1, x2);
            }

            protected void run() {
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{ThemeEditorVirtualFile.getThemeEditorFile(project)});
                for (XmlTag tag : this.val$toBeRemoved) {
                    tag.delete();
                }
            }
        }.execute();
    }

    @Nullable
    public PsiElement getNamePsiElement() {
        Collection<com.android.ide.common.res2.ResourceItem> resources = this.getStyleResourceItems();
        if (resources.isEmpty()) {
            return null;
        }
        XmlTag sourceXml = LocalResourceRepository.getItemTag(this.myManager.getProject(), resources.iterator().next());
        assert (sourceXml != null);
        XmlAttribute nameAttribute = sourceXml.getAttribute("name");
        if (nameAttribute == null) {
            return null;
        }
        XmlAttributeValue attributeValue = nameAttribute.getValueElement();
        if (attributeValue == null) {
            return null;
        }
        return new ValueResourceElementWrapper(attributeValue);
    }

    public boolean isPublic() {
        if (!this.isFramework()) {
            return true;
        }
        IAndroidTarget target = this.myManager.getTarget();
        if (target == null) {
            LOG.error("Unable to get IAndroidTarget.");
            return false;
        }
        AndroidTargetData androidTargetData = AndroidTargetData.getTargetData(target, this.myManager.getModule());
        if (androidTargetData == null) {
            LOG.error("Unable to get AndroidTargetData.");
            return false;
        }
        return androidTargetData.isResourcePublic(ResourceType.STYLE.getName(), this.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 14: 
            case 16: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedThemeName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/datamodels/ThemeEditorStyle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleResourceItems";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFolders";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findToBeCopied";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParentName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findXmlTagFromConfiguration";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getValueTag";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

