/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.vmtrace.treemodel;

import com.android.tools.idea.editors.vmtrace.treemodel.AbstractProfileDataNode;
import com.android.tools.idea.editors.vmtrace.treemodel.StatsByMethodNode;
import com.android.tools.idea.editors.vmtrace.treemodel.StatsNode;
import com.android.tools.idea.editors.vmtrace.treemodel.StatsTableColumn;
import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.MethodProfileData;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatsByThreadNode
extends AbstractProfileDataNode
implements StatsNode {
    private final VmTraceData myTraceData;
    private final ThreadInfo myThread;
    private final List<MethodInfo> myMethods;

    public StatsByThreadNode(@NotNull VmTraceData traceData, @NotNull ThreadInfo thread) {
        if (traceData == null) {
            StatsByThreadNode.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            StatsByThreadNode.$$$reportNull$$$0(1);
        }
        this.myTraceData = traceData;
        this.myThread = thread;
        this.myMethods = StatsByThreadNode.getMethodsInThread(traceData, this.myThread);
        this.setSortColumn(StatsTableColumn.INCLUSIVE_TIME, false);
    }

    @Override
    public synchronized int getChildCount() {
        return this.myMethods.size();
    }

    @NotNull
    private static List<MethodInfo> getMethodsInThread(VmTraceData traceData, ThreadInfo thread) {
        ArrayList results = Lists.newArrayList();
        for (MethodInfo info : traceData.getMethods().values()) {
            if (info.getProfileData().getInvocationCount(thread) <= 0L) continue;
            results.add(info);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            StatsByThreadNode.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public Object getChild(int index) {
        MethodInfo method = this.myMethods.get(index);
        return new StatsByMethodNode(method);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @Nullable
    protected MethodProfileData getProfileData() {
        Call topLevelCall = this.myThread.getTopLevelCall();
        if (topLevelCall == null) {
            return null;
        }
        long methodId = topLevelCall.getMethodId();
        return this.myTraceData.getMethod(methodId).getProfileData();
    }

    @Override
    @Nullable
    public Object getValueAt(int columnIndex, ThreadInfo thread, VmTraceData vmTraceData, ClockType clock) {
        StatsTableColumn column = StatsTableColumn.fromColumnIndex(columnIndex);
        switch (column) {
            case NAME: {
                return this;
            }
            case INCLUSIVE_TIME: {
                return this.renderColumn(column, thread, vmTraceData, clock);
            }
        }
        return null;
    }

    @Override
    public void setSortColumn(final StatsTableColumn sortByColumn, final boolean sortAscending) {
        Collections.sort(this.myMethods, new Comparator<MethodInfo>(){

            @Override
            public int compare(MethodInfo m1, MethodInfo m2) {
                int diff;
                switch (sortByColumn) {
                    case NAME: {
                        diff = m1.getFullName().compareTo(m2.getFullName());
                        break;
                    }
                    case INVOCATION_COUNT: {
                        diff = Ints.saturatedCast((long)(m1.getProfileData().getInvocationCount(StatsByThreadNode.this.myThread) - m2.getProfileData().getInvocationCount(StatsByThreadNode.this.myThread)));
                        break;
                    }
                    case INCLUSIVE_TIME: {
                        diff = Ints.saturatedCast((long)(m1.getProfileData().getInclusiveTime(StatsByThreadNode.this.myThread, ClockType.GLOBAL, TimeUnit.MICROSECONDS) - m2.getProfileData().getInclusiveTime(StatsByThreadNode.this.myThread, ClockType.GLOBAL, TimeUnit.MICROSECONDS)));
                        break;
                    }
                    case EXCLUSIVE_TIME: {
                        diff = Ints.saturatedCast((long)(m1.getProfileData().getExclusiveTime(StatsByThreadNode.this.myThread, ClockType.GLOBAL, TimeUnit.MICROSECONDS) - m2.getProfileData().getExclusiveTime(StatsByThreadNode.this.myThread, ClockType.GLOBAL, TimeUnit.MICROSECONDS)));
                        break;
                    }
                    default: {
                        diff = 0;
                    }
                }
                return sortAscending ? diff : -diff;
            }
        });
    }

    public String toString() {
        return "Thread " + this.myThread.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/vmtrace/treemodel/StatsByThreadNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/vmtrace/treemodel/StatsByThreadNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsInThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

